﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="s.aspx.cs" Inherits="Tuichu.Net.Search.s" %>

<%@ Register Assembly="AspNetPager" Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" %>
<%@ Register Src="~/header.ascx" TagPrefix="uc1" TagName="header" %>
<%@ Register Src="~/footer.ascx" TagPrefix="uc1" TagName="footer" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title><%=wd %>_<%=Cfg.Get("webname")%></title>
    <meta name="keywords" content="<%=key %>" />
    <meta name="description" content="<%=description %>" />
    <link rel="stylesheet" type="text/css" href="images/list.css" />
</head>
<body>
    <div id="s_page">
        <uc1:header runat="server" ID="header" />
        <div id="s_main">
            <div class="nav">
                <div id="fh" class="n_l">
                    <h1 id="spdata">
                        <%=wd %></h1>
                </div>
                <div class="n_r">
                    <%=rescount %>
                </div>
            </div>
            <table width="100%" cellspacing="0" cellpadding="0" id="main">
                <tr>
                    <td class="s_l">
                        <ol>
                            <asp:Repeater ID="rp_list" runat="server">
                                <ItemTemplate>
                                    <li class="topsp">
                                        <h3>
                                            <a href="<%#Eval("url") %>" target="_blank">
                                                <%#Eval("title") %></a></h3>
                                        <p>
                                            <%#Eval("description") %>
                                        </p>
                                        <div class="result_summary">
                                            <div class="url">
                                                <cite>
                                                    <%#Eval("linkdate")%></cite>
                                            </div>
                                        </div>
                                    </li>
                                </ItemTemplate>
                            </asp:Repeater>
                        </ol>
                        <div id="page">
                            <div class="pg">
                                <webdiyer:AspNetPager ID="aspnetpage" runat="server" FirstPageText="首页" LastPageText="尾页"
                                    NextPageText="下一页" PrevPageText="上一页" OnPageChanged="aspnetpage_PageChanged"
                                    HorizontalAlign="Center" UrlPaging="true" AlwaysShow="true" PageIndexBoxClass="flag_pg"
                                    CurrentPageButtonClass="current" ShowMoreButtons="False" ShowPageIndexBox="Never"
                                    NumericButtonCount="10">
                                </webdiyer:AspNetPager>
                            </div>
                        </div>
                        <div class="k">
                        </div>
                    </td>
                    <!--right side-->
                    <td class="s_r">
                        <div class="borl">
                            <div class="c1">
                                <h4>网友还在搜</h4>
                                <ol class="content">
                                </ol>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <div class="tj">
                            <div>
                                <table cellpadding="0" cellspacing="0">
                                    <tr>
                                        <th valign="top" rowspan="2">
                                            <b>相关搜索</b>
                                        </th>
                                        <asp:Repeater ID="rp_key1" runat="server">
                                            <ItemTemplate>
                                                <td valign="top">
                                                    <a href="<%=resurl %>?wd=<%#Server.UrlEncode(Container.DataItem.ToString()) %>">
                                                        <%#Container.DataItem %></a>
                                                </td>
                                            </ItemTemplate>
                                        </asp:Repeater>
                                    </tr>
                                    <tr>
                                        <asp:Repeater ID="rp_key2" runat="server">
                                            <ItemTemplate>
                                                <td valign="top">
                                                    <a href="<%=resurl %>?wd=<%#Server.UrlEncode(Container.DataItem.ToString()) %>">
                                                        <%#Container.DataItem %></a>
                                                </td>
                                            </ItemTemplate>
                                        </asp:Repeater>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </td>
                </tr>
            </table>
        </div>
        <uc1:footer runat="server" id="footer" />
    </div>
</body>
</html>