﻿<%@ Page Title="客户关系配置" Language="C#" MasterPageFile="~/Admin/MasterPage.master"
    AutoEventWireup="true" CodeBehind="CrmConfig.aspx.cs" Inherits="PowerEasy.Module.Crm.WebSite.Admin.Configuration.CrmConfigUI" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <strong>客户关系配置</strong>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>自动释放客户状态： </strong>
            </td>
            <td>
                <asp:Label ID="LblAutoReleaseStatus" runat="server"></asp:Label>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>开启自动释放客户： </strong>
            </td>
            <td>
                <asp:DropDownList ID="DropEnable" runat="server">
                    <asp:ListItem Value="True">启用</asp:ListItem>
                    <asp:ListItem Value="False" Selected="True">停用</asp:ListItem>
                </asp:DropDownList>
                <div id="div_cond">
                    <div>
                        自动释放：
                        <asp:DropDownList ID="DropNoContact" runat="server">
                            <asp:ListItem Value="7">一个星期</asp:ListItem>
                            <asp:ListItem Value="15">15天</asp:ListItem>
                            <asp:ListItem Value="30" Selected="True">1个月</asp:ListItem>
                            <asp:ListItem Value="60">2个月</asp:ListItem>
                            <asp:ListItem Value="90">3个月</asp:ListItem>
                            <asp:ListItem Value="180">6个月</asp:ListItem>
                        </asp:DropDownList> 没有联系的客户
                    </div>
                    <div>
                        执行时间：
                        <asp:DropDownList ID="DropReleaseTime" runat="server">
                            <asp:ListItem Value="00:00" Selected="True">00:00</asp:ListItem>
                            <asp:ListItem Value="00:30">00:30</asp:ListItem>
                            <asp:ListItem Value="01:00">01:00</asp:ListItem>
                            <asp:ListItem Value="01:30">01:30</asp:ListItem>
                            <asp:ListItem Value="02:00">02:00</asp:ListItem>
                            <asp:ListItem Value="02:30">02:30</asp:ListItem>
                            <asp:ListItem Value="03:00">03:00</asp:ListItem>
                            <asp:ListItem Value="03:30">03:30</asp:ListItem>
                            <asp:ListItem Value="04:00">04:00</asp:ListItem>
                            <asp:ListItem Value="04:30">04:30</asp:ListItem>
                            <asp:ListItem Value="05:00">05:00</asp:ListItem>
                            <asp:ListItem Value="05:30">05:30</asp:ListItem>
                            <asp:ListItem Value="06:00">06:00</asp:ListItem>
                        </asp:DropDownList>
                    </div>
                </div>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>允许拥有的最大客户数量： </strong>
            </td>
            <td>
                <asp:TextBox ID="TxtMaxClient" runat="server" Columns="5" MaxLength="5" Width="135px" />
                <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="TxtMaxClient"
                    ErrorMessage="只能输入数字，并且不能为负数" ValidationExpression="^[0-9]+" Display="Dynamic" />
            </td>
        </tr>
         <tr class="tdbg">
            <td class="tdbgleft">
                <strong>每天录入超过**个客户的联系记录时进行真实性确认提示：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtDayWarningClient" runat="server" Columns="5" MaxLength="5" Width="135px" />
                <asp:RegularExpressionValidator ID="revTxtDayWarningClient" runat="server" ControlToValidate="TxtDayWarningClient"
                    ErrorMessage="只能输入数字，并且不能为负数" ValidationExpression="^[0-9]+" Display="Dynamic" />
            </td>
        </tr>
         <tr class="tdbg">
            <td class="tdbgleft">
                <strong>每天允许录入最大客户数量：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtDayMaxClient" runat="server" Columns="5" MaxLength="5" Width="135px" />
                <asp:RegularExpressionValidator ID="revTxtDayMaxClient" runat="server" ControlToValidate="TxtDayMaxClient"
                    ErrorMessage="只能输入数字，并且不能为负数" ValidationExpression="^[0-9]+" Display="Dynamic" />
            </td>
        </tr>
       
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>重点项目销售预测成功率：</strong><br />
            </td>
            <td>
                <asp:TextBox ID="txtSalesESRatio" runat="server" Width="135px"></asp:TextBox>%
                <asp:RangeValidator ID="valSalesESRatio" runat="server" ControlToValidate="txtSalesESRatio"
                    Type="Integer" MaximumValue="100" MinimumValue="0" ErrorMessage="请输入0到100之间的数字"></asp:RangeValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>重点项目项目金额：</strong><br />
            </td>
            <td>
                <asp:TextBox ID="txtPrice" runat="server" Width="135px" MaxLength="8"></asp:TextBox>元
                <asp:CompareValidator ID="VlcPrice" runat="server" ControlToValidate="txtPrice" Display="Dynamic"
                    ErrorMessage="请输入大于0的整数值！" Operator="GreaterThanEqual" SetFocusOnError="True"
                    Type="Integer" ValueToCompare="0"></asp:CompareValidator>
            </td>
        </tr>
        <tr class="tdbgbottom">
            <td colspan="2">
                <asp:Button ID="BtnSubmit" runat="server" Text="保存设置" OnClick="BtnSubmit_Click" />
            </td>
        </tr>
    </table>

    <script type="text/javascript">
        jQuery(function () {
            CheckEnable();
            jQuery("#<% =DropEnable.ClientID%>").change(function () {
                CheckEnable();
            });
        });

        function CheckEnable() {
            if (jQuery("#<% =DropEnable.ClientID%>").val() == "True") {
                jQuery("#div_cond").show();
            } else {
                jQuery("#div_cond").hide();
            }
        }
    </script>
</asp:Content>
