﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="PowerEasy.Module.General.WebSite.Admin.Contents.Model"
    MasterPageFile="~/Admin/MasterPage.master" Title="内容模型添加/修改" ValidateRequest="false"
    CodeBehind="Model.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <asp:ScriptManager ID="scriptmanage1" runat="server" />
    <table class="border" width="100%" cellpadding="2" cellspacing="1">
        <tr>
            <td class="spacingtitle" colspan="2" align="center">
                <pe:AlternateLiteral ID="AltrTitle" Text="添加内容模型" AlternateText="修改内容模型" runat="Server" />
            </td>
        </tr>
        <tr class="tdbg" runat="server" id="trModelTemmpalteId">
            <td class="tdbgleft">
                <strong>载入内容模型模板：</strong>
            </td>
            <td>
                <asp:DropDownList ID="DropModelTemplate" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 35%">
                <strong>内容模型名称：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtModelName" runat="server" Width="156" MaxLength="100" />
                <pe:RequiredFieldValidator ID="ValrModelName" ControlToValidate="TxtModelName" runat="server"
                    ErrorMessage="内容模型名称不能为空！" SetFocusOnError="true" Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>创建的数据表名：</strong>
                <pe:AlternateLiteral ID="TableNameText" Text="<br /><span style='color: red'>注意：</span>创建表后将无法再更改表名称"
                    runat="Server" />
            </td>
            <td>
                <asp:Label ID="LblTablePrefix" runat="server" Text="PE_U_" />
                <asp:TextBox ID="TxtTableName" runat="server" Width="120" MaxLength="50" />
                <pe:RequiredFieldValidator ID="ValrTableName" ControlToValidate="TxtTableName" runat="server"
                    ErrorMessage="数据表名不能为空" SetFocusOnError="true" Display="Dynamic" />
                <asp:RegularExpressionValidator ID="ValeTableName" runat="server" ControlToValidate="TxtTableName"
                    ErrorMessage="只允许输入字母、数字或下划线" ValidationExpression="^[\w_]+$" SetFocusOnError="true"
                    Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>项目名称：</strong>
                <br />
                例如：文章、软件、图片、商品
            </td>
            <td>
                <asp:TextBox ID="TxtItemName" runat="server" Width="156" MaxLength="20" />
                <pe:RequiredFieldValidator ID="ValrItemName" ControlToValidate="TxtItemName" runat="server"
                    ErrorMessage="项目名称不能为空" SetFocusOnError="true" Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>项目单位：</strong>
                <br />
                例如：篇、个、件
            </td>
            <td>
                <asp:TextBox ID="TxtItemUnit" runat="server" Width="156" MaxLength="20" />
                <pe:RequiredFieldValidator ID="ValrItemUnit" ControlToValidate="TxtItemUnit" runat="server"
                    ErrorMessage="项目单位不能为空" SetFocusOnError="true" Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>项目图标：</strong>
                <br />
                图标存放在~/Images/ModelIcon/目录下
            </td>
            <td>
                <asp:TextBox ID="TxtItemIcon" Text="Default.gif" runat="server" Width="156" MaxLength="20" />
                <asp:Image ID="ImgItemIcon" runat="server" ImageUrl="~/Images/ModelIcon/Default.gif" />
                <=<asp:DropDownList ID="DrpItemIcon" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>模型描述：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtDescription" runat="server" TextMode="MultiLine" Width="365px"
                    Height="43px" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>默认内容页模板：</strong>
            </td>
            <td>
                <pe:TemplateSelectControl ID="FileCTemplate" runat="server" Width="300px" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>打印页模板：</strong>
            </td>
            <td>
                <pe:TemplateSelectControl ID="TscPrintTemplate" runat="server" Width="300px" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>栏目搜索页模板：</strong>
            </td>
            <td>
                <pe:TemplateSelectControl ID="TscSearchTemplate" runat="server" Width="300px" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>高级搜索表单页模板：</strong>
            </td>
            <td>
                <pe:TemplateSelectControl ID="TscAdvanceSearchFormTemplate" runat="server" Width="300px" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>高级搜索页模板：</strong>
            </td>
            <td>
                <pe:TemplateSelectControl ID="TscAdvanceSearchTemplate" runat="server" Width="300px" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>查看评论模板：</strong>
            </td>
            <td>
                <pe:TemplateSelectControl ID="TscCommentManageTemplate" runat="server" Width="300px" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>会员中心用户发表信息页模板：</strong>
            </td>
            <td>
                <pe:TemplateSelectControl ID="TscUserAddContentTemplate" runat="server" Width="300px" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>匿名投稿模板：</strong>
            </td>
            <td>
                <pe:TemplateSelectControl ID="TscAnonymouseAddContentTemplate" runat="server" Width="300px" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>信息发布文件：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtAddInfoFilePath" runat="server" Width="156" MaxLength="200" Text="Content.aspx" />
                <pe:RequiredFieldValidator ID="ValrAddInfoFilePath" ControlToValidate="TxtAddInfoFilePath"
                    runat="server" ErrorMessage="信息发布文件不能为空" SetFocusOnError="true" Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>信息管理文件：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtManageInfoFilePath" runat="server" Width="156" MaxLength="200"
                    Text="ContentManage.aspx" />
                <pe:RequiredFieldValidator ID="ValrManageInfoFilePath" ControlToValidate="TxtManageInfoFilePath"
                    runat="server" ErrorMessage="信息管理文件不能为空" SetFocusOnError="true" Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>信息预览文件：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtPreviewInfoFilePath" runat="server" Width="156" MaxLength="200"
                    Text="ContentView.aspx" />
                <pe:RequiredFieldValidator ID="ValrPreviewInfoFilePath" ControlToValidate="TxtPreviewInfoFilePath"
                    runat="server" ErrorMessage="信息预览文件不能为空" SetFocusOnError="true" Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>信息批量设置文件：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtBatchInfoFilePath" runat="server" Width="156" MaxLength="200"
                    Text="ContentBatch.aspx" />
                <pe:RequiredFieldValidator ID="ValrBatchInfoFilePath" ControlToValidate="TxtBatchInfoFilePath"
                    runat="server" ErrorMessage="信息量设置文件不能为空" SetFocusOnError="true" Display="Dynamic" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>自定义内容发布和管理页注意事项：</strong>
            </td>
            <td style="width: 80%">
                如果以上四项使用了自定义的程序文件，请将文件存放在“~/Admin/Contents/”目录下。
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否统计点击数：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadioIsCountHits" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否禁用：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadioDisabled" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg" runat="server" id="EnableCharge">
            <td class="tdbgleft">
                <strong>是否启用收费：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadioEnableCharge" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg" runat="server" id="EnableChargeTips">
            <td class="tdbgleft">
                <strong>生成静态页时的收费提示：</strong><br />
                支持HTML代码，特别标签有：<br />
                {$ModelName} 模型名称<br />
                {$FileName} 文件夹名<br />
                {$Id} 信息的GeneralId<br />
            </td>
            <td>
                <asp:TextBox ID="TxtModelChargeTips" TextMode="MultiLine" MaxLength="255" Width="365px"
                    Height="43px" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg" runat="server" id="EnableNeedPointChargeTips">
            <td class="tdbgleft">
                <strong>
                    <asp:Literal ID="Literal1" runat="server"></asp:Literal>点卷数额不足时的收费提示：</strong><br />
                支持HTML代码，特别标签有：<br />
                {$InfoPoint} 需要点卷数<br />
                {$ItemName} 项目名称 {$NowPoint} 会员点卷<br />
                {$PointName} 点卷名称 {$PointUnit} 点卷单位<br />
            </td>
            <td>
                <asp:TextBox ID="TxtNeedPointChargeTips" TextMode="MultiLine" MaxLength="255" Width="365px"
                    Height="53px" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg" runat="server" id="EnableOutTimeChargeTips">
            <td class="tdbgleft">
                <strong>有效期不足时的收费提示：</strong><br />
                支持HTML代码，特别标签有：<br />
                {$ItemName} 项目名称<br />
            </td>
            <td>
                <asp:TextBox ID="TxtOutTimeChargeTips" TextMode="MultiLine" MaxLength="255" Width="365px"
                    Height="43px" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg" runat="server" id="EnableUsePointChargeTips">
            <td class="tdbgleft">
                <strong>查看收费信息时的收费提示：</strong><br />
                支持HTML代码，特别标签有：<br />
                {$url} 阅读跳转路径 {$ItemName} 项目名称<br />
                {$PointUnit} 点卷单位 {$NowPoint} 会员点卷<br />
                {$InfoPoint} 需要点卷数 {$PointName} 点卷名称<br />
                {$FinalPoint} 剩余点卷数 {$InstallDir} 不阅读虚拟路径<br />
            </td>
            <td>
                <asp:TextBox ID="TxtUsePointChargeTips" TextMode="MultiLine" MaxLength="255" Width="365px"
                    Height="53px" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否启用签收：</strong><br />
                开启签收需要在内容页模板中添加如下标签：{PE.Label id="内容签收" itemId="@RequestInt_id" /}
            </td>
            <td>
                <asp:RadioButtonList ID="RadioEnableSignin" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否启用投票：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadVote" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>用户前台发表信息是否开启验证码：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadEnableVerificationCode" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="Flow">
                    <asp:ListItem Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>用户在此模型下发表内容的限制数：</strong>
                <br />
                此限制数是为用户在该模型下发表所有文章数来计算的，设为0表示没有限制。
            </td>
            <td>
                <asp:TextBox ID="TxtMaxPerUser" runat="server" MaxLength="6" Text="0" Width="36" />个内容
            </td>
        </tr>
        <tr class="tdbg" id="TrEnalbeWap" runat="server" visible="false">
            <td class="tdbgleft" style="width: 35%">
                <strong>是否启用WAP功能：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadEnableWap" runat="server" RepeatDirection="Horizontal"
                    onclick="wapSelect()" RepeatLayout="Flow">
                    <asp:ListItem Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False" Selected="True">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr id="TrFeildparallelism" class="tdbg" runat="server">
            <td class="tdbgleft" colspan="2">
                <table class="border" width="100%" border="0" style="margin: 0 auto;" cellpadding="2"
                    cellspacing="1">
                    <tr class="tdbg">
                        <td class="tdbgleft">
                            <strong>WAP字段</strong>
                        </td>
                        <td>
                            <strong>对应内容模型字段</strong>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" style="width: 35%">
                            <strong>标题(Title)</strong>
                        </td>
                        <td>
                            <asp:DropDownList ID="dropTitle" runat="server" DataTextField="FieldName" DataValueField="ID">
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" style="width: 35%">
                            <strong>内容(Content)</strong>
                        </td>
                        <td>
                            <asp:DropDownList ID="dropContent" runat="server" DataTextField="FieldName" DataValueField="ID">
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" style="width: 35%">
                            <strong>作者(Author)</strong>
                        </td>
                        <td>
                            <asp:DropDownList ID="dropAuthor" runat="server" DataTextField="FieldName" DataValueField="ID">
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" style="width: 35%">
                            <strong>状态(Status)</strong>
                        </td>
                        <td>
                            <asp:DropDownList ID="dropStatus" runat="server" DataTextField="FieldName" DataValueField="ID">
                            </asp:DropDownList>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr class="tdbgbottom">
            <td colspan="2">
                <asp:Button ID="EBtnSubmit" Text="保存" OnClick="EBtnSubmit_Click" runat="server" />
                &nbsp;&nbsp;
                <input name="Cancel" type="button" class="inputbutton" id="Cancel" value="取消" onclick="Redirect('ModelManage.aspx')" />
            </td>
        </tr>
    </table>
    <asp:HiddenField ID="HdnModelId" runat="server" />
    <asp:HiddenField ID="HdnModelName" runat="server" />
    <asp:HiddenField ID="HdnTableName" runat="server" />

    <script type="text/javascript">
        function wapSelect() {
            var TrFeildparallelism = jQuery("#<%= TrFeildparallelism.ClientID %>");
            var RadEnableWap = jQuery("#<%=RadEnableWap.ClientID %> input");
            if (RadEnableWap.prop("checked")) {
                TrFeildparallelism.show();
            }
            else {
                TrFeildparallelism.hide();
            }
        }

        function ChangeImgItemIcon(icon) {
            document.getElementById("<%= ImgItemIcon.ClientID %>").src = "../../Images/ModelIcon/" + icon;
        }
        function ChangeTxtItemIcon(icon) {
            document.getElementById("<%= TxtItemIcon.ClientID %>").value = icon;
        }
        function CheckLength(obj, maxLength) {
            if (obj.value.length > maxLength) {
                obj.value = obj.value.substring(0, maxLength - 1);
                alert("字符长度不能超过" + maxLength + "个字符");
            }
        }
    </script>

</asp:Content>
