﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/Admin/MasterPage.master"
    Codebehind="SpecialCategoryManage.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.Contents.SpecialCategoryManage"
    Title="专题类别管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="EgvSpecialCategory" runat="server" AutoGenerateColumns="False"
        DataKeyNames="SpecialCategoryID" DataSourceID="OdsSpecialCategory" SerialText=""
        OnRowDataBound="EgvSpecialCategory_RowDataBound"
         RowDblclickBoundField="SpecialCategoryID" 
        RowDblclickUrl="SpecialCategory.aspx?Action=Modify&amp;SpecialCategoryID={$Field}">
        <Columns>
            <pe:TemplateField>
                <HeaderTemplate>
                    专题类别操作
                </HeaderTemplate>
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                    <pe:DropdownMenu runat="server" ID="ddmenu">
                        <pe:LinkMenuItem ID="HypSpecialAdd" Text="添加专题" runat="server" />
                        <pe:LinkMenuItem ID="HypSpecialBathAdd" Text="批量添加专题" runat="server" />
                        <pe:LinkMenuItem ID="EahSpecialManage" Text="专题列表" runat="server" />
                        <pe:LinkMenuItem ID="HypSpecialOrder" Text="专题排序" runat="server" />
                        <pe:LinkMenuItem ID="EahSpecialCategoryModify" SkinID="Edit" runat="server" />
                        <pe:LinkMenuItem ID="EahSpecialCategoryDelete" SkinID="Delete" runat="server" />
                    </pe:DropdownMenu>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="SpecialCategoryID" HeaderText="ID" SortExpression="SpecialCategoryID">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:BoundField DataField="SpecialCategoryName" HeaderText="专题类别名称" SortExpression="SpecialCategoryName">
                <HeaderStyle Width="30%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="专题类别描述" SortExpression="Description">
                <ItemStyle HorizontalAlign="Left" />
                <ItemTemplate>
                    <%# Eval("Description").ToString()%>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsSpecialCategory" runat="server" SelectMethod="GetSpecialCategoryList"
        TypeName="PowerEasy.Module.General.BusinessLogic.Contents.Special"></asp:ObjectDataSource>
<br />
        <input type='button' class="inputbutton" value='添加专题类别' onclick="location.href='SpecialCategory.aspx'" />
        &nbsp;&nbsp;
        <input type='button' class="inputbutton" value='专题类别排序' onclick="location.href='SpecialCategoryOrder.aspx'" />
</asp:Content>
