﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="CodeSnippetPanel.ascx.cs"
    Inherits="PowerEasy.Module.General.WebSite.Admin.Controls.Common.CodeSnippetPanel" %>
<style type="text/css">
    .dragspandiv, .dragspandiv_alt, .dragspandiv_ctrl, .spanfixdiv, .nodediv, .havechilediv, .attribdiv, .alertspandiv
    {
        text-align: center;
        height: 20px;
        line-height: 20px;
        overflow: hidden;
        padding: 0 4px;
    }
    .dragspandiv
    {
        filter: alpha(opacity=80);
        opacity: 0.8;
        background-color: #E5C0E4;
        border: 1px solid #D495D2;
    }
    .dragspandiv_alt
    {
        background-color: #CCFFCC;
        opacity: 0.8;
        filter: alpha(opacity=80);
        border: 1px solid #00FF00;
    }
    .dragspandiv_ctrl
    {
        background-color: #CCCCFF;
        opacity: 0.8;
        filter: alpha(opacity=80);
        border: 1px solid #0000FF;
    }
    .spanfixdiv
    {
        margin: 4px auto;
        background-color: #FFFBF5;
        border: 1px solid #F6B9D6;
        cursor: pointer;
        cursor: hand;
        height: 20px;
        width: 160px;
    }
    #fixdiv
    {
        margin: 7px;
    }
    .nodediv
    {
        background-color: #FFFBF5;
        border: 1px solid #F6B9D6;
        cursor: pointer;
        cursor: hand;
    }
    .havechilediv
    {
        background-color: #FFCCCC;
        border: 1px solid #FF2222;
        cursor: pointer;
        cursor: hand;
        font-weight: bolder;
    }
    .attribdiv
    {
        background-color: #F5FFF5;
        border: 1px solid #B9F6D6;
        cursor: pointer;
        cursor: hand;
    }
    .finaltxt
    {
        border: 1px solid #F6B9D6;
    }
    .nodefixdiv
    {
        background-color: #FFFBF5;
        border: 1px solid #F6B9D6;
        cursor: pointer;
        cursor: hand;
    }
    .alertspandiv
    {
        background-color: #FFEBE5;
        border: 1px solid #F6B9D6;
    }
    #rightMenu
    {
        visibility: hidden;
        padding: 2px;
        background-color: menu;
        cursor: default;
        position: absolute;
        z-index: 900;
        border-right: 1px solid #aaa;
        border-bottom: 1px solid #aaa;
        border-top: 1px solid #fff;
        border-left: 1px solid #fff;
        font-size: 14px;
        word-break: keep-all;
    }
    .menuItem
    {
        display: block;
        padding: 3px;
    }
</style>
<div style="height: 430px; width: 200px;">
    <div id="CodeSnippetPanelDiv" runat="server" style="margin: 2px 0 0 2px;">
        <asp:PlaceHolder ID="DivAttribute" runat="server" Visible="false">
            <h3>
                <a href="###">属性列表</a></h3>
            <div>
                <pe:ExtendedLabel HtmlEncode="false" ID="attlist" runat="server"></pe:ExtendedLabel>
            </div>
        </asp:PlaceHolder>
        <pe:ExtendedLiteral ID="SysCodeSnippetList" HtmlEncode="false" runat="server"></pe:ExtendedLiteral>
        <h3>
            <a href="###">代码片断</a></h3>
        <div>
            <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                <ContentTemplate>
                    <center>
                        <asp:DropDownList ID="CodeSnippetDropDownList" runat="server" AutoPostBack="true"
                            OnSelectedIndexChanged="CodeSnippetDropDownList_SelectedIndexChanged" />
                        <asp:TextBox ID="CodeSnippetSearch" runat="server">
                        </asp:TextBox><br />
                        <asp:Button ID="BtnCodeSnippetSearch" runat="server" Text="搜索" OnClick="BtnCodeSnippetSearch_Click">
                        </asp:Button><br />
                    </center>
                    <div>
                        <pe:ExtendedLabel HtmlEncode="false" ID="LblCodeSnippetList" runat="server"></pe:ExtendedLabel>
                    </div>
                </ContentTemplate>
            </asp:UpdatePanel>
        </div>
        <asp:PlaceHolder ID="DivGroupContainerLabel" runat="server" Visible="false">
            <h3>
                <a href="###">布局模板</a></h3>
            <div>
                <div>
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblGroupContainerLabelList" runat="server"></pe:ExtendedLabel>
                </div>
            </div>
        </asp:PlaceHolder>
        <asp:PlaceHolder ID="DivContentLabel" runat="server" Visible="false">
            <h3>
                <a href="###">内容标签</a></h3>
            <div>
                <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                    <ContentTemplate>
                        <center>
                            <asp:DropDownList ID="ContentLabelDropDownList" runat="server" AutoPostBack="true"
                                OnSelectedIndexChanged="ContentLabelDropDownList_SelectedIndexChanged" />
                            <asp:TextBox ID="LabelSearch" runat="server">
                            </asp:TextBox><br />
                            <asp:Button ID="BtnLabelSearch" runat="server" Text="搜索" OnClick="BtnLabelSearch_Click">
                            </asp:Button><br />
                        </center>
                        <div>
                            <pe:ExtendedLabel HtmlEncode="false" ID="LblLabelList" runat="server"></pe:ExtendedLabel>
                        </div>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </div>
        </asp:PlaceHolder>
        <asp:PlaceHolder ID="DivPagerLabel" runat="server" Visible="false">
            <h3>
                <a href="###">分页标签</a></h3>
            <div>
                <asp:UpdatePanel ID="UpdatePanel3" runat="server">
                    <ContentTemplate>
                        <center>
                            <asp:DropDownList ID="PagerLabelDropDownList" runat="server" AutoPostBack="true"
                                OnSelectedIndexChanged="PagerLabelDropDownList_SelectedIndexChanged" />
                        </center>
                        <div>
                            <pe:ExtendedLabel HtmlEncode="false" ID="LblPageList" runat="server"></pe:ExtendedLabel>
                        </div>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </div>
        </asp:PlaceHolder>
        <asp:PlaceHolder ID="DivQuickPositioning" runat="server" Visible="false">
            <h3>
                <a href="###" onclick="rebulideuselist">快速定位</a></h3>
            <div>
                <center>
                    <input name="rbl" type="button" class="inputbutton" id="rbl" value="刷新列表" onclick="rebulideuselist()" /></center>
                <div id="thispagelabel">
                </div>
            </div>
        </asp:PlaceHolder>
    </div>
</div>
<script type="text/javascript">
    $(function () {
        $('#<% =CodeSnippetPanelDiv.ClientID %>').accordion({ fillSpace: true, collapsible: true });
    });
</script>
<script type="text/javascript">
    var start = 0, end = 0;
    var x, y;
    var presskey = '';
    var dragspan;
    var inserttext;
    var isClose = false;
    var nn6 = document.getElementById && !document.all; //IE下为FALSE 在火狐下为true.ie支持document.all 而firefox 不支持
    var isdrag = false;
    var handle;
    var closeByButton = false;

    function initDrag(e) {
        var oDragHandle = nn6 ? e.target : event.srcElement; //获取事件源IE下event.srcElement有效,火狐下为e.target有效
        handle = oDragHandle;
        if (oDragHandle.className == "spanfixdiv" || oDragHandle.className == "spanfixdiv" || oDragHandle.className == "havechilediv" || oDragHandle.className == "attribdiv" || oDragHandle.className == "nodediv") {
            isdrag = true;
            isClose = false;
            dragspan = document.createElement('div');
            dragspan.style.position = "absolute";
            switch (presskey) {
                case 'ctrl':
                    dragspan.className = "dragspandiv_ctrl";
                    break;
                case 'alt':
                    dragspan.className = "dragspandiv_alt";
                    break;
                default:
                    dragspan.className = "dragspandiv";
                    break;
            }
            //获取鼠标在数据源事件的坐标
            y = nn6 ? e.clientY + 5 : event.clientY + 5;
            x = nn6 ? e.clientX + 10 : event.clientX + 10;
            dragspan.style.width = oDragHandle.style.width;
            dragspan.style.height = oDragHandle.style.height;
            dragspan.style.top = y + "px"; //在火狐中必须加上"px"
            dragspan.style.left = x + "px";
            dragspan.innerHTML = oDragHandle.innerHTML;
            document.body.appendChild(dragspan);
            document.onmousemove = moveMouse;
            txtproce(oDragHandle);

            //如果是通过关闭按钮关闭窗口的就清楚拖动块
            jQuery(".floatingDialogClose").click(function () {
                if (!closeByButton) {
                    ClearDragspan();
                }
            });
            return false;
        }
    }

    function moveMouse(e) {
        if (isdrag) {
            dragspan.style.top = (nn6 ? e.clientY : event.clientY) + document.documentElement.scrollTop + 5 + "px";
            dragspan.style.left = (nn6 ? e.clientX : event.clientX) + document.documentElement.scrollLeft + 10 + "px";
            return false;
        }
    }
    //拖动标签
    function dragend(textBox) {
        if (isdrag) {
            savePos(textBox);
            cit();
        }
    }
    //关闭弹出层
    function CloseWindow() {
        if (!closeByButton) {
            ClearDragspan();
        }
        jQuery(".floatingDialogClose").click();
    }
    function savePos(textBox) {
        if (typeof (textBox.selectionStart) == "number") {
            start = textBox.selectionStart;
            end = textBox.selectionEnd;
        }
    }

    function cit() {
        var target = $get('<% =TxtTemplateClientID %>');
        if (nn6) {
            var pre = target.value.substr(0, start);
            var post = target.value.substr(end);
            target.value = pre + inserttext + post;
        }
        else {
            target.focus();
            var range = document.selection.createRange();
            range.text = inserttext;
        }
        ClearDragspan();
    }
    //清除生成的移动标签
    function ClearDragspan() {
        isdrag = false;
        closeByButton = false;
        if (dragspan != null) {
            document.body.removeChild(dragspan);
            dragspan = null;
        }
    }
    function DragPos(textBox) {
        if (isdrag) {
            try {
                if (nn6) {
                    textBox.focus();
                }
                else {
                    var rng = textBox.createTextRange();
                    rng.moveToPoint(event.x, event.y);
                    rng.select();
                }
            } catch (e) { }
        }

    }
    //设置插入的标签的值
    function getInsertText(text) {
        inserttext = text;
    }
    //弹出层关闭标示
    function isClosed() {
        isClose = true;
    }

    function txtproce(selectobj) {
        switch (selectobj.getAttribute("outype")) {
            case '0':
                switch (presskey) {
                    case 'ctrl':
                        inserttext = "<xsl:apply-templates select=\"" + selectobj.getAttribute("path") + "/" + selectobj.getAttribute("tn") + "\"/>";
                        break;
                    case 'alt':
                        inserttext = "<xsl:template match=\"" + selectobj.getAttribute("path") + "/" + selectobj.getAttribute("tn") + "\">\n</xsl:template>";
                        break;
                    default:
                        inserttext = "<xsl:for-each select=\"" + selectobj.getAttribute("path") + "/" + selectobj.getAttribute("tn") + "\">\n</xsl:for-each>";
                        break;
                }
                break;
            case '1':
                switch (presskey) {
                    case 'ctrl':
                        inserttext = "<xsl:value-of select=\"" + selectobj.getAttribute("path") + "/" + selectobj.getAttribute("tn") + "\"/>";
                        break;
                    case 'alt':
                        inserttext = "{" + selectobj.getAttribute("path") + "/" + selectobj.getAttribute("tn") + "}";
                        break;
                    default:
                        inserttext = "<xsl:value-of select=\"" + selectobj.getAttribute("tn") + "\"/>";
                        break;
                }
                break;
            case '2':
                switch (presskey) {
                    case 'ctrl':
                        inserttext = "<xsl:value-of select=\"" + selectobj.getAttribute("path") + "/$" + selectobj.getAttribute("tn") + "\"/>";
                        break;
                    case 'alt':
                        inserttext = "{" + selectobj.getAttribute("path") + "/$" + selectobj.getAttribute("tn") + "}";
                        break;
                    default:
                        inserttext = "<xsl:value-of select=\"$" + selectobj.getAttribute("tn") + "\"/>";
                        break;
                }
                break;
            case '3':
                switch (presskey) {
                    case 'ctrl':
                        inserttext = "<xsl:param name=\"" + selectobj.innerHTML + "\" />";
                        break;
                    case 'alt':
                        inserttext = "$" + selectobj.innerHTML;
                        break;
                    default:
                        inserttext = "<xsl:value-of select=\"$" + selectobj.innerHTML + "\" />";
                        break;
                }
                break;
            case '4':
                inserttext = selectobj.getAttribute("code").replace(/&qout;/g, "\"");
                break;
            case '5':
                switch (presskey) {
                    case 'ctrl':
                        inserttext = "<xsl:value-of select=\"" + "pe:" + selectobj.getAttribute("code").replace(/&qout;/g, "'") + "\" />";
                        break;
                    case 'alt':
                        inserttext = "{" + "pe:" + selectobj.getAttribute("code").replace(/&qout;/g, "'") + "}";
                        break;
                    default:
                        inserttext = "pe:" + selectobj.getAttribute("code").replace(/&qout;/g, "'");
                        break;
                }
                break;
            case '6':
                inserttext = "<a href=\"" + selectobj.getAttribute("itemurl") + "\">" + selectobj.innerHTML + "</a>";
                break;
            case '7':
                inserttext = "{PE.TemplateCreator." + selectobj.getAttribute("code").replace(/&qout;/g, "'") + "}";
                break;
            case '21':
                var link = "Template_AddLabel.aspx?a=a&n=" + escape(selectobj.innerHTML);
                var title = handle.innerHTML; //弹出层标题
                isRightMenu = false;
                ShowWindow(link, title);
                break;
            case '22':
                var fstr = "";
                var tmbody = $get("<% =TxtTemplateClientID %>").value;

                tmbody = tmbody.replace(/\n/g, "");
                var regExp = /({PE\.Label|{PE\.DataSource)([\s\S](?!{))*?\/}/g;
                var arr;
                while ((arr = regExp.exec(tmbody)) != null) {
                    if (arr[0].indexOf('page=\"true\"', 3, true) > 0) {
                        var temp = "";
                        var myregexp = /id=\"(.*?)\"/;

                        var match = myregexp.exec(arr[0]);
                        if (match != null) {
                            fstr += match[1] + "|||";
                        }
                    }
                }
                var link = "Template_AddPage.aspx?n=" + escape(selectobj.innerHTML) + "&b=" + escape(fstr);
                var title = handle.innerHTML; //弹出层标题
                isRightMenu = false;
                ShowWindow(link, title);
                break;
            case '23':
                inserttext = "{PE.Label " + selectobj.innerHTML + "/}";
                break;
            case '24':
                inserttext = "{PE.SiteConfig." + selectobj.getAttribute("code").replace(/&qout;/g, "'") + " /}";
                break;
            case '100':
                var link = "Template_AddControl.aspx";
                inserttext = "";
                var title = handle.innerHTML; //弹出层标题
                isRightMenu = false;
                ShowWindow(link, title);
                break;
            case '101':
                inserttext = "";
                var tbody = $get("<% =TxtTemplateClientID %>").value;
                var reDS = /\{PE\.DataSource([\s\S](?!\{PE))*?\/\}/gi;
                var r = tbody.match(reDS);
                var link = (null == r) ? "Template_AddField.aspx" : "Template_AddField.aspx?match=" + escape(r);
                var title = handle.innerHTML; //弹出层标题
                isRightMenu = false;
                ShowWindow(link, title);
                break;
            default:
                break;
        }
        //rebulideuselist();
    }
    document.onmousedown = initDrag;

    document.onmouseup = function () {
        if (isClose) {
            ClearDragspan();
        }
    }

    document.onkeyup = function () {
        presskey = '';
    }
    //通过键盘值切换不同的样式
    document.onkeydown = function (e) {
        var isie = (document.all) ? true : false;
        var key;
        if (isie)
            key = window.event.keyCode;
        else
            key = e.which;

        if (key == 18) {
            presskey = 'alt';
        }
        else if (key == 17) {
            presskey = 'ctrl';
        }
        else {
            presskey = '';
        }
    }

    /* 重载indexof方法，不区分大小写  */
    String.prototype._indexOf = String.prototype.indexOf;
    String.prototype.indexOf = function () {
        if (typeof (arguments[arguments.length - 1]) != 'boolean') {
            return this._indexOf.apply(this, arguments);
        }
        else {
            var bi = arguments[arguments.length - 1];
            var thisObj = this;
            var idx = 0;
            if (typeof (arguments[arguments.length - 2]) == 'number') {
                idx = arguments[arguments.length - 2];
                thisObj = this.substr(idx);
            }

            var re = new RegExp(arguments[0], bi ? 'i' : '');
            var r = thisObj.match(re);
            return r == null ? -1 : r.index + idx;
        }
    }

    /* 编辑器右键处理  */
    JRightMenu = function (menuItem, handle) {
        var rightMenu = document.createElement("div");
        var menuInnerHTML = ""; //菜单容器里的HTML内容
        var $items = this.menuItem = menuItem; //右键菜单
        var $handle = this.handle = handle;
        rightMenu.id = "rightMenu"; //id
        for (var i in $items) {
            menuInnerHTML += "<span class='menuItem' onmouseover='this.style.backgroundColor=\"#3e80ca\";window.status=this.innerHTML;' onmouseout='this.style.backgroundColor=\"\";window.status=\"\"' onclick=\"" + handle[i] + "\" >" + $items[i] + "</span>";
        }
        rightMenu.innerHTML = menuInnerHTML;
        rightMenu.style.visibility = "visible";
        rightMenu.onmousedown = function (e) {
            e = e || window.event;
            document.all ? e.cancelBubble = true : e.stopPropagation();
        }
        rightMenu.onselectstart = function () {
            return false;
        }
        document.body.appendChild(rightMenu);
        this.menu = rightMenu;
    };
    var getlabel;
    JRightMenu.prototype.show = function (e) {
        e = e || window.event;
        var LOBJ_Object = e.srcElement || e.target; //兼容FF，IE，谷歌
        if (LOBJ_Object.id == "<% =TxtTemplateClientID %>") {
            try {
                rebulidearr();
                var leng = 0;
                if ($.browser.msie) {
                    var rng = LOBJ_Object.createTextRange(); //只兼容IE
                    rng.moveToPoint(e.clientX, e.clientY); //光标定位
                    rng.moveStart("character", -e.srcElement.value.length);
                    for (var i = 0; i < labelstack.length; i++) {
                        //这里要将换行符号的记数减掉一半，否则字符数不准.       
                        var tlength = rng.text.replace(new RegExp("\r\n", "gm"), "-").length;
                        if (tlength > labelstack[i][0] && tlength < labelstack[i][1]) {
                            /* 标签位置确定及选择 */
                            var rng = $get("<% =TxtTemplateClientID %>").createTextRange();
                            if (labelstack[i][0] > labelstack[i][1]) {
                                leng = labelstack[i][0] - labelstack[i][1];
                            } else {
                                leng = labelstack[i][1] - labelstack[i][0];
                            }
                            //将起点和重点重合到起始位置
                            rng.moveEnd("character", -leng);
                            rng.moveStart("character", -leng);
                            rng.collapse(true);
                            //起点和重点位置按数值移动
                            rng.moveEnd("character", labelstack[i][1]);
                            rng.moveStart("character", labelstack[i][0]);
                            rng.select();
                            lstart = labelstack[i][0];
                            lend = labelstack[i][1];
                            /* 标签名称 */
                            getlabel = rng.text.toLowerCase();
                            righturl = escape(getxmlid(getlabel));

                            /* 显示右键菜单 */
                            var root = document.documentElement; //如果是document.body，那么root.scrollTop恒为0
                            var x = root.scrollLeft + e.clientX; //菜单左上角横坐标
                            var y = root.scrollTop + e.clientY; //菜单左上角纵坐标
                            if (this.menu.clientWidth + e.clientX > root.clientWidth) {
                                x = x - this.menu.clientWidth;
                            }
                            if (this.menu.clientHeight + e.clientY > root.clientHeight) {
                                y = y - this.menu.clientHeight;
                            }
                            this.menu.style.left = x + "px";
                            this.menu.style.top = y + "px";
                            this.menu.style.visibility = "visible";
                            return false;
                        }
                    }
                }
                else {
                    for (var j = 0; j < labelstack.length; j++) {
                        if (LOBJ_Object.selectionStart > labelstack[j][0] && LOBJ_Object.selectionEnd < labelstack[j][1]) {
                            if (labelstack[j][0] > labelstack[j][1]) {
                                leng = labelstack[j][0] - labelstack[j][1];
                            }
                            else {
                                leng = labelstack[j][1] - labelstack[j][0];
                            }
                            LOBJ_Object.selectionStart = labelstack[j][0];
                            LOBJ_Object.selectionEnd = labelstack[j][1];
                            lstart = labelstack[j][0];
                            lend = labelstack[j][1];
                            var selection = LOBJ_Object.value.substring(lstart, lend);

                            /* 标签名称 */
                            getlabel = selection.toLowerCase();
                            righturl = escape(getxmlid(getlabel));
                            //                            LOBJ_Object.select();
                            /* 显示右键菜单 */
                            var root = document.documentElement;
                            var x = root.scrollLeft + e.clientX; //菜单左上角横坐标
                            var y = root.scrollTop + e.clientY; //菜单左上角纵坐标

                            if (this.menu.clientWidth + e.clientX > root.clientWidth) {
                                x = x - this.menu.clientWidth;
                            }
                            if (this.menu.clientHeight + e.clientY > root.clientHeight) {
                                y = y - this.menu.clientHeight;
                            }
                            this.menu.style.left = x + "px";
                            this.menu.style.top = y + "px";
                            this.menu.style.visibility = "visible";
                            return false;
                        }
                    }
                }
            }
            catch (e) { };
        }
    }

    JRightMenu.prototype.hidden = function () {
        this.menu.style.visibility = "hidden";
    }

    //得到标签的Id值(作为Url参数用)
    function getxmlid(istr) {
        var outstr = "";
        istr = istr.replace(/\r\n/g, "");
        var regExp = /id\=\"(([\s\S])*?)\"\ /gi;
        var arr = regExp.exec(istr);
        if (arr != null) {
            outstr = arr[0].replace("id=\"", "").replace("\"", "").replace(" ", "");
        }
        return outstr;
    }

    /* 重建标签列表  */
    function rebulidearr() {
        labelstack = new Array();
        var arr, lstat, tmbody = $get("<% =TxtTemplateClientID %>").value;
        if ($.browser.msie) {
            tmbody = tmbody.replace(/\n/g, "");
        }
        var regExp = /{pe\.label(([\s\S](?!{pe\.))*?)\/}/gi;
        while ((arr = regExp.exec(tmbody)) != null) {
            lstat = [arr.index, regExp.lastIndex, arr[1]];
            labelstack.push(lstat);
        }
    }
    //快速定位列表
    function rebulideuselist() {
        rebulidearr();
        if (labelstack.length > 0) {
            var labelspan = "";
            for (var i = 0; i < labelstack.length; i++) {
                labelspan += "<div class='spanfixdiv' outype='23'  onclick ='selectlabel(" + labelstack[i][0] + "," + labelstack[i][1] + ");' oncontextmenu='changelabel(" + labelstack[i][0] + "," + labelstack[i][1] + "); return false'>" + labelstack[i][2] + "</div>";
            }
            $get("thispagelabel").innerHTML = labelspan;
        }
    }
    //快速定位
    function selectlabel(begin, end) {
        begin = parseInt(begin);
        end = parseInt(end);
        if ($.browser.msie) {
            var rng = $get("<% =TxtTemplateClientID %>").createTextRange();
            rng.moveEnd("character", -$get("<% =TxtTemplateClientID %>").value.length);
            rng.moveStart("character", -$get("<% =TxtTemplateClientID %>").value.length);
            rng.collapse(true);
            rng.moveEnd("character", end);
            rng.moveStart("character", begin);
            rng.select();
        }
        else {
            var obj = $get("<% =TxtTemplateClientID %>");
            obj.selectionStart = begin;
            obj.selectionEnd = end;
            var ss = obj.setSelectionRange(begin, end);
        }
        ClearDragspan(); //清除生成的标签内容
    }
    //给右键后编辑标签赋值
    function setlabel(getValue) {
        if (lstart != lend) {
            var leng = 0;
            if (lstart > lend) {
                leng = lstart - lend;
            } else {
                leng = lend - lstart;
            }
            //ie
            if ($.browser.msie) {
                var rng = $get("<% =TxtTemplateClientID %>").createTextRange();
                rng.moveEnd("character", -leng);
                rng.moveStart("character", -leng);
                rng.collapse(true);
                rng.moveEnd("character", lend);
                rng.moveStart("character", lstart);
                rng.select();
                rng.text = getValue;
            }
            //ff、chrome等
            else {
                var filed = $get("<% =TxtTemplateClientID %>");
                var startPos = filed.selectionStart;
                var endPos = filed.selectionEnd;
                var restoreTop = filed.scrollTop;
                filed.value = filed.value.substring(0, startPos) + getValue + filed.value.substring(endPos, filed.value.length); //用截断字符串的形式给选区赋值；
                if (restoreTop > 0) {
                    filed.scrollTop = restoreTop; //赋值后定位
                }
            }
        }
    }
    //弹出层方法
    function changelabel(begin, end) {
        begin = parseInt(begin);
        end = parseInt(end);
        if (begin != end) {
            var rng = $get("<% =TxtTemplateClientID %>").createTextRange();
            rng.moveEnd("character", -$get("<% =TxtTemplateClientID %>").value.length);
            rng.moveStart("character", -$get("<% =TxtTemplateClientID %>").value.length);
            rng.collapse(true);
            rng.moveEnd("character", end);
            rng.moveStart("character", begin);
            rng.select();

            var getlabel = rng.text;
            var link = "Template_addlabel.aspx?a=m&n=" + escape(getlabel);
            ShowWindow(link, '参数编辑');
        }
    }

    var righturl = "";
    var labelstack = new Array()
    var lstart = 0, lend = 0;
    var isRightMenu = false;
    function openlabeltemplate() {
        if (righturl != "") {
            parent.jQuery("#newFrameTab").click();
            var d = jQuery(parent.document);
            d.find("#main_right").attr("src", "<%=BasePath%><%= PowerEasy.Foundation.SiteConfig.SiteOption.ManageDir %>/Template/Label.aspx?name=" + righturl);
        }
    }
    //右键弹出层方法
    function rightchangelabel() {
        if (lstart != lend) {
            var leng = 0;
            if (lstart > lend) {
                leng = lstart - lend;
            } else {
                leng = lend - lstart;
            }

            var getlabelValue;
            var link;
            isRightMenu = true; //是否右键菜单判断
            if ($.browser.msie) {
                var rng = $get("<% =TxtTemplateClientID %>").createTextRange();
                rng.moveEnd("character", -leng);
                rng.moveStart("character", -leng);
                rng.collapse(true);
                rng.moveEnd("character", lend);
                rng.moveStart("character", lstart);
                rng.select();
                getlabelValue = rng.text;
                link = "Template_addlabel.aspx?a=m&n=" + escape(getlabelValue);
            }
            else {
                var selection = $get("<% =TxtTemplateClientID %>").value.substring(lstart, lend);
                /* 标签名称 */
                getlabelValue = selection.toLowerCase();
                link = "Template_addlabel.aspx?a=m&n=" + escape(getlabelValue);
            }
            ShowWindow(link, '参数编辑');
        }
    }
    var rightMenu;
    window.onload = function () {
        rightMenu = new JRightMenu(["编辑参数", "编辑标签"], ["rightchangelabel()", "openlabeltemplate()"]);
        rightMenu.hidden();
    }
    document.oncontextmenu = function (evt) { return rightMenu.show(evt); };
    document.onclick = function () { rightMenu.hidden(); }
  
</script>
