﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ShoppingCart.ascx.cs"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Controls.Shop.ShoppingCart" %>
<asp:Repeater ID="RptShoppingCart" runat="server" OnItemDataBound="RptShoppingCart_ItemDataBound">
    <HeaderTemplate>
        <table class="border" cellspacing="0" width="100%" id="shoppingCartList">
            <tr class="title" align="center">
                <td id="ProductImageTitle" runat="server">
                    <asp:Localize ID="Localize1" Text="图片" runat="server" />
                </td>
                <td>
                    <asp:Localize ID="Localize2" Text="商品名称" runat="server" />
                </td>
                <td>
                    <asp:Localize ID="Localize3" Text="单位"
                        runat="server" />
                </td>
                <td>
                    <asp:Localize ID="Localize4" Text="数量" runat="server" />
                </td>
                <td id="tdProductTypeTitle" runat="server">
                    <asp:Localize ID="Localize5" Text="商品类别" runat="server" />
                </td>
                <td id="tdSaleTypeTitle" runat="server">
                    <asp:Localize ID="Localize6" Text="销售类型" runat="server" />
                </td>
                <td id="tdMarkPriceTitle" runat="server">
                    <asp:Localize ID="Localize7" Text="市场价" runat="server" />
                </td>
                <td>
                    <asp:Localize ID="Localize8" Text="实价" runat="server" />
                </td>
                <td>
                    <asp:Localize ID="Localize9" Text="金额" runat="server" />
                </td>
            </tr>
    </HeaderTemplate>
    <ItemTemplate>
        <tr class="tdbg" align="center">
            <asp:HiddenField ID="HdfProdctId" runat="server" Value='<%#Eval("ProductId") %>' />
            <asp:HiddenField ID="HdfTableName" runat="server" Value='<%#Eval("TableName") %>' />
            <td id="ProductImage" runat="server">
                <pe:ExtendedImage ID="extendedImage" runat="server"></pe:ExtendedImage>
            </td>
            <td align="left">
                <pe:ExtendedLiteral ID="LitProductName" HtmlEncode="false" runat="server"></pe:ExtendedLiteral>
                <asp:Literal ID="LitProperty" runat="server"></asp:Literal>
            </td>
            <td>
                <asp:Literal ID="LitProductUnit" runat="server"></asp:Literal>
            </td>
            <td>
                <asp:Literal ID="LitProductAmount" runat="server" Text='<%#Eval("Quantity") %>'></asp:Literal>
            </td>
            <td id="tdProductType" runat="server">
                <asp:Literal ID="LitProductType" runat="server"></asp:Literal>
            </td>
            <td id="tdSaleType" runat="server">
                <asp:Literal ID="LitSaleType" runat="server"></asp:Literal>
            </td>
            <td align="right" id="tdMarkPrice" runat="server">
                <asp:Literal ID="LitPriceMarket" runat="server"></asp:Literal>
            </td>
            <td align="right">
                <asp:Literal ID="LitTruePrice" runat="server"></asp:Literal>
                &nbsp;<pe:ExtendedLabel ID="LblInvoiceRate" runat="server" HtmlEncode="false"></pe:ExtendedLabel>
            </td>
            <td align="right">
                <asp:Literal ID="LitSubTotal" runat="server"></asp:Literal>
            </td>
        </tr>
        <asp:Panel ID="PresentInfomation" runat="server" Visible="false">
            <tr class="tdbg" align="center">
                <asp:HiddenField ID="HdnPresentId" runat="server" />
                <td id="presentImage" runat="server">
                    <pe:ExtendedImage ID="extendedPresentImage" runat="server"></pe:ExtendedImage>
                </td>
                <td align="left">
                    <pe:ExtendedLiteral ID="LitPresentName" runat="server"></pe:ExtendedLiteral>
                </td>
                <td>
                    <asp:Literal ID="LitPresentUnit" runat="server"></asp:Literal>
                </td>
                <td>
                    <asp:Literal ID="LitPresentNum" runat="server"></asp:Literal><br />
                    <asp:Literal ID="LitPresentMsg" runat="server"></asp:Literal>
                </td>
                <td id="tdPresentType" runat="server">
                    <asp:Literal ID="LitPresentType" runat="server"></asp:Literal>
                </td>
                <td id="tdPresentSaleType" runat="server">
                    <asp:Literal ID="LitPresentSaleType" runat="server"></asp:Literal>
                </td>
                <td align="right" id="tdPresentMarkPrice" runat="server">
                    <asp:Literal ID="LitPresentPriceOriginal" runat="server"></asp:Literal>
                </td>
                <td align="right">
                    <asp:Literal ID="LitPresentTruePrice" runat="server"></asp:Literal>
                </td>
                <td align="right">
                    <asp:Literal ID="LitPresentSubtotal" runat="server"></asp:Literal>
                </td>
            </tr>
        </asp:Panel>
    </ItemTemplate>
    <FooterTemplate>
        <asp:PlaceHolder ID="PlhPresentInfo" runat="server" Visible="false">
            <tr align='center' class='tdbg'>
                <td id="footerPresentImage" runat="server">
                    <pe:ExtendedImage ID="presentImage" runat="server"></pe:ExtendedImage>
                </td>
                <td align='left'>
                    <pe:ExtendedLabel ID="LblProductName" runat="server" /><span style="color: Red"><asp:Localize
                        ID="Localize10" Text="（超值换购）" runat="server" /></span>
                </td>
                <td>
                    <asp:Label ID="LblUnit" runat="server"></asp:Label>
                </td>
                <td>
                    1
                </td>
                <td id="footerPresentType" runat="server">
                    <span style="color: Red">
                        <asp:Localize ID="Localize11" Text="促销礼品"
                            runat="server" /></span>
                </td>
                <td id="footerPresentSaleType" runat="server">
                    <span style="color: Red">
                        <asp:Localize ID="Localize12" Text="超值换购"
                            runat="server" /></span>
                </td>
                <td align='right' id="footerPresentMarkPrice" runat="server">
                    <asp:Label ID="LblPresentPriceMarket" runat="server"></asp:Label>
                </td>
                <td align='right' id="footerPresentTruePrice" runat="server">
                    <asp:Label ID="LblPresentPrice" runat="server"></asp:Label>
                </td>
                <td align='right' id="footerPresentSalePrice" runat="server">
                    <asp:Label ID="LblPresentPrice1" runat="server"></asp:Label>
                </td>
            </tr>
        </asp:PlaceHolder>
        <%--<%=presentList2 %>--%>
        <tr class="tdbg">
            <td runat="server" id="footerTdThemeImage">
            </td>
            <td>
                <b>
                    <asp:Localize ID="Localize13" Text="合计："
                        runat="server" /></b>
            </td>
            <td>
            &nbsp;
            </td>
            <td>
               <%=totalAmount %>
            </td>
            <td runat="server" id="footerTdProductType">
            </td>
            <td runat="server" id="footerTdSaleType">
            </td>
            <td runat="server" id="footerTdMarkPrice">
            </td>
            <td>
            &nbsp;            
            </td>
            <td align="right">
                <%=string.Format("{0:N2}",total)%>
            </td>
        </tr>
        <asp:PlaceHolder ID="PlhMoneyInfo" runat="server" Visible="false">
            <tr>
                <td align='left'>
                    <span style="color: Green;">总重量： </span>
                    <asp:Label ID="LblTotalWeight" runat="server"></asp:Label>千克 <span style="color: green">
                        <asp:Localize ID="Localize14" Text="运费"
                            runat="server" /></span>
                    <asp:Label ID="LblDeliverCharge" runat="server"></asp:Label><asp:Localize ID="Localize15"
                        Text="元" runat="server" />
                    <span style="color: green">
                        <asp:Localize ID="Localize16" Text="运费税率"
                            runat="server" /></span><asp:Label ID="LblTaxRate" runat="server"></asp:Label><asp:Localize
                                ID="Localize18" Text="%" runat="server" />
                    <span style="color: green">
                        <asp:Localize ID="Localize19" Text="运费价格含税："
                            runat="server" /></span><asp:Label ID="LblIncludeTax" runat="server"></asp:Label><br />
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblCoupon" runat="server" Visible="false"></pe:ExtendedLabel>
                    <asp:Label ID="LblTotalMoney" runat="server"></asp:Label>
                </td>
                <td runat="server" id="footerTdMoneyInfoProductType" runat="server">
                    &nbsp;
                </td>
                <td runat="server" id="footerTdMoneyInfoSaleType" runat="server">
                    &nbsp;
                </td>
                <td runat="server" id="footerTdMoneyInfoMarkPrice" runat="server">
                    &nbsp;
                </td>
                <td colspan="2">
                    &nbsp;
                </td>
                <td align='right' colspan="4">
                    <b>
                        <asp:Localize ID="Localize20" Text="实际金额：
                            runat="server" /></b><asp:Label ID="LblTrueTotalMoney" runat="server"></asp:Label><asp:Localize
                                ID="Localize21" Text="元" runat="server" />
                </td>
            </tr>
        </asp:PlaceHolder>
        <%--        <%= priceInfomation%>--%>
        <%=presentExpInfomation%>
        <%--            <asp:Panel ID="Notes" runat="server" Visible="false">
             <tr>
                    <td colspan="8" align="right"><%=presentList%></td>
                    <td></td>
                </tr>
                <tr>
                    <td colspan="9" align="left"><b> <%= priceInfomation%></b></td>
                </tr>
             </asp:Panel>--%>
        </table>
    </FooterTemplate>
</asp:Repeater>
<div id="Note" runat="server" style="text-align: left" visible="false">
    <b>
        <asp:Localize ID="Localize22" Text="你可以用"
            runat="server" />
        <asp:Label ID="LblPrice" runat="server" Visible="false" ForeColor="red"></asp:Label>
        <asp:Localize ID="Localize23" Text="元超值换购以下商品"
            runat="server" /></b>
</div>
<asp:Repeater ID="RptPresentList" runat="server" Visible="false" OnItemDataBound="RptPresentList_ItemDataBound">
    <HeaderTemplate>
        <table width="100%" class="border" cellpadding="2" cellspacing="1">
            <tr class="title">
                <td style="width: 3px;">
                </td>
                <td id="changePresentHeaderImage" runat="server">
                    <asp:Localize ID="Localize24" Text="图片"
                        runat="server" />
                </td>
                <td>
                    <asp:Localize ID="Localize25" Text="商品名称"
                        runat="server" />
                </td>
                <td>
                    <asp:Localize ID="Localize26" Text="单位"
                        runat="server" />
                </td>
                <td>
                    <asp:Localize ID="Localize27" Text="数量"
                        runat="server" />
                </td>
                <td runat="server" id="changePresentHeaderProductType">
                    <asp:Localize ID="Localize28" Text="商品类型"
                        runat="server" />
                </td>
                <td runat="server" id="changePresentHeaderSaleType">
                    <asp:Localize ID="Localize29" Text="销售类型"
                        runat="server" />
                </td>
                <td runat="server" id="changePresentHeaderMarkPrice">
                    <asp:Localize ID="Localize30" Text="市场价"
                        runat="server" />
                </td>
                <td>
                    <asp:Localize ID="Localize31" Text="实价"
                        runat="server" />
                </td>
                <td>
                    <asp:Localize ID="Localize32" Text="金额"
                        runat="server" />
                </td>
            </tr>
    </HeaderTemplate>
    <ItemTemplate>
        <tr>
            <td style="width: 5px;">
                <input type="checkbox" name="RdbPresentId" value='<%#Eval("PresentId")%>' id="RdbPresentId"
                    class="presentRadio" onclick="selectPresent(this);" />
            </td>
            <td id="changePresentImage" runat="server" align="center">
                <pe:ExtendedImage ID="changePresentListImage" runat="server"></pe:ExtendedImage>
            </td>
            <td style="text-align: center;">
                <%--<asp:HiddenField ID="HdfChangePresentTableName" runat="server" Value='<%#Eval("TableName") %>' />--%>
                <asp:Literal ID="LitChangePresentName" runat="server" Text='<%#Eval("PresentName") %>'></asp:Literal>
            </td>
            <td align="center">
                <asp:Literal ID="LitChangePresentUnit" runat="server" Text='<%#Eval("Unit") %>'></asp:Literal>
            </td>
            <td align="center">
                <asp:Literal ID="LitChangePresentAmount" runat="server" Text='1'></asp:Literal>
            </td>
            <td runat="server" id="changePresentType" align="center">
                <asp:Literal ID="LitChangePresentType" runat="server" Text='促销礼品'></asp:Literal>
            </td>
            <td runat="server" id="changeSaleType" align="center">
                <asp:Literal ID="LitChangePresentSaleType" runat="server" Text='超值换购'></asp:Literal>
            </td>
            <td runat="server" id="changeMarkPrice" align="center">
                <asp:Literal ID="LitChangePresentPriceMarket" runat="server"></asp:Literal>
            </td>
            <td align="center">
                <asp:Literal ID="LitChangePresentTruePrice" runat="server"></asp:Literal>
            </td>
            <td align="center">
                <asp:Literal ID="LitChangePresentSubTotal" runat="server"></asp:Literal>
            </td>
        </tr>
    </ItemTemplate>
    <FooterTemplate>
        </table>
    </FooterTemplate>
</asp:Repeater>

<script language="javascript" type="text/javascript">
    var cookiePath = '/';
    var cookieExpires = null;
    var isNewShoppingFlow = '<%=IsNewShoppingFlow %>'.toLowerCase() == 'true';
    if (isNewShoppingFlow && jQuery.cookie("presentId") != null) {
        jQuery(".presentRadio").each(function() {
            if (this.value == jQuery.cookie("presentId")) {
                this.checked = true;
                return false;
            }
        });
    }
    function selectPresent(obj) {
        if (isNewShoppingFlow) {
            if (obj.checked) {
                jQuery.cookie("presentId", obj.value, { path: cookiePath, expires: cookieExpires });
            }
            else {
                jQuery.cookie("presentId", "", { path: cookiePath, expires: cookieExpires });
            }
        }
        jQuery(".presentRadio").not(obj).prop("checked", false);
    }
</script>

