﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Controls.Shop.ShowOrder"
    CodeBehind="ShowOrder.ascx.cs" %>

<script type="text/javascript">
    function ShowOrderTabs(ID) {
        jQuery("td[id^='TabOrderTitle']").attr("class", "tabtitle");
        jQuery("div[id^='Tabs_Order']").hide();
        jQuery("#TabOrderTitle" + ID.toString()).attr("class", "titlemouseover");
        jQuery("#Tabs_Order" + ID.toString()).show();
    }

    function BindShowOrderTabs() {
        jQuery("#TableTabContainer td:first").click();
    }

    jQuery(function() {
        BindShowOrderTabs();
    });
</script>

<table style="width: 100%" border='0' cellpadding='0' cellspacing='0' id="TableTabContainer">
    <tr style="height: 22px; text-align: center">
        <% if (!IsCreditProduct)
           { %>
        <td id='TabOrderTitle0' class='titlemouseover' onclick='ShowOrderTabs(0)'>
            <asp:Localize ID="Localize1" Text="付款信息 "
                runat="server" />
        </td>
        <td id='TabOrderTitle1' class='tabtitle' onclick='ShowOrderTabs(1)'>
            <asp:Localize ID="Localize2" Text="发票记录 "
                runat="server" />
        </td>
        <% } %>
        <td id='TabOrderTitle2' class='tabtitle' onclick='ShowOrderTabs(2)'>
            <asp:Localize ID="Localize3" Text="发退货记录 "
                runat="server" />
        </td>
        <% if (!IsCreditProduct)
           { %>
        <td id='TabOrderTitle3' class='tabtitle' <%=IsShow()%> onclick='ShowOrderTabs(3)'>
            <asp:Localize ID="Localize4" Text="过户记录 "
                runat="server" />
        </td>
        <%} %>
        <td id='TabOrderTitle4' class='tabtitle' onclick='ShowOrderTabs(4)'>
            <asp:Localize ID="Localize5" Text="服务记录 "
                runat="server" />
        </td>
        <td id='TabOrderTitle5' class='tabtitle' onclick='ShowOrderTabs(5)'>
            <asp:Localize ID="Localize6" Text="投诉记录 "
                runat="server" />
        </td>
        <td id='TabOrderTitle6' class='tabtitle' onclick='ShowOrderTabs(6)'>
            <asp:Localize ID="Localize7" Text="反馈记录 "
                runat="server" />
        </td>
        <% if (!IsCreditProduct)
           { %>
        <td id='TabOrderTitle7' class='tabtitle' onclick='ShowOrderTabs(7)'>
            <asp:Localize ID="Localize8" Text="在线支付记录 "
                runat="server" />
        </td>
        <%}
           if (m_ShowOptions == 0)
           { %>
        <td id='TabOrderTitle8' class='tabtitle' onclick='ShowOrderTabs(8)'>
            <asp:Localize ID="Localize10" Text="订单历史记录 "
                runat="server" />
        </td>
        <%} %>
        <td id="TabOrderTitle9" class='tabtitle' onclick='ShowOrderTabs(9)'>
            积分明细
        </td>
        <td>
            &nbsp;
        </td>
    </tr>
</table>
<div id="Tabs_Order0" class="border" style="width: 99%; display: block;">
    <pe:ExtendedGridView ID="EgvBankroll" runat="server" SerialText="" AutoGenerateColumns="False"
        EmptyDataText="没有相关付款记录 "
        OnDataBound="EgvBankroll_DataBound" OnRowDataBound="EgvBankroll_RowDataBound"
        ShowFooter="True" CheckBoxFieldHeaderWidth="3%" IsHoldState="True">
        <Columns>
            <asp:HyperLinkField DataNavigateUrlFields="ClientID" DataTextField="ClientName" HeaderText="客户名称 "
                DataNavigateUrlFormatString="~/Admin/Crm/ClientShow.aspx?ClientId={0}">
                <HeaderStyle Width="10%" />
            </asp:HyperLinkField>
            <pe:TemplateField HeaderText="用户名 ">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <asp:HyperLink ID="LnkUserName" runat="server" NavigateUrl='<%# Eval("UserName", "~/Admin/User/UserShow.aspx?UserName={0}") %>'
                        Text='<%# Eval("UserName") %>'></asp:HyperLink>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="DateAndTime" HeaderText="交易时间 "
                DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                <HeaderStyle Width="17%" />
            </pe:BoundField>
            <pe:BoundField HeaderText="交易方式 ">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField HeaderText="币种 ">
                <HeaderStyle Width="7%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="支出金额 ">
                <ItemStyle HorizontalAlign="Right" />
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <%#System.Math.Abs(Convert.ToDecimal(Eval("Money"))).ToString("N2")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField HeaderText="摘要 ">
                <HeaderStyle Width="6%" />
            </pe:BoundField>
            <pe:BoundField DataField="Remark" HeaderText="备注/说明 " />
            <asp:HyperLinkField DataNavigateUrlFields="ItemId" HeaderText="操作 "
                Text="查看 " DataNavigateUrlFormatString="~/Admin/User/BankrollItemDetail.aspx?BankrollItemID={0}">
                <HeaderStyle Width="6%" />
            </asp:HyperLinkField>
        </Columns>
        <FooterStyle CssClass="tdbg" />
    </pe:ExtendedGridView>
</div>
<div id="Tabs_Order1" class="border" style="width: 99%; display: none;">
    <pe:ExtendedGridView ID="EgvInvoice" runat="server" EmptyDataText="没有相关发票记录 "
        AutoGenerateColumns="False" SerialText="" OnRowDataBound="EgvInvoice_RowDataBound"
        CheckBoxFieldHeaderWidth="3%" IsHoldState="True">
        <Columns>
            <pe:BoundField DataField="InvoiceDate" HeaderText="日期 "
                DataFormatString="{0:yyyy-MM-dd}" HtmlEncode="False">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:BoundField HeaderText="发票类型 ">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="发票号码 "
                SortExpression="InvoiceNum">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <asp:HyperLink runat="server" Text='<%# Eval("InvoiceNum") %>' NavigateUrl='<%# Eval("InvoiceID", "~/Admin/Shop/InvoiceItemDetail.aspx?InvoiceID={0}") %>'
                        ID="LnkInvoiceID"></asp:HyperLink>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="InvoiceTitle" HeaderText="发票抬头 ">
                <ItemStyle HorizontalAlign="Left" />
            </pe:BoundField>
            <pe:BoundField DataField="TotalMoney" HeaderText="发票金额 "
                DataFormatString="{0:N2}" HtmlEncode="False">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField DataField="Drawer" HeaderText="开票人 ">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField DataField="Inputer" HeaderText="录入员 ">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField DataField="InputTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HeaderText="录入时间 "
                HtmlEncode="False">
                <HeaderStyle Width="17%" />
            </pe:BoundField>
        </Columns>
    </pe:ExtendedGridView>
</div>
<div id="Tabs_Order2" class="border" style="width: 99%; display: block;">
    <pe:ExtendedGridView ID="EgvDeliverItem" runat="server" AutoGenerateColumns="False"
        OnRowDataBound="EgvDeliverItem_RowDataBound" SerialText="" EmptyDataText="没有相关发退货记录 "
        OnRowCommand="EgvDeliverItem_RowCommand" CheckBoxFieldHeaderWidth="3%" 
        IsHoldState="True">
        <Columns>
            <asp:TemplateField HeaderText="日期 ">
                <ItemTemplate>
                    <a class="expandEditHistory" deliveid='<%#Eval("DeliverId")%>' runat="server" id="ImgBtnExpand" />
                    <asp:Label ID="Label1" runat="server" 
                        Text='<%# Bind("DeliverDate", "{0:yyyy-MM-dd}") %>'></asp:Label>
                </ItemTemplate>                
                <HeaderStyle Width="10%" />
            </asp:TemplateField>
            <asp:BoundField HeaderText="发货/客户退货 ">
            <HeaderStyle Width="12%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="快递公司名 ">
                <ItemTemplate>
                    <asp:Literal ID="LitExpressCompony" runat="server"></asp:Literal>
                </ItemTemplate>
                <HeaderStyle Width="12%" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="快递单号 ">
                <ItemTemplate>
                    <asp:Literal ID="LitExpressNumber" runat="server"></asp:Literal>
                </ItemTemplate>
                <HeaderStyle Width="15%" />
            </asp:TemplateField>
            <asp:BoundField DataField="HandlerName" 
                HeaderText="经手人 ">
            <HeaderStyle Width="8%" />
            </asp:BoundField>
            <asp:BoundField DataField="Inputer" 
                HeaderText="录入员 ">
            <HeaderStyle Width="8%" />
            </asp:BoundField>
            <asp:BoundField HeaderText="客户已签收 ">
            <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField DataField="Remark" 
                HeaderText="备注/退货原因 ">
            <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="操作 " 
                Visible="False">
                <ItemTemplate>
                    <asp:LinkButton ID="LinkButton1" runat="server" CausesValidation="False" 
                        CommandArgument='<%# Eval("OrderNum") %>' CommandName="Received" 
                        OnClientClick="return confirm('确定已经收到此订单中的货物了吗？')" 
                        Text="签收 "></asp:LinkButton>
                </ItemTemplate>
                <HeaderStyle Width="5%" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="查看物流情况 ">
                <ItemTemplate>
                    <pe:ExtendedLiteral ID="LitExpressState" runat="server" HtmlEncode="false"></pe:ExtendedLiteral>
                </ItemTemplate>
                <HeaderStyle Width="10%" />
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
</div>
<div id="Tabs_Order3" class="border" style="width: 99%; display: none;">
    <pe:ExtendedGridView ID="EgvTransferLog" runat="server" AutoGenerateColumns="False"
        EmptyDataText="没有相关过户记录 "
        SerialText="">
        <Columns>
            <pe:BoundField DataField="TransferTime" HeaderText="时间 "
                DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                <HeaderStyle Width="15%" />
            </pe:BoundField>
            <pe:BoundField DataField="OwnerUserName" HeaderText="过户人 ">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField DataField="TargetUserName" HeaderText="过户给 ">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField DataField="Poundage" HeaderText="过户费 "
                DataFormatString="{0:N2}" HtmlEncode="False">
                <HeaderStyle Width="6%" />
            </pe:BoundField>
            <pe:BoundField DataField="PayerUserName" HeaderText="付款人 ">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField DataField="Remark" HeaderText="备注 " />
            <pe:BoundField DataField="Inputer" HeaderText="经手人 ">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
        </Columns>
    </pe:ExtendedGridView>
</div>
<div id="Tabs_Order4" class="border" style="width: 99%; display: none;">
    <pe:ExtendedGridView ID="EgvService" runat="server" AutoGenerateColumns="False" EmptyDataText="没有相关服务记录 "
        SerialText="" OnRowDataBound="EgvService_RowDataBound" CheckBoxFieldHeaderWidth="3%"
        IsHoldState="True">
        <Columns>
            <asp:BoundField DataField="ServiceTime" HeaderText="服务时间 "
                SortExpression="ServiceTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="客户名称 "
                SortExpression="ShortedForm">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <asp:HyperLink runat="server" Text='<%# Eval("ShortedForm") %>' NavigateUrl='<%# Eval("ClientID", "~/Admin/Crm/ClientShow.aspx?ClientId={0}") %>'
                        ID="LnkClientShow"></asp:HyperLink>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="主题 "
                SortExpression="ServiceTitle">
                <ItemTemplate>
                    <asp:HyperLink runat="server" Text='<%# Eval("ServiceTitle") %>' NavigateUrl='<%# Eval("ItemId", "~/Admin/Crm/ServiceShow.aspx?ItemId={0}") %>'
                        ID="LnkServiceTitle"></asp:HyperLink>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField HeaderText="服务类型 " SortExpression="ServiceType"
                DataField="ServiceType">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField HeaderText="服务方式 " SortExpression="ServiceMode"
                DataField="ServiceMode">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField HeaderText="服务人员 " SortExpression="Processor"
                DataField="Processor"></asp:BoundField>
            <asp:BoundField HeaderText="服务结果 " SortExpression="ServiceResult"
                DataField="ServiceResult">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="回访确认">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%#Eval("ConfirmTime") == null ? "" : "<strong>√</strong>"%>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField HeaderText="客户评价 " DataField="ConfirmScore">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
        </Columns>
    </pe:ExtendedGridView>
</div>
<div id="Tabs_Order5" class="border" style="width: 99%; display: none;">
    <pe:ExtendedGridView ID="EgvComplain" runat="server" AutoGenerateColumns="False"
        EmptyDataText="没有相关投诉记录 "
        SerialText="" OnRowDataBound="EgvComplain_RowDataBound" CheckBoxFieldHeaderWidth="3%"
        IsHoldState="True">
        <Columns>
            <asp:BoundField DataField="DateAndTime" HeaderText="投诉时间 "
                SortExpression="DateAndTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                <HeaderStyle Width="15%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="客户名称 "
                SortExpression="ShortedForm">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <asp:HyperLink runat="server" Text='<%# Eval("ShortedForm") %>' NavigateUrl='<%# Eval("ClientID", "~/Admin/Crm/ClientShow.aspx?ClientId={0}") %>'
                        ID="LnkClientShow2"></asp:HyperLink>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="ComplainType" HeaderText="投诉类型 "
                SortExpression="ComplainType">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="主题 ">
                <ItemTemplate>
                    <asp:HyperLink runat="server" Text='<%# Eval("Title") %>' NavigateUrl='<%# Eval("ItemId", "~/Admin/Crm/ComplainShow.aspx?ItemId={0}") %>'
                        ID="LnkComplainTitle"></asp:HyperLink>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="MagnitudeOfExigence" HeaderText="紧急程度 "
                SortExpression="MagnitudeOfExigence">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField DataField="Status" HeaderText="记录状态 "
                SortExpression="Status">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
        </Columns>
    </pe:ExtendedGridView>
</div>
<div id="Tabs_Order6" class="border" style="width: 99%; display: none;">
    <pe:ExtendedGridView ID="EgvFeedback" runat="server" AutoGenerateColumns="False"
        AutoGenerateCheckBoxColumn="false" CssClass="TableWrap" EmptyDataText="没有反馈记录 "
        SerialText="" OnRowCommand="EgvFeedback_RowCommand">
        <Columns>
            <pe:BoundField DataField="WriteTime" HeaderText="时间 "
                DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                <HeaderStyle Width="15%" />
            </pe:BoundField>
            <pe:BoundField DataField="Content" ItemStyle-CssClass="TdWrap" ItemStyle-HorizontalAlign="left"
                HeaderText="内容 ">
            </pe:BoundField>
            <pe:BoundField DataField="ReplyName" HeaderText="管理员名 ">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="操作 ">
                <HeaderStyle Width="14%" />
                <ItemTemplate>
                    <asp:LinkButton ID="LbtnReply" Visible='<%#string.IsNullOrEmpty(Convert.ToString(Eval("ReplyContent")))%>'
                        runat="server" Text="回复" CommandArgument='<%#Eval("Id") %>'
                        CommandName="ReplyContent"></asp:LinkButton>
                    <a href='OrderFeedbackModify.aspx?ID=<%#Eval("Id")%><%#string.IsNullOrEmpty(Convert.ToString(Eval("ReplyName")))?"":"&Action=ModifyReply"%>'>
                        <asp:Localize ID="Localize9" Text="修改 "
                            runat="server" /></a>
                    <asp:LinkButton ID="LbtnDelFeedback" runat="server" Text="删除 "
                        CommandArgument='<%#Eval("Id") %>' CommandName='<%#string.IsNullOrEmpty(Convert.ToString(Eval("ReplyName")))?"Del":"DelReply" %>'></asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
</div>
<div id="Tabs_Order7" class="border" style="width: 99%; display: none;">
    <pe:ExtendedGridView ID="GdvPaymentLogList" runat="server" AutoGenerateCheckBoxColumn="False"
        AutoGenerateColumns="False" OnRowDataBound="GdvPaymentLogList_RowDataBound" HorizontalAlign="Center">
        <Columns>
            <pe:TemplateField HeaderText="支付序号 ">
                <HeaderStyle Width="18%" />
                <ItemTemplate>
                    <asp:HyperLink ID="LnkPaymentNum" runat="server"></asp:HyperLink>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="支付平台 ">
                <ItemTemplate>
                    <asp:Label ID="LblPlatform" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="交易时间 "
                SortExpression="PayTime">
                <HeaderStyle Width="20%" />
                <ItemTemplate>
                    <%# Eval("PayTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="汇款金额 "
                SortExpression="MoneyPay">
                <HeaderStyle Width="12%" />
                <ItemStyle HorizontalAlign="right" />
                <ItemTemplate>
                    <%# Eval("MoneyPay", "{0:N2}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="实际转账金额 "
                SortExpression="MoneyTrue">
                <HeaderStyle Width="12%" />
                <ItemStyle HorizontalAlign="right" />
                <ItemTemplate>
                    <%# Eval("MoneyTrue", "{0:N2}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="交易状态 ">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <asp:Label ID="LblStatus" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
</div>
<div id="Tabs_Order8" class="border" style="width: 99%; display: none">
    <pe:ExtendedGridView ID="EgvOrderHistory" runat="server" AutoGenerateColumns="False"
        CheckBoxFieldHeaderWidth="3%" IsHoldState="True" SerialText="" OnRowDataBound="EgvOderHistory_RowDataBound">
        <Columns>
            <asp:TemplateField SortExpression="ActionName" HeaderText="操作名称 ">
                <ItemTemplate>
                    <a class="expandEditHistory" orderhistoryid='<%#Eval("OrderHistoryID")%>' visible="false"
                        runat="server" id="ImgBtnExpand" />
                    <asp:Label runat="server" ID="lblActionName" Text='<%# Eval("ActionName") %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="ActionTime" HeaderText="操作时间 "
                SortExpression="ActionTime" />
            <asp:BoundField DataField="UserIP" HeaderText="操作员"
                SortExpression="UserIP" />
            <asp:BoundField DataField="UserName" HeaderText="操作人 "
                SortExpression="UserName" />
            <asp:TemplateField SortExpression="Remark" HeaderText="操作备注 " HeaderStyle-Width="390"
             ControlStyle-Width="100%" ItemStyle-HorizontalAlign="Left">
                <ItemTemplate>
                    <asp:Label ID="Remark" runat="server" Text='<%# Bind("Remark") %>'>无</asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
</div>
<div id="Tabs_Order9" class="border" style="width: 99%; display: none">
    <pe:ExtendedGridView ID="EgvUserExpLog" runat="server" AutoGenerateColumns="False"
        CheckBoxFieldHeaderWidth="3%" DataKeyNames="LogId" IsHoldState="True" SerialText="">
        <Columns>
            <asp:BoundField DataField="LogTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HeaderText="记录时间"
                HtmlEncode="False" SortExpression="LogTime" />
            <asp:HyperLinkField DataNavigateUrlFields="UserName" DataNavigateUrlFormatString="UserShow.aspx?UserName={0}"
                DataTextField="UserName" HeaderText="用户名" />
            <asp:BoundField DataField="IP" HeaderText="IP地址" SortExpression="IP" />
            <asp:TemplateField HeaderText="积分记录">
                <ItemStyle HorizontalAlign="Right" />
                <ItemTemplate>
                    <%# (int)Eval("IncomePayout") == 1 ? "+" : "-" %><%# Eval("ExpNum") %>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="Remark" HeaderText="备注/说明" SortExpression="Remark" />
        </Columns>
    </pe:ExtendedGridView>
</div>

<script type="text/javascript">
    function ShowOrder_ModifyItem(arg, context) {
        if(jQuery(context).attr("hasdata")){
            jQuery(context).parent().parent().next('.editHistoryContainer').show();
        }else{
            <%=m_HistoryItemsCallServer %>
        }
        return false;
    }

    function ShowOrder_CloseModifyItem(context) {
    var $editHistoryContainer=jQuery(context).parent().parent().next('.editHistoryContainer');
        $editHistoryContainer.fadeOut('fast');//,function(){ $editHistoryContainer.remove();});
        return false;
    }
    jQuery("#<%=EgvOrderHistory.ClientID %> .expandEditHistory").click(function () {
        if (jQuery(this).css("background-position") == undefined || jQuery(this).css("background-position").indexOf("-15px") < 0) {
            ShowOrder_ModifyItem("OrderHistory|" + jQuery(this).attr("orderhistoryid"), this);
            jQuery(this).css("background-position", "0 -15px");
        }
        else {
            jQuery(this).css("background-position", "0 0"); ShowOrder_CloseModifyItem(this);
        }
    });

    <%--jQuery("#<%=EgvOrderHistory.ClientID %> .expandEditHistory").toggle(function() {
        ShowOrder_ModifyItem("OrderHistory|"+jQuery(this).attr("orderhistoryid"), this);
        jQuery(this).css("background-position","0 -15px");
    }, function() { jQuery(this).css("background-position","0 0");ShowOrder_CloseModifyItem(this); });--%>
    
    jQuery("#<%=EgvDeliverItem.ClientID %> .expandEditHistory").click(function () {
        if (jQuery(this).css("background-position") == undefined || jQuery(this).css("background-position").indexOf("-15px") < 0) {
            ShowOrder_ModifyItem("DeliverItemDetails|" + jQuery(this).attr("deliveid"), this); jQuery(this).css("background-position", "0 -15px");
        }
        else {
            jQuery(this).css("background-position", "0 0"); ShowOrder_CloseModifyItem(this);
        }
    });
    <%--jQuery("#<%=EgvDeliverItem.ClientID %> .expandEditHistory").toggle(
        function(){ShowOrder_ModifyItem("DeliverItemDetails|"+jQuery(this).attr("deliveid"),this);jQuery(this).css("background-position","0 -15px");},
        function(){jQuery(this).css("background-position","0 0");ShowOrder_CloseModifyItem(this);
    });--%>

    function ShowOrder_onSuccess(result, context) {
        var headitems;
        if(context.id.indexOf('OrderHistory') > 0){
            headitems = ["字段名","旧值","新值"];                        
            ShowData(headitems,['FieldName','OldValue','NewValue'],result,context);            
        }else if(context.id.indexOf('DeliverItem') > 0){
            ShowData(['商品名称','商品规格','数量'],['Name','Pty','Num'],result,context);
        }    
    }    
    
    function ShowData(headitems,properties,result,context){
        var cols = jQuery(context).parent().parent().find("td").length;
        var itemList = eval(result);
        var $editHistoryContainer = jQuery("<tr class='editHistoryContainer tdbg'><td colspan='"+cols+"'></td></tr>");
        result = '';
        if (itemList.length > 0) {
            var sb = new Sys.StringBuilder("<table class='border' cellspacing='1' cellpadding='0' style=' width: 500px;'>");//margin: 0pt auto;
            sb.append("<tr class='gridtitle' style='height:25px;'>");            
            for(var j in headitems){
                sb.append("<th scope='col'>");
                sb.append(headitems[j]);
                sb.append("</th>");
            }
            sb.append("</tr>");
            for (var i in itemList) {
                sb.append("<tr class='tdbg' align='center'>");
                for(var p in properties){
                    sb.append("<td align='center'>");                    
                    sb.append(itemList[i][properties[p]]);
                    sb.append("</td>");                    
                }
                sb.append("</tr>");
            }
            sb.append("</table>");
            result = sb.toString();
        }
        else {
            result = '无相关记录';
        }
        $editHistoryContainer.find('td').eq(0).append(result);
        jQuery($editHistoryContainer).insertAfter(jQuery(context).parent().parent()).show('fast');
        jQuery(context).attr("hasdata","true");
    }
</script>

