﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    ValidateRequest="false" EnableEventValidation="false" CodeBehind="ClientAnnal.aspx.cs"
    Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.ClientAnnal" Title="客户联系记录" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <script type="text/javascript">
        function ClientValidateRelationType(source, clientside_arguments) {
            if (document.getElementById("<%=DropRelationType.ClientID%>").options[0].selected) {
                clientside_arguments.IsValid = false;
            }
            else { clientside_arguments.IsValid = true };
        }
    </script>
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>
                    <pe:AlternateLiteral ID="LblTitle" Text="添加联系记录" AlternateText="修改联系记录" runat="Server" /></b>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 184px">
                <strong>客户名称：</strong>
            </td>
            <td>
                <asp:TextBox ID="txtSelectClient" Width="135" runat="server"></asp:TextBox>
                <pec:FloatingDialog ID="fSelectClient" runat="server" Name="选择客户名称" Title="选择客户名称"
                    Width="600" Height="500" BeginString="【" EndString="】" Skin="floatingDialogFontSkin" />
                <asp:HiddenField ID="hnSelectClient" runat="server" />
                <pe:RequiredFieldValidator ID="ValrClientName" runat="server" ErrorMessage="请输入对应客户"
                    Display="Dynamic" ControlToValidate="txtSelectClient"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 184px">
                <strong>联系方式：</strong>
            </td>
            <td>
                <asp:DropDownList ID="DropRelationType" Width="80px" runat="server" DataTextField="DataTextField"
                    DataValueField="DataValueField">
                </asp:DropDownList>
                <span style="color: Red;">*</span>
                <asp:CustomValidator ID="ValxRelationType" runat="server" ErrorMessage="请选择联系方式！"
                    ClientValidationFunction="ClientValidateRelationType"></asp:CustomValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 184px">
                <strong>客户方联系人：</strong>
            </td>
            <td>
                <span id="ContacterList">
                    <asp:DropDownList ID="DropContacterID" Width="80px" runat="server" DataTextField="DataTextField"
                        DataValueField="DataValueField">
                    </asp:DropDownList>
                </span>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 184px">
                <strong>联系时间：</strong>
            </td>
            <td>
                <pe:DatePicker ID="DpkRelationTime" runat="server"></pe:DatePicker>
                <pe:RegexValidator ValidateType="Date" ID="Vdate" runat="server" ControlToValidate="DpkRelationTime"
                    Display="Dynamic" ErrorMessage="请输入正确的时间" Height="25px" Width="124px"></pe:RegexValidator><asp:Label
                        ID="LblRelationTime" runat="server" Text="" ForeColor="Red"></asp:Label>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="height: 79px; width: 184px;">
                <strong>记录信息：</strong>
            </td>
            <td style="height: 79px">
                <asp:TextBox ID="TxtAnnalContent" TextMode="MultiLine" runat="server" Height="200px"
                    Width="600px" MaxLength="200"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg" id="ddd" runat="server">
            <td class="tdbgleft" style="width: 184px">
            </td>
            <td>
                <input type="checkbox" id="havaNext" runat="server" onclick="yc(this)" /><strong>下一次联系预约提醒</strong>
                <asp:UpdatePanel ID="UpPnlToClientItem" runat="server" RenderMode="Inline">
                    <ContentTemplate>
                        <asp:CheckBox ID="ckbClientItem" runat="server" AutoPostBack="true" OnCheckedChanged="ckbClientItem_CheckedChanged"
                            onclick="showtable(this)" /><strong>关联客户项目</strong>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
        <tbody id="tbRemind" style="display: none;">
            <tr class="tdbg">
                <td class="tdbgleft" style="width: 184px">
                    <strong>预约联系方式：</strong>
                </td>
                <td>
                    <asp:DropDownList ID="DropBookingType" Width="80px" runat="server" DataTextField="DataTextField"
                        DataValueField="DataValueField">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft" style="width: 184px">
                    <strong>主动提醒方式：</strong>
                </td>
                <td>
                    <asp:CheckBox ID="RemindByEmail" Text="邮件提醒" runat="server" />
                    <asp:CheckBox ID="RemindBySms" Text="手机短信提醒" runat="server" />
                    <asp:CheckBox ID="RemindByTips" Checked="true" Text="冒泡主动提醒" runat="server" />
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft" style="width: 184px">
                    <strong>预约提醒时间：</strong>
                </td>
                <td>
                    <asp:UpdatePanel ID="UpdatePanel1" runat="server" UpdateMode="Always">
                        <ContentTemplate>
                            <asp:TextBox ID="TxtServiceTime" runat="server" Width="200px" Visible='false' MaxLength="30"></asp:TextBox>
                            <asp:DropDownList runat="server" Width="80px" ID="DropNextTime" AutoPostBack="true"
                                OnSelectedIndexChanged="DropNextTime_SelectedIndexChanged">
                                <asp:ListItem Text="明天" />
                                <asp:ListItem Text="后天" />
                                <asp:ListItem Text="三天后" />
                                <asp:ListItem Text="一周后" />
                                <asp:ListItem Text="一个月后" Selected="True" />
                                <asp:ListItem Text="两个月后" />
                                <asp:ListItem Text="三个月后" />
                                <asp:ListItem Text="具体设置" />
                            </asp:DropDownList>
                            <pe:RegexValidator ValidateType="Date" ID="DateValidator2" runat="server" ControlToValidate="TxtServiceTime"
                                Display="Dynamic" ErrorMessage="时间格式不对"></pe:RegexValidator>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                </td>
            </tr>
            <tr class="tdbg">
                <td class="tdbgleft" style="width: 184px">
                    <strong>提醒内容：</strong>
                </td>
                <td>
                    <asp:TextBox ID="TxtRemindContent" runat="server" Width="200px" MaxLength="60" Text="跟进"></asp:TextBox>
                </td>
            </tr>
        </tbody>
    </table>
    <asp:UpdatePanel ID="UpdatePanel2" runat="server" RenderMode="Inline">
        <ContentTemplate>
            <table id="tbClientItem" runat="server" style="display: none; border-top-width: 0px;"
                width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
                <tr class="tdbg">
                    <td class="tdbgleft" style="width: 184px">
                        <strong>项目状态：</strong>
                    </td>
                    <td>
                        <asp:DropDownList ID="dropStatus" runat="server" Width="135px" DataTextField="DataTextField"
                            DataValueField="DataValueField">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td class="tdbgleft" style="width: 184px">
                        <strong>项目大小：</strong>
                    </td>
                    <td>
                        <asp:TextBox ID="txtPrice" runat="server" Width="135px" MaxLength="8"></asp:TextBox>元
                        <asp:CompareValidator ID="VlcPrice" runat="server" ControlToValidate="txtPrice" Display="Dynamic"
                            ErrorMessage="请输入大于0的整数值！" Operator="GreaterThanEqual" SetFocusOnError="True"
                            Type="Integer" ValueToCompare="0"></asp:CompareValidator>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td class="tdbgleft" style="width: 184px">
                        <strong>预计签单日期：</strong>
                    </td>
                    <td>
                        <pe:DatePicker ID="dpkEstimatDate" runat="server" Width="135px"></pe:DatePicker>
                        <pe:RegexValidator ValidateType="Date" ID="RegexValidator1" ControlToValidate="dpkEstimatDate"
                            Display="Dynamic" SetFocusOnError="true" runat="server"></pe:RegexValidator>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td class="tdbgleft" style="width: 184px">
                        <strong>预测成功率：</strong>
                    </td>
                    <td>
                        <asp:TextBox ID="txtSalesESRatio" runat="server" Width="135px"></asp:TextBox>%
                        <asp:RangeValidator ID="valSalesESRatio" runat="server" ControlToValidate="txtSalesESRatio"
                            Type="Integer" MaximumValue="100" MinimumValue="0" ErrorMessage="请输入0到100之间的数字"></asp:RangeValidator>
                    </td>
                </tr>
            </table>
        </ContentTemplate>
    </asp:UpdatePanel>
    <br />
    <center>
        <pe:ExtendedButton ID="EBtnSubmit" runat="server" Text="保存联系记录" OperateCode="ClientAnnalAdd"
            OnClick="BtnSubmit_Click" />
        <pe:ExtendedButton ID="EBtnCancel" OperateCode="ClientView" runat="server" Text="返回查看客户信息"
            ValidationGroup="BtnCancleValidationGroup" OnClick="BtnCancle_Click1" /><pe:ExtendedButton
                ID="EBtnClientAnnalManange" OperateCode="ClientAnnalManage" runat="server" OnClick="BtnCancle_Click"
                Text="返回联系记录管理" ValidationGroup="BtnCancleValidationGroup" />
    </center>
    <script type="text/javascript">
        function yc(me) {
            document.getElementById("tbRemind").style.display = me.checked ? "" : "None";
        }

        function showtable(me) {
            var clientId = document.getElementById('<%= hnSelectClient.ClientID %>');
            if (clientId.value < 1) {
                me.checked = false;
                alert("请先选择客户名称");
            }
        }
        function ShowContacter() {
            var obj = document.getElementById("<%=hnSelectClient.ClientID %>");
            GetContacterList(obj.value);
        }
        function BindContacterList(result, context) {
            document.getElementById('ContacterList').innerHTML = result;
        }
    </script>
</asp:Content>
