﻿<%@ Page Title="联系记录管理" Language="C#" MasterPageFile="~/Admin/MasterPage.master"
    AutoEventWireup="true" CodeBehind="ClientAnnalManage.aspx.cs" Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.ClientAnnalManage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
    <div style="padding-top: 5px;">
    </div>
    <table border='0' cellpadding='0' cellspacing='1' width='100%' height='100%'>
        <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitAll" />>
                    <asp:LinkButton ID="LnkAll" runat="server"   CommandArgument="0"  OnClick="ShowBookmarks"
                        ><span>全部</span></asp:LinkButton>
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitToday" />> 
                    <asp:LinkButton ID="LnkToday" runat="server"  CommandArgument="1" OnClick="ShowBookmarks"
                        ><span>今天</span></asp:LinkButton>  
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitWeek" />>    
                    <asp:LinkButton ID="LnkWeek" runat="server" CommandArgument="2" OnClick="ShowBookmarks"
                        ><span>本周</span></asp:LinkButton> 
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitMonth" />>
                    <asp:LinkButton ID="LnkMonth"  CommandArgument="3"  runat="server"  OnClick="ShowBookmarks"
                        ><span>本月</span></asp:LinkButton>  
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitLastWeek" />>
                    <asp:LinkButton ID="LnkLastWeek" CommandArgument="4" runat="server"  OnClick="ShowBookmarks" 
                        ><span>上周</span></asp:LinkButton>  
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitLastMonth" />>
                    <asp:LinkButton ID="LnkLastMonth" CommandArgument="5" runat="server"  OnClick="ShowBookmarks"
                        ><span>上月</span></asp:LinkButton></li>
                </ul>
            </td>
        </tr>
    </table>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <pe:ExtendedGridView ID="EgvClientAnnal" runat="server" AutoGenerateColumns="False"
        CheckBoxFieldHeaderWidth="3%" IsHoldState="True" SerialText="" AllowPaging="True"
        DataSourceID="odsClientAnnal" OnRowDataBound="EgvClientAnnal_RowDataBound" AutoGenerateCheckBoxColumn="True"
        DataKeyNames="ClientAnnalID">
        <Columns>
            <asp:BoundField DataField="RelationTime" HeaderText="联系时间" DataFormatString="{0:yyyy-MM-dd}"
                ItemStyle-Width="12%" />
                <pe:TemplateField HeaderText="客户名称" SortExpression="ShortedForm">
                <ItemTemplate>
                    <pe:ExtendedAnchor ID="Client" IsChecked="true" runat="server" operateCode="ClientView" href='<%#string.Format("ClientShow.aspx?clientid={0}",Eval("ClientID")) %>'></pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <asp:BoundField DataField="RelationType" HeaderText="联系方式" />
            <asp:BoundField DataField="AnnalContent" HeaderText="记录内容" SortExpression="AnnalContent" />
            <asp:BoundField DataField="Inputer" HeaderText="记录人" SortExpression="Inputer" />
            <asp:BoundField DataField="ClientAnnalId" HeaderText="ClientAnnalId" InsertVisible="False"
                ReadOnly="True" SortExpression="ClientAnnalID" Visible="False" />
            <asp:TemplateField HeaderText="常规操作">
                <EditItemTemplate>
                </EditItemTemplate>
                <ItemTemplate>
                <a href='<%#string.Format("ClientAnnalShow.aspx?ClientAnnalID={0}",Eval("ClientAnnalID")) %>'>查看</a>
                    <pe:ExtendedAnchor ID="ClientAnnalUpdate" runat="server" href='<%#Eval("ClientAnnalID","ClientAnnal.aspx?Action=Modify&id={0}")%>'
                        IsChecked="true" OperateCode="ClientAnnalUpdateAll">
                        修改</pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton ID="ClientAnnalDelete" runat="server" CommandArgument='<%# Eval("ClientAnnalID") %>'
                        OnClick="LBtnDelete_Click" OnClientClick="return confirm('确定要删除此记录吗？')" IsChecked="true"
                        OperateCode="ClientAnnalDelete">删除</pe:ExtendedLinkButton>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnListType" runat="server" Value="0" />
    <asp:ObjectDataSource ID="odsClientAnnal" runat="server" SelectCountMethod="GetTotal"
        EnablePaging='True' SelectMethod="GetInfoList" TypeName="PowerEasy.Module.Crm.BusinessLogic.ClientAnnal">
        <SelectParameters>
            <asp:Parameter Name="startRowIndex" Type="Int32" />
            <asp:Parameter Name="maximumRows" Type="Int32" />
            <asp:QueryStringParameter DefaultValue="0" Name="searchType" QueryStringField="searchType"
                Type="Int32" />
            <asp:QueryStringParameter DefaultValue="0" Name="keyword" QueryStringField="keyword"
                Type="String" />
                <asp:QueryStringParameter Name="field" QueryStringField="field"
                Type="String" />
                 <asp:ControlParameter ControlID="HdnListType" Type="Int32" Name="listType" PropertyName="Value" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <pe:ExtendedButton IsChecked="true" ID="BtnDelete" runat="server" Text="删除选中的记录"
        OnClientClick="return confirm('确定要删除此记录吗？')" OperateCode="ClientAnnalDelete"
        OnClick="BtnDelete_Click" />
</asp:Content>
