﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="True" ValidateRequest="false" EnableEventValidation="false"  
    Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.ClientCheckUI" Title="客户查重"
    CodeBehind="ClientCheck.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
<asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>

    <script language="javascript" type="text/javascript">
        var tID = 0;
        function ShowTabs(ID) {
            if (ID != tID) {
                document.getElementById("TabTitle" + ID).className = "titlemouseover";
                document.getElementById("Tabs" + ID).style.display = "";
                document.getElementById("TabTitle" + tID).className = "tabtitle";
                document.getElementById("Tabs" + tID).style.display = "none";
                document.getElementById("<%= HdnTabsId.ClientID %>").value = ID;
                tID = ID;
            }
        }

        jQuery(function () {
            ShowTabs(0);
        });

    </script>
    <div id="Div_DataRows">
    <pe:ExtendedGridView ID="EgvClient" runat="server" AutoGenerateCheckBoxColumn="False"
        ItemName="客户" ItemUnit="个" AutoGenerateColumns="False" OnRowDataBound="EgvClient_RowDataBound" DataKeyNames="ClientId" AllowPaging="true"
        DataSourceID="OdsClient">
        <Columns>
            <asp:BoundField DataField="ClientId" HeaderText="ID" SortExpression="ShortedForm">
                <HeaderStyle Width="2%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="客户名称">
                <ItemTemplate>
                    <pe:ExtendedAnchor runat="server" ID="LnkClientName" href="javascript:void(0)" IsChecked="false" OperateCode="ClientView">
                        <%#Eval("ClientName")%>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
                <HeaderStyle Width="24%" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="组别" SortExpression="ClientType">
                <ItemTemplate>
                    <%#GetClientGroupName(Convert.ToInt32(Eval("GroupID")))%>
                </ItemTemplate>
                <HeaderStyle Width="10%" />
                <ItemStyle Wrap="false" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="阶段">
                <ItemTemplate>
                    <%#GetPhaseTypeName(Eval("PhaseType").ToString())%>
                </ItemTemplate>
                <HeaderStyle Width="10%" />
            </asp:TemplateField>
            <pe:TemplateField HeaderText="所有者">
                <ItemTemplate>
                    <a href='../User/UserShow.aspx?UserName=<%#Eval("Owner") %>'>
                        <%#Eval("Owner")%></a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="原所有者">
                <ItemTemplate>
                    <a href='../User/UserShow.aspx?UserName=<%#Eval("OldOwner") %>'>
                        <%#Eval("OldOwner")%></a>
                </ItemTemplate>
            </pe:TemplateField>
            <asp:BoundField DataField="LastContactedTime" DataFormatString="{0:yyyy-MM-dd}" HeaderText="最近联系时间"
                HtmlEncode="False" SortExpression="LastContactedTime">
                <HeaderStyle Width="10%" />
                <ItemStyle Wrap="false" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="操作">
                <ItemTemplate>
                    <pe:ExtendedAnchor runat="server" ID="LnkClientShow">
                        查看
                    </pe:ExtendedAnchor>
                </ItemTemplate>
                <HeaderStyle Width="10%" />
                <ItemStyle Wrap="false" />
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    </div>
    <asp:HiddenField ID="HdnKeyword" runat="server" />
    <asp:HiddenField ID="HdnSearchType" runat="server" />
    <asp:ObjectDataSource ID="OdsClient" runat="server" SelectMethod="GetCheckList" TypeName="PowerEasy.Module.Crm.BusinessLogic.Client"
    SelectCountMethod="GetTotalOfClientByCheck" EnablePaging="true" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:ControlParameter ControlID="HdnKeyword" DefaultValue="" Name="keyword" PropertyName="Value" Type="String" />
            <asp:ControlParameter ControlID="HdnSearchType" DefaultValue="0" Name="searchtype" PropertyName="Value" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>

    <asp:HiddenField ID="HdnClientId" runat="server" />
    <asp:HiddenField ID="HdnTabsId" runat="server" Value="0" />
    <br />
    <div id="Div_PostData" style="display:none;">
     <asp:UpdatePanel ID="UpdatePanel1" runat="server" OnLoad="UpdatePanel1_Load">
        <ContentTemplate>
        <div id="Div_ClientInfo" runat="server" visible="false">
            <table width="100%" border="0" cellpadding="0" cellspacing="0">
                <tr align="center">
                    <td id="TabTitle0" class="titlemouseover" onclick="ShowTabs(0)">
                        基本信息
                    </td>
                    <td id="TabTitle1" class="tabtitle" onclick="ShowTabs(1)">
                        相关订单
                    </td>
                    <td>&nbsp;</td>
                </tr>
            </table>
            <table id="Tabs0" width="100%" border="0" cellpadding="5" cellspacing="1" class="border">
                <tr class="tdbg">
                    <td style="width: 15%" align="right" class="tdbgleft">
                        客户名称：
                    </td>
                    <td style="width: 35%">
                        <asp:Label ID="LblClientName" runat="server"></asp:Label>
                    </td>
                    <td style="width: 15%" align="right" class="tdbgleft">
                        客户编号：
                    </td>
                    <td style="width: 35%">
                        <asp:Label ID="LblClientNum" runat="server"></asp:Label>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td align="right" class="tdbgleft">
                        助记名称：
                    </td>
                    <td>
                        <asp:Label ID="LblShortedForm" runat="server"></asp:Label>
                    </td>
                    <td align="right" class="tdbgleft">
                        上级客户：
                    </td>
                    <td>
                        <asp:Label ID="LblParenter" runat="server"></asp:Label>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td align="right" class="tdbgleft">
                        区域：
                    </td>
                    <td>
                        <asp:Label ID="LblArea" runat="server"></asp:Label>
                    </td>
                    <td align="right" class="tdbgleft">
                        行业：
                    </td>
                    <td>
                        <asp:Label ID="LblClientField" runat="server"></asp:Label>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td align="right" class="tdbgleft">
                        价值评估：
                    </td>
                    <td>
                        <asp:Label ID="LblValueLevel" runat="server"></asp:Label>
                    </td>
                    <td align="right" class="tdbgleft">
                        信用等级：
                    </td>
                    <td>
                        <asp:Label ID="LblCreditLevel" runat="server"></asp:Label>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td align="right" class="tdbgleft">
                        重要程度：
                    </td>
                    <td>
                        <asp:Label ID="LblImportance" runat="server"></asp:Label>
                    </td>
                    <td align="right" class="tdbgleft">
                        关系等级：
                    </td>
                    <td>
                        <asp:Label ID="LblConnectionLevel" runat="server"></asp:Label>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td align="right" class="tdbgleft">
                        客户来源：
                    </td>
                    <td>
                        <asp:Label ID="LblSourceType" runat="server"></asp:Label>
                    </td>
                    <td align="right" class="tdbgleft">
                        阶段：
                    </td>
                    <td>
                        <asp:Label ID="LblPhaseType" runat="server"></asp:Label>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td align="right" class="tdbgleft">
                        客户组别：
                    </td>
                    <td>
                        <asp:Label ID="LblGroupID" runat="server"></asp:Label>
                    </td>
                    <td align="right" class="tdbgleft">
                        客户类别：
                    </td>
                    <td>
                        <asp:Label ID="LblClientType" runat="server"></asp:Label>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td align="right" class="tdbgleft">
                        所有者：
                    </td>
                    <td>
                        <asp:Label ID="LblOwner" runat="server"></asp:Label>
                    </td>
                    <td align="right" class="tdbgleft">
                        协销者：
                    </td>
                    <td>
                        <asp:Label ID="LblAssists" runat="server"></asp:Label>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td align="right" class="tdbgleft">
                        服务积分：
                    </td>
                    <td>
                        <asp:Label ID="LblServerPoint" runat="server"></asp:Label>分
                    </td>
                    <td class="tdbgleft" align="right">
                        客户类型：
                    </td>
                    <td>
                        <asp:Label ID="LblIsBuiness" runat="server"></asp:Label>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td class="tdbgleft" align="right">
                        创建时间：
                    </td>
                    <td>
                        <asp:Label ID="LblCreateTime" runat="server"></asp:Label>
                    </td>
                    <td class="tdbgleft" align="right">
                        更新时间：
                    </td>
                    <td>
                        <asp:Label ID="LblUpdateTime" runat="server"></asp:Label>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td class="tdbgleft" align="right">
                        备注：
                    </td>
                    <td colspan="3">
                        <asp:Label ID="LblRemark" runat="server"></asp:Label>
                    </td>
                </tr>
            </table>
            <div id="Tabs1" style="display:none;">
                        <pe:ExtendedGridView ID="EgvOrder" ItemName="订单" ItemUnit="个" AutoGenerateColumns="False" DataSourceID="OdsInfo"
                            DataKeyNames="OrderId" AllowPaging="true" runat="server" OnRowDataBound="EgvOrder_RowDataBound">
                            <Columns>
                                <pe:TemplateField HeaderText="订单编号" SortExpression="OrderNum">
                                    <ItemTemplate>
                                        <a href='../Shop/OrderManage.aspx?OrderID=<%#Eval("OrderId")%>'>
                                            <%#Eval("OrderNum")%>
                                        </a>
                                    </ItemTemplate>
                                </pe:TemplateField>
                                <pe:BoundField DataField="ClientName" HeaderText="客户名称" SortExpression="ClientName">
                                    <HeaderStyle Width="10%" />
                                </pe:BoundField>
                                <pe:BoundField DataField="UserName" HeaderText="用户名" SortExpression="UserName">
                                    <HeaderStyle Width="10%" />
                                </pe:BoundField>
                                <pe:TemplateField HeaderText="下单时间" SortExpression="InputTime">
                                    <HeaderStyle Width="14%" />
                                    <ItemTemplate>
                                        <%# Eval("InputTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
                                    </ItemTemplate>
                                </pe:TemplateField>
                                <pe:TemplateField HeaderText="订单金额" SortExpression="MoneyTotal">
                                    <HeaderStyle Width="8%" />
                                    <ItemTemplate>
                                        -
                                    </ItemTemplate>
                                </pe:TemplateField>
                                <pe:TemplateField HeaderText="收款金额" SortExpression="MoneyReceipt">
                                    <HeaderStyle Width="8%" />
                                    <ItemTemplate>
                                        -
                                    </ItemTemplate>
                                </pe:TemplateField>
                                <pe:TemplateField HeaderText="需要发票" SortExpression="NeedInvoice">
                                    <HeaderStyle Width="5%" />
                                    <ItemTemplate>
                                        <%# (bool)Eval("NeedInvoice") == false ? "<font color=red>×</font>" : "√"%>
                                    </ItemTemplate>
                                </pe:TemplateField>
                                <pe:TemplateField HeaderText="已开发票">
                                    <HeaderStyle Width="5%" />
                                    <ItemTemplate>
                                        <%# (bool)Eval("Invoiced") == false ? "<font color=red>×</font>" : "√"%>
                                    </ItemTemplate>
                                </pe:TemplateField>
                                <pe:TemplateField HeaderText="订单状态">
                                    <HeaderStyle Width="10%" />
                                    <ItemTemplate>
                                        <pe:ExtendedLabel HtmlEncode="false" ID="LblOrderStatus" runat="server" />
                                    </ItemTemplate>
                                </pe:TemplateField>
                                <pe:TemplateField HeaderText="付款状态">
                                    <HeaderStyle Width="10%" />
                                    <ItemTemplate>
                                        <pe:ExtendedLabel HtmlEncode="false" ID="LblPayStatus" runat="server" />
                                    </ItemTemplate>
                                </pe:TemplateField>
                                <pe:TemplateField HeaderText="物流状态">
                                    <HeaderStyle Width="10%" />
                                    <ItemTemplate>
                                        <pe:ExtendedLabel HtmlEncode="false" ID="LblDeliverStatus" runat="server" ForeColor="AliceBlue" />
                                    </ItemTemplate>
                                </pe:TemplateField>
                            </Columns>
                        </pe:ExtendedGridView>
                        <asp:ObjectDataSource ID="OdsInfo" runat="server" EnablePaging="True" SelectCountMethod="GetTotalOfOrder" SelectMethod="GetList"
                         TypeName="PowerEasy.Module.Shop.BusinessLogic.Order" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
                            <SelectParameters>
                                <asp:Parameter Name="searchType" Type="String" DefaultValue="31" />
                                <asp:Parameter Name="field" Type="String" DefaultValue="" />
                                <asp:ControlParameter Name="keyword" Type="String" ControlID="HdnClientId" PropertyName="Value" />
                                <asp:Parameter Name="action" Type="String" DefaultValue="search" />
                                <asp:Parameter Name="orderTypes" Type="Int32" DefaultValue="0" />
                                <asp:Parameter Name="filtration" Type="String" DefaultValue="" />
                                <asp:Parameter Name="IsAdmin" Type="Boolean" DefaultValue="true" />
                            </SelectParameters>
                         </asp:ObjectDataSource>
                    </div>
        </div>
        </ContentTemplate>
    </asp:UpdatePanel>
    </div>

    <br />
    
        <script language="javascript" type="text/javascript">
            function ShowOnNewFrameTab(id) {
                document.getElementById("<%= HdnClientId.ClientID %>").value = id;
                ShowClientInfo(id);
            }

            function ShowClientInfo(id) {
                __doPostBack('<%=UpdatePanel1.ClientID %>', "");
                ShowTabs(0);
                if (jQuery("tr[id^='temptr']").length == 0) {
                    AddInfoTr(id);
                } else {
                    jQuery("tr[id^='temptr']").each(function () {
                        if (jQuery(this).attr("id").replace("temptr", "") == id.toString()) {
                            jQuery(this).remove();
                        } else {
                            jQuery(this).remove();
                            AddInfoTr(id);
                        }
                    });
                }
            }

            function AddInfoTr(id) {
                jQuery("#Div_DataRows table tr").each(function () {
                    if (jQuery(this).find("td:first-child").text() == id.toString()) {
                        jQuery(this).after("<tr id='temptr" + id + "' class='tdbg'><td colspan='" + jQuery(this).find("td").length + "'>" + jQuery("#Div_PostData").html() + "</td></tr>");
                    }
                });
            }

            function BindTabs() {
                tID = 0;
                var id = document.getElementById("<%= HdnTabsId.ClientID %>").value;
                ShowTabs(id);
            }
    </script>
</asp:Content>
