﻿<%@ Page Title="添加回访记录" Language="C#" MasterPageFile="~/Admin/MasterPage.master"
    AutoEventWireup="true" CodeBehind="ClientConfirmAdd.aspx.cs" Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.ClientConfirmAdd" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="title">
                <strong>
                    <asp:Literal ID="LtrTitle" runat="server" Text="添加回访记录"></asp:Literal></strong>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft" style="width: 30%">
                客户名称：
            </td>
            <td>
                <asp:TextBox ID="txtSelectClient" Width="135" runat="server"></asp:TextBox>
                <pec:FloatingDialog ID="floatSelectFromerAdmin" runat="server" Name="选择客户名称" Title="选择客户名称"
                    Width="600" Height="500" BeginString="【" EndString="】" Skin="floatingDialogFontSkin" />
                <asp:HiddenField ID="HnSelectClient" runat="server" />
                <pe:RequiredFieldValidator ID="ValrClientName" runat="server" ErrorMessage="请输入对应客户"
                    Display="Dynamic" ControlToValidate="txtSelectClient"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                回访人员：
            </td>
            <td>
                <asp:TextBox ID="txtSelectAdmin" Width="135" runat="server"></asp:TextBox>
                <pec:FloatingDialog ID="floatSelectAdmin" runat="server" Name="选择回访人员" Title="选择回访人员"
                    Width="600" Height="500" BeginString="【" EndString="】" Skin="floatingDialogFontSkin" />
                <asp:HiddenField ID="HnSelectAdmin" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                回访方式：
            </td>
            <td>
                <span id="ContacterList">
                    <asp:DropDownList ID="DropWay" runat="server" Width="130px" DataTextField="DataTextField"
                        DataValueField="DataValueField">
                    </asp:DropDownList>
                </span>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft" style="height: 25px">
                回访类型：
            </td>
            <td style="height: 25px">
                <asp:DropDownList ID="DropType" runat="server" Width="130px" DataTextField="DataTextField"
                    DataValueField="DataValueField">
                </asp:DropDownList>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                回访结果：
            </td>
            <td>
                <asp:TextBox ID="txtResult" runat="server" MaxLength="50"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                回访日期：
            </td>
            <td>
                <pe:DatePicker ID="DpkConfirmDate" runat="server" IsLongDate="false"></pe:DatePicker><pe:RegexValidator
                    ValidateType="Date" ID="Vdate" ControlToValidate="DpkConfirmDate" Display="Dynamic"
                    SetFocusOnError="true" runat="server"></pe:RegexValidator>
                <pe:RequiredFieldValidator ID="ValrEndTime" runat="server" ErrorMessage="时间不能为空!"
                    ControlToValidate="DpkConfirmDate" Display="Dynamic"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                回访进度：
            </td>
            <td>
                <asp:TextBox ID="txtProcess" runat="server" Text="100" Width="60px"></asp:TextBox>%
                <asp:RangeValidator ID="RangeValidator1" runat="server" ControlToValidate="txtProcess"
                    Type="Integer" MaximumValue="100" MinimumValue="0" ErrorMessage="请输入0到100之间的数字"></asp:RangeValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                记录类型：
            </td>
            <td>
                <asp:RadioButtonList runat="server" ID="rdlType" RepeatDirection="Horizontal">
                    <asp:ListItem Text="建议" Selected='True' Value="1" />
                    <asp:ListItem Text="意见" Value="0" />
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                回访记录：
            </td>
            <td>
                <asp:TextBox ID="TxtRecord" runat="server" TextMode="MultiLine" MaxLength="500" Width="270px"
                    Height="70px"></asp:TextBox>
            </td>
        </tr>
        <tr align="center">
            <td style="height: 40px" colspan="2" class="tdbg">
                <asp:Button ID="BtnSave" runat="server" Text="保存" OnClick="BtnSave_Click" />
                <asp:Button ID="BtnReturn" runat="server" Text="取消" CausesValidation="false" OnClick="BtnReturn_Click" />
            </td>
        </tr>
    </table>
</asp:Content>
