﻿<%@ Page Title="回访管理" Language="C#" MasterPageFile="~/Admin/MasterPage.master"
    AutoEventWireup="true" CodeBehind="ClientConfirmManage.aspx.cs" Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.ClientConfirmManage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <pe:Bookmarks ID="BookmarksClientConfirm" ControlID="HdnType" ExtendedGridViewID="EgvService"
        runat="server">
        <pe:BookmarkItem Title="全部">0</pe:BookmarkItem>
        <pe:BookmarkItem Title="未完成" Value="1" />
        <pe:BookmarkItem Title="已完成" Value="2" />
    </pe:Bookmarks>
    <pe:ExtendedGridView ID="EgvClientConfirm" runat="server" ItemUnit="个" AutoGenerateColumns="False"
        DataKeyNames="ID" OnRowDataBound="EgvClientConfirm_RowDataBound" AllowPaging="True"
        RowDblclickBoundField="ID" RowDblclickUrl="ClientConfirmShow.aspx?id={$Field}"
        DataSourceID="OdsClientConfirm" CheckBoxFieldHeaderWidth="3%" SerialText="" AutoGenerateCheckBoxColumn="True">
        <Columns>
            <pe:BoundField HeaderText="ID" SortExpression="ID" DataField="ID">
                <HeaderStyle Width="3%" />
            </pe:BoundField>
            <pe:BoundField DataField="ClientConfirmTime" HeaderText="回访时间" SortExpression="ClientConfirmTime"
                DataFormatString="{0:yyyy-MM-dd}" HtmlEncode="False">
                <HeaderStyle Width="7%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="客户名称">
                <ItemTemplate>
                <pe:ExtendedAnchor ID="eClientname" IsChecked="true" runat="server" OperateCode="ClientView">
                        <%#Eval("ClientName")%></pe:ExtendedAnchor>
                </ItemTemplate>
                <HeaderStyle Width="7%" />
            </pe:TemplateField>
            <pe:TemplateField HeaderText="回访类型" HeaderStyle-Width="7%">
                <ItemTemplate>
                    <asp:Label ID="labType" runat="server"></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="回访方式" HeaderStyle-Width="7%">
                <ItemTemplate>
                    <asp:Label ID="labWay" runat="server"></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField HeaderText="回访人" SortExpression="AdminName" DataField="AdminName">
                <HeaderStyle Width="7%" />
            </pe:BoundField>
            <pe:BoundField HeaderText="回访结果" SortExpression="Resualt" DataField="Resualt">
                <HeaderStyle Width="7%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="回访记录">
                <ItemTemplate>
                    <asp:Label ID="labRecord" runat="server"></asp:Label>
                </ItemTemplate>
                <HeaderStyle Width="13%" />
            </pe:TemplateField>
            
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor ID="eView" runat="server" OperateCode="ClientCallShow" href='<%# Eval("ID", "ClientConfirmShow.aspx?ID={0}") %>'>
                        查看</pe:ExtendedAnchor>
                    <pe:ExtendedAnchor ID="ModifyOwn" runat="server" OperateCode="ServiceCallModifyAll"
                        href='<%#string.Format("ClientConfirmAdd.aspx?Action=Modify&ID={0}",Eval("ID")) %>'>
                        修改</pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton ID="LbtnDelete" runat="server" OperateCode="ClientCallDelete"
                        CausesValidation="False" CommandName="Delete" OnClientClick="return confirm('是否删除该记录？')">删除</pe:ExtendedLinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <br />
    &nbsp;&nbsp;
    <pe:ExtendedButton IsChecked="true" OperateCode="ClientCallDelete" ID="BtnDelete"
        runat="server" OnClick="BtnDelete_Click" OnClientClick="return batchconfirm('是否要删除选中的记录？')"
        Text="删除选中的回访记录" />&nbsp;
    <pe:OneClickButton ID="BtnExport" runat="server" Text="导出到Excel" OnClick="BtnExport_Click"
        IsOneClick="false" /><br />
    <asp:HiddenField ID="HdnType" runat="server" Value="0" />
    <asp:ObjectDataSource ID="OdsClientConfirm" runat="server" SelectCountMethod="GetTotal"
        SelectMethod="GetClientConfirmList" TypeName="PowerEasy.Module.Crm.BusinessLogic.ClientConfirm"
        DeleteMethod="Delete" EnablePaging="True" StartRowIndexParameterName="startRowIndexId"
        MaximumRowsParameterName="maxNumberRows">
        <DeleteParameters>
            <asp:Parameter Name="ID" Type="String" />
        </DeleteParameters>
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="keyword" QueryStringField="keyword"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="0" Name="searchType" QueryStringField="searchType"
                Type="String" />
            <asp:ControlParameter ControlID="HdnType" Type="Int32" Name="listType" PropertyName="Value" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:HiddenField ID="HdnComplexSearch" runat="server" />
    <br />
</asp:Content>
