﻿<%@ Page Title="客户回访复杂查询" Language="C#" MasterPageFile="~/Admin/MasterPage.master"
    AutoEventWireup="true" CodeBehind="ClientConfirmSearch.aspx.cs" Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.ClientConfirmSearch" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider">
    </pe:ExtendedSiteMapPath>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="title">
                <strong>
                    <asp:Literal ID="LtrTitle" runat="server" Text="客户回访复杂查询"></asp:Literal></strong>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft" style="width: 30%">
                客户名称：
            </td>
            <td>
                <asp:TextBox ID="txtClientName" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                回访人员：
            </td>
            <td>
                <asp:TextBox ID="txtAdminName" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                录入人员：
            </td>
            <td>
                <asp:TextBox ID="txtInputer" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                回访方式：
            </td>
            <td>
                <span id="ContacterList">
                    <asp:DropDownList ID="DropWay" runat="server" Width="130px" DataTextField="DataTextField"
                        DataValueField="DataValueField">
                    </asp:DropDownList>
                </span>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft" style="height: 25px">
                回访类型：
            </td>
            <td style="height: 25px">
                <asp:DropDownList ID="DropType" runat="server" Width="130px" DataTextField="DataTextField"
                    DataValueField="DataValueField">
                </asp:DropDownList>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                回访结果：
            </td>
            <td>
                <asp:TextBox ID="txtResult" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                回访日期：
            </td>
            <td>
                <pe:DatePicker ID="DpkConfirmDate" runat="server" IsLongDate="false"></pe:DatePicker><pe:RegexValidator
                    ValidateType="Date" ID="Vdate" ControlToValidate="DpkConfirmDate" Display="Dynamic"
                    SetFocusOnError="true" runat="server"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                回访进度：
            </td>
            <td>
                <asp:TextBox ID="txtProcess" runat="server"></asp:TextBox>
                <asp:RangeValidator ID="RangeValidator1" runat="server" ControlToValidate="txtProcess"
                    Type="Integer" MaximumValue="100" MinimumValue="0" ErrorMessage="请输入0到100之间的数字"></asp:RangeValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                记录类型：
            </td>
            <td>
                <asp:RadioButtonList runat="server" ID="rdlType" RepeatDirection="Horizontal">
                    <asp:ListItem Text="所有" Selected='True' Value="-1" />
                    <asp:ListItem Text="建议" Value="1" />
                    <asp:ListItem Text="意见" Value="0" />
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                回访记录：
            </td>
            <td>
                <asp:TextBox ID="TxtRecord" runat="server" TextMode="MultiLine" MaxLength="500" Width="270px"
                    Height="70px"></asp:TextBox>
            </td>
        </tr>
        <tr align="center">
            <td class="tdbg" colspan="2" style="height: 40px">
                <asp:Button ID="BtnSearch" runat="server" OnClick="BtnSearch_Click" PostBackUrl="~/Admin/Crm/ClientConfirmManage.aspx"
                    Text="查 询" />&nbsp; &nbsp;<input id="Reset1" type="reset" class="inputbutton" value="复 位" />
            </td>
        </tr>
    </table>
</asp:Content>
