﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="ClientDelete.aspx.cs" Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.ClientDelete"
    Title="删除客户" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="title">
                删除客户
            </td>
        </tr>
        <tr id="spn_client" runat="server" visible="false" class="tdbg">
            <td align="right" style="width: 15%;" class="tdbgleft">
                选择客户：
            </td>
            <td align="left">
                    <asp:RadioButton ID="RadAll" GroupName="CheckedClient" runat="server" />所有客户
                    <br />
                    <asp:RadioButton ID="RadGroup" GroupName="CheckedClient" runat="server" />指定客户组
                    <asp:CheckBoxList ID="ChklGroup" RepeatDirection="horizontal" RepeatLayout="flow"
                        DataTextField="DataTextField" DataValueField="DataValueField" runat="server">
                    </asp:CheckBoxList>
                    <br />
                    <asp:RadioButton ID="RadClientID" GroupName="CheckedClient" Checked="true" runat="server" />指定客户ID
                    <asp:TextBox ID="TxtClientIDList" runat="server"></asp:TextBox>
                    <asp:CustomValidator ID="ValxClientIDList" ClientValidationFunction="ValxClientIDList_ClientValidate"
                        Display="dynamic" ValidateEmptyText="true" SetFocusOnError="true" runat="server"
                        ErrorMessage="指定要删除的客户ID" ControlToValidate="TxtClientIDList"></asp:CustomValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" style="width: 15%;" class="tdbgleft">
                排除条件：
            </td>
            <td align="left">
                <asp:CheckBoxList ID="ChklExclusion" runat="server" RepeatColumns="3" RepeatDirection="horizontal">
                    <asp:ListItem Value="ExcludingBalance" Selected="true">不包括资金余额大于0的客户</asp:ListItem>
                    <asp:ListItem Value="ExcludingOrder" Selected="true">不包括已下订单的客户</asp:ListItem>
                    <asp:ListItem Value="ExcludingBankroll" Selected="true">不包括有资金明细记录的客户</asp:ListItem>
                    <asp:ListItem Value="ExcludingService" Selected="true">不包括有服务记录的客户</asp:ListItem>
                    <asp:ListItem Value="ExcludingComplain" Selected="true">不包括有投诉记录的客户</asp:ListItem>
                    <asp:ListItem Value="ExcludingClientAnnal">不包括有联系记录的客户</asp:ListItem>
                    <asp:ListItem Value="ExcludingRemind" Selected="true">不包括有预约提醒的客户</asp:ListItem>
                </asp:CheckBoxList>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" style="width: 15%;" class="tdbgleft">
                将删除的相关信息：
            </td>
            <td align="left">
                <asp:CheckBoxList ID="ChklDelInfo" RepeatColumns="4" RepeatDirection="horizontal"
                    runat="server">
                    <asp:ListItem Value="DelOrder">相关订单</asp:ListItem>
                    <asp:ListItem Value="DelBankroll">相关资金明细记录</asp:ListItem>
                    <asp:ListItem Value="DelService">相关服务记录</asp:ListItem>
                    <asp:ListItem Value="DelComplain">相关投诉记录</asp:ListItem>
                    <asp:ListItem Value="DelCompany">相关企业</asp:ListItem>
                    <asp:ListItem Value="DelContacter">相关联系人</asp:ListItem>
                    <asp:ListItem Value="DelUser">相关会员及相关信息</asp:ListItem>
                    <asp:ListItem Value="DelClientAnnal">相关联系记录</asp:ListItem>
                    <asp:ListItem Value="DelRemind">相关预约提醒</asp:ListItem>
                </asp:CheckBoxList>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="center" colspan="2">
                <asp:Button ID="BtnDelete" runat="server" Text="执行删除操作" OnClientClick="javascript:Page_ClientValidate();if(Page_IsValid){return confirm('确定执行删除操作吗？');}"
                    OnClick="BtnDelete_Click" />
                <asp:Button ID="BtnCancel" runat="server" Text="取消" OnClick="BtnCancel_Client" CausesValidation="false" />
            </td>
        </tr>
    </table>

    <script language="javascript" type="text/javascript">
        function ValxClientIDList_ClientValidate(s, e) {
            var clientIDList = document.getElementById('<%=TxtClientIDList.ClientID %>').value;
            var radClientID = document.getElementById('<%=RadClientID.ClientID %>');
            if (radClientID.checked == true) {
                if (clientIDList == "") {
                    e.IsValid = false;
                }
                else {
                    e.IsValid = true;
                }
            }
            else {
                e.IsValid = true;
            }
        }
    </script>

</asp:Content>
