﻿<%@ Page Title="添加客户项目" Language="C#" MasterPageFile="~/Admin/MasterPage.master"
    AutoEventWireup="true" CodeBehind="ClientItemAdd.aspx.cs" Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.ClientItemAdd" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="title">
                <strong>
                    <asp:Literal ID="LtrTitle" runat="server" Text="添加客户项目"></asp:Literal></strong>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft" style="width: 30%">
                客户名称：
            </td>
            <td>
                <asp:TextBox ID="txtClientName" Width="135" Enabled="false" runat="server" MaxLength="50"></asp:TextBox>
                <pec:FloatingDialog ID="dlgSelectClient" runat="server" Name="选择客户名称" Title="选择客户名称"
                    Width="600" Height="500" BeginString="【" EndString="】" Skin="floatingDialogFontSkin" />
                <pe:RequiredFieldValidator ID="ValrClientName" runat="server" ErrorMessage="请选择对应客户"
                    Display="Dynamic" ControlToValidate="txtClientName"></pe:RequiredFieldValidator>
                <asp:HiddenField ID="hdnClientID" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft" style="width: 30%">
                跟单员：
            </td>
            <td>
                <asp:TextBox ID="txtSeller" Width="135" runat="server"></asp:TextBox>
                <pec:FloatingDialog ID="dlgSeller" runat="server" Name="选择跟单员" Title="选择跟单员" Width="600"
                    Height="500" BeginString="【" EndString="】" Skin="floatingDialogFontSkin" />
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                项目状态：
            </td>
            <td>
                <asp:DropDownList ID="dropStatus" runat="server" Width="135px" DataTextField="DataTextField"
                    DataValueField="DataValueField">
                </asp:DropDownList>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                项目大小：
            </td>
            <td>
                <asp:TextBox ID="txtPrice" runat="server" Width="135px" MaxLength="8"></asp:TextBox>元
                <asp:CompareValidator ID="VlcPrice" runat="server" ControlToValidate="txtPrice" Display="Dynamic"
                    ErrorMessage="请输入大于0的整数值！" Operator="GreaterThanEqual" SetFocusOnError="True"
                    Type="Integer" ValueToCompare="0"></asp:CompareValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                预计签单日期：
            </td>
            <td>
                <pe:DatePicker ID="dpkEstimatDate" runat="server" Width="135px"></pe:DatePicker>
                <pe:RegexValidator ValidateType="Date" ID="Vdate" ControlToValidate="dpkEstimatDate"
                    Display="Dynamic" SetFocusOnError="true" runat="server"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                销售预计成功率：
            </td>
            <td>
                <asp:TextBox ID="txtSalesESRatio" runat="server" Width="135px"></asp:TextBox>%
                <asp:RangeValidator ID="valSalesESRatio" runat="server" ControlToValidate="txtSalesESRatio"
                    Type="Integer" MaximumValue="100" MinimumValue="0" ErrorMessage="请输入0到100之间的数字"></asp:RangeValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                经理预计成功率：
            </td>
            <td>
                <asp:TextBox ID="txtManagerESRatio" runat="server" Width="135px"></asp:TextBox>%
                <asp:RangeValidator ID="valManagerESRatio" runat="server" ControlToValidate="txtManagerESRatio"
                    Type="Integer" MaximumValue="100" MinimumValue="0" ErrorMessage="请输入0到100之间的数字"></asp:RangeValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                备注：
            </td>
            <td>
                <asp:TextBox ID="txtRemark" runat="server" TextMode="MultiLine" Width="320px" Height="120px"></asp:TextBox>
                <asp:RegularExpressionValidator ID="valRemark" ControlToValidate="txtRemark" Text="不能超过200字"
                    ValidationExpression="^[\s\S]{0,200}$" runat="server" />
            </td>
        </tr>
        <tr align="center">
            <td style="height: 40px" colspan="2" class="tdbg">
                <asp:Button ID="BtnSave" runat="server" Text="添 加" OnClick="BtnSave_Click" />
                <asp:Button ID="BtnReturn" runat="server" Text="取 消" CausesValidation="false" OnClick="BtnReturn_Click" />
            </td>
        </tr>
    </table>
</asp:Content>
