﻿<%@ Page Title="客户项目管理" Language="C#" MasterPageFile="~/Admin/MasterPage.master"
    AutoEventWireup="true" CodeBehind="ClientItemManage.aspx.cs" Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.ClientItemManage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <pe:Bookmarks ID="BookmarksClientConfirm" ControlID="HdnType" ExtendedGridViewID="EgvService"
        runat="server">
        <pe:BookmarkItem Title="全部项目" Value="0"></pe:BookmarkItem>
        <pe:BookmarkItem Title="重点项目" Value="1" />
        <pe:BookmarkItem Title="普通项目" Value="2" />
    </pe:Bookmarks>
    <pe:ExtendedGridView ID="egvClientItem" runat="server" AllowPaging="true" AutoGenerateColumns="false"
        RowDblclickBoundField="ID" RowDblclickUrl="ClientItemShow.aspx?ID={$Field}" AutoGenerateCheckBoxColumn="true"
        EmptyDataText="没有任何记录" DataKeyNames="ID" DataSourceID="odsClientItem" OnRowDataBound="egvClientItem_OnRowDataBound"
        CheckBoxFieldHeaderWidth="3%">
        <Columns>
            <asp:BoundField DataField="ID" HeaderText="ID" ItemStyle-Width="3%" />
            <asp:TemplateField HeaderText="客户名称" HeaderStyle-Width="15%">
                <ItemTemplate>
                    <pe:ExtendedAnchor runat="server" ID="LnkClientName" IsChecked="false" OperateCode="ClientView">
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="Seller" HeaderText="跟单员" ItemStyle-Width="6%" />
            <asp:TemplateField HeaderText="项目状态" HeaderStyle-Width="8%">
                <ItemTemplate>
                    <asp:Label ID="labItemStatus" runat="server"></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="项目大小" HeaderStyle-Width="8%" ItemStyle-HorizontalAlign="Right">
                <ItemTemplate>
                    <asp:Label ID="labPrice" runat="server"></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="EstimatDate" HeaderText="预计签单日期" DataFormatString="{0:yyyy-MM}"
                ItemStyle-Width="10%" />
            <asp:TemplateField HeaderText="销售预测成功率" HeaderStyle-Width="13%">
                <ItemTemplate>
                    <asp:Label ID="labSalesESRatio" runat="server"></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="经理预测成功率" HeaderStyle-Width="13%">
                <ItemTemplate>
                    <asp:Label ID="labManagerESRatio" runat="server"></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor ID="eView" runat="server" href='<%# Eval("ID", "ClientItemShow.aspx?ID={0}") %>'>
                        查看</pe:ExtendedAnchor>
                    <pe:ExtendedAnchor ID="ModifyOwn" runat="server" OperateCode="ClientItemAdd" href='<%#string.Format("ClientItemAdd.aspx?Action=Modify&ID={0}",Eval("ID")) %>'>
                        修改</pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton ID="LbtnDelete" runat="server" CausesValidation="False" CommandName="Delete"
                        IsChecked="true" OperateCode="ClientItemDelete" OnClientClick="return confirm('是否删除该记录？')">删除</pe:ExtendedLinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnType" runat="server" />
    <asp:ObjectDataSource ID="odsClientItem" runat="server" SelectMethod="GetClientItemInfoList"
        TypeName="PowerEasy.Module.Crm.BusinessLogic.ClientItem" SelectCountMethod="GetTotal"
        DeleteMethod="Delete" EnablePaging="true" MaximumRowsParameterName="maxNumberRows"
        StartRowIndexParameterName="startRowIndexId">
        <DeleteParameters>
            <asp:Parameter Name="ID" Type="String" />
        </DeleteParameters>
        <SelectParameters>
            <asp:ControlParameter ControlID="HdnType" Type="Int32" Name="listType" PropertyName="Value" />
            <asp:QueryStringParameter Name="SearchType" QueryStringField="searchType" Type="Int32" />
            <asp:QueryStringParameter Name="KeyWord" QueryStringField="KeyWord" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    &nbsp;&nbsp;
    <pe:ExtendedButton IsChecked="true" OperateCode="ClientItemDelete" ID="BtnDelete"
        runat="server" OnClick="BtnDelete_Click" OnClientClick="return batchconfirm('是否要删除选中的客户项目记录？')"
        Text="删除选中的客户项目记录" />&nbsp;
    <pe:OneClickButton ID="BtnExport" runat="server" Text="导出到Excel" OnClick="BtnExport_Click"
        IsOneClick="false" />
</asp:Content>
