﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.ClientShow" Title="显示客户信息"
    CodeBehind="ClientShow.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <asp:ScriptManager ID="SMClientShow" runat="server" ScriptMode="Inherit">
    </asp:ScriptManager>

    <script language="javascript" type="text/javascript">

        var tID = 0;
        function ShowTabs(ID) {
            if (ID != tID) {
                document.getElementById("TabTitle" + ID).className = "titlemouseover";
                document.getElementById("Tabs" + ID).style.display = "";
                document.getElementById("TabTitle" + tID).className = "tabtitle";
                document.getElementById("Tabs" + tID).style.display = "none";
                tID = ID;
            }
        } 
    </script>

    <br />
    <table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr align="center">
            <td id="TabTitle0" class="titlemouseover" onclick="ShowTabs(0)">
                基本信息
            </td>
            <asp:PlaceHolder runat="server" ID="PlhTabTitle">
                <td id="TabTitle1" class="tabtitle" onclick="ShowTabs(1)">
                    联络信息
                </td>
                <td id="TabTitle2" style="<%= IsShow(0)%>" class="tabtitle" onclick="ShowTabs(2)">
                    企业信息
                </td>
                <td id="TabTitle3" style="<%= IsShow(1)%>" class="tabtitle" onclick="ShowTabs(3)">
                    业务信息
                </td>
                <td id="TabTitle4" style="<%= IsShow(1)%>" class="tabtitle" onclick="ShowTabs(4)">
                    个人信息
                </td>
                <%--            <td id="TabTitle5" class="tabtitle" onclick="ShowTabs(5)">
                    备注信息
                </td>--%>
                <td id="TabTitle6" style="display: none;" class="tabtitle" onclick="ShowTabs(6)">
                    会员选项
                </td>
                <td id="TabTitle7" style="<%= IsShow(0)%>" class="tabtitle" onclick="ShowTabs(7)">
                    企业选项
                </td>
                <td>
                <asp:UpdatePanel ID="UpPnlToUser" runat="server" RenderMode="Inline">
                <ContentTemplate>                     
                    <asp:DropDownList ID="DropToUsers" runat="server" AutoPostBack="True" Visible="false" onselectedindexchanged="DropToUsers_SelectedIndexChanged" /><asp:Button ID="BtnToUser" runat="server" CssClass="inputbutton" OnClick="BtnToUser_Click" Text="切换到对应会员信息页" />
                </ContentTemplate>
                </asp:UpdatePanel>
                </td>
            </asp:PlaceHolder>
            <td>
                &nbsp;
            </td>
        </tr>
    </table>
    <table width="100%" border="0" cellpadding="5" cellspacing="1" class="border">
        <tr class="tdbg">
            <td style="height: 100px;" valign="top">
                <table id="Tabs0" cellpadding="2" cellspacing="1" style="width: 95%; background-color: white;">
                    <tr class="tdbg">
                        <td style="width: 15%" align="right" class="tdbgleft">
                            客户名称：
                        </td>
                        <td style="width: 38%">
                            <asp:Label ID="LblClientName" runat="server"></asp:Label>
                        </td>
                        <td style="width: 15%" align="right" class="tdbgleft">
                            客户编号：
                        </td>
                        <td style="width: 38%">
                            <asp:Label ID="LblClientNum" runat="server"></asp:Label>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            助记名称：
                        </td>
                        <td>
                            <asp:Label ID="LblShortedForm" runat="server"></asp:Label>
                        </td>
                        <td align="right" class="tdbgleft">
                            上级客户：
                        </td>
                        <td>
                            <asp:Label ID="LblParenter" runat="server"></asp:Label>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            区域：
                        </td>
                        <td>
                            <asp:Label ID="LblArea" runat="server"></asp:Label>
                        </td>
                        <td align="right" class="tdbgleft">
                            行业：
                        </td>
                        <td>
                            <asp:Label ID="LblClientField" runat="server"></asp:Label>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            价值评估：
                        </td>
                        <td>
                            <asp:Label ID="LblValueLevel" runat="server"></asp:Label>
                        </td>
                        <td align="right" class="tdbgleft">
                            信用等级：
                        </td>
                        <td>
                            <asp:Label ID="LblCreditLevel" runat="server"></asp:Label>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            重要程度：
                        </td>
                        <td>
                            <asp:Label ID="LblImportance" runat="server"></asp:Label>
                        </td>
                        <td align="right" class="tdbgleft">
                            关系等级：
                        </td>
                        <td>
                            <asp:Label ID="LblConnectionLevel" runat="server"></asp:Label>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            客户来源：
                        </td>
                        <td>
                            <asp:Label ID="LblSourceType" runat="server"></asp:Label>
                        </td>
                        <td align="right" class="tdbgleft">
                            阶段：
                        </td>
                        <td>
                            <asp:Label ID="LblPhaseType" runat="server"></asp:Label>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            客户组别：
                        </td>
                        <td>
                            <asp:Label ID="LblGroupID" runat="server"></asp:Label>
                        </td>
                        <td align="right" class="tdbgleft">
                            客户类别：
                        </td>
                        <td>
                            <asp:Label ID="LblClientType" runat="server"></asp:Label>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            &nbsp;所有者：
                        </td>
                        <td>
                            &nbsp;<asp:Label ID="LblOwner" runat="server"></asp:Label>
                        </td>
                        <td align="right" class="tdbgleft">
                            &nbsp;协销者：
                        </td>
                        <td>
                            &nbsp;<asp:Label ID="LblAssists" runat="server"></asp:Label>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            服务积分：
                        </td>
                        <td>
                            <asp:Label ID="LblServerPoint" runat="server"></asp:Label>分
                        </td>
                        <td style="width: 15%" class="tdbgleft" align="right">
                            &nbsp;客户类型：
                        </td>
                        <td style="width: 38%">
                            <asp:Label ID="LblIsBuiness" runat="server"></asp:Label>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td style="width: 15%" class="tdbgleft" align="right">
                            &nbsp;创建时间：
                        </td>
                        <td style="width: 38%">
                            <asp:Label ID="LblCreateTime" runat="server"></asp:Label>
                        </td>
                        <td style="width: 15%" class="tdbgleft" align="right">
                            &nbsp;更新时间：
                        </td>
                        <td style="width: 38%">
                            <asp:Label ID="LblUpdateTime" runat="server"></asp:Label>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td style="width: 15%" class="tdbgleft" align="right">
                            最大订单金额：
                        </td>
                        <td style="width: 38%">
                            <asp:Label ID="LblMaxOrderMoney" runat="server"></asp:Label>
                        </td>
                        <td style="width: 15%" class="tdbgleft" align="right">
                            &nbsp;备注：
                        </td>
                        <td style="width: 38%">
                            <asp:Label ID="LblRemark" runat="server"></asp:Label>
                        </td>
                    </tr>
                </table>
                <asp:PlaceHolder runat="server" ID="PlhTabs">
                    <table id="Tabs1" cellpadding="2" cellspacing="1" style="width: 95%; background-color: white;
                        display: none" >
                        <tr class="tdbg">
                            <td style="width: 15%" align="right" class="tdbgleft">
                                国家/地区：
                            </td>
                            <td style="width: 38%">
                                <asp:Label ID="LblCountry" runat="server"></asp:Label>
                            </td>
                            <td style="width: 15%" align="right" class="tdbgleft">
                                省/市：
                            </td>
                            <td style="width: 38%">
                                <asp:Label ID="LblProvince" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td style="width: 15%" align="right" class="tdbgleft">
                                市/县/区：
                            </td>
                            <td style="width: 38%">
                                <asp:Label ID="LblCity" runat="server"></asp:Label>
                            </td>
                            <td style="width: 15%" align="right" class="tdbgleft">
                                邮政编码：
                            </td>
                            <td style="width: 38%">
                                <asp:Label ID="LblZipCode" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td style="width: 15%" align="right" class="tdbgleft">
                                联系地址：
                            </td>
                            <td colspan="3">
                                <asp:Label ID="LblAddress" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tbody id="infoE" style="<%=IsShow(0) %>">
                            <tr class="tdbg">
                                <td style="width: 15%" align="right" class="tdbgleft">
                                    联系电话：
                                </td>
                                <td style="width: 38%">
                                    <asp:Label ID="LblPhone" runat="server"></asp:Label>
                                </td>
                                <td style="width: 15%" align="right" class="tdbgleft">
                                    传真号码：
                                </td>
                                <td style="width: 38%">
                                    <asp:Label ID="LblFax1" runat="server"></asp:Label>
                                </td>
                            </tr>
                        </tbody>
                        <tbody id="infoP" style="<%=IsShow(1) %>">
                            <tr class="tdbg">
                                <td style="width: 15%" align="right" class="tdbgleft">
                                    办公电话：
                                </td>
                                <td style="width: 38%">
                                    <asp:Label ID="LblOfficePhone" runat="server"></asp:Label>
                                </td>
                                <td style="width: 15%" align="right" class="tdbgleft">
                                    住宅电话：
                                </td>
                                <td style="width: 38%">
                                    <asp:Label ID="LblHomePhone" runat="server"></asp:Label>
                                </td>
                            </tr>
                            <tr class="tdbg">
                                <td style="width: 15%" align="right" class="tdbgleft">
                                    移动电话：
                                </td>
                                <td>
                                    <asp:Label ID="LblMobile" runat="server"></asp:Label>
                                </td>
                                <td style="width: 15%" align="right" class="tdbgleft">
                                    传真号码：
                                </td>
                                <td>
                                    <asp:Label ID="LblFax2" runat="server"></asp:Label>
                                </td>
                            </tr>
                            <tr class="tdbg">
                                <td style="width: 15%" align="right" class="tdbgleft">
                                    小灵通：
                                </td>
                                <td>
                                    <asp:Label ID="LblPHS" runat="server"></asp:Label>
                                </td>
                                <td class="tdbgleft" align="right">
                                </td>
                                <td>
                                </td>
                            </tr>
                            <tr class="tdbg">
                                <td style="width: 15%" align="right" class="tdbgleft">
                                    个人主页：
                                </td>
                                <td>
                                    <asp:Label ID="LblHomepage2" runat="server"></asp:Label>
                                </td>
                                <td class="tdbgleft" align="right">
                                    Email地址：
                                </td>
                                <td>
                                    <asp:Label ID="LblEmail" runat="server"></asp:Label>
                                </td>
                            </tr>
                            <tr class="tdbg">
                                <td style="width: 15%" align="right" class="tdbgleft">
                                    QQ号码：
                                </td>
                                <td>
                                    <asp:Label ID="LblQQ" runat="server"></asp:Label>
                                </td>
                                <td class="tdbgleft" align="right">
                                    MSN帐号：
                                </td>
                                <td>
                                    <asp:Label ID="LblMSN" runat="server"></asp:Label>
                                </td>
                            </tr>
                            <tr class="tdbg">
                                <td style="width: 15%" align="right" class="tdbgleft">
                                    ICQ号码：
                                </td>
                                <td>
                                    <asp:Label ID="LblICQ" runat="server"></asp:Label>
                                </td>
                                <td style="width: 15%" align="right" class="tdbgleft">
                                    雅虎通帐号：
                                </td>
                                <td>
                                    <asp:Label ID="LblYahoo" runat="server"></asp:Label>
                                </td>
                            </tr>
                            <tr class="tdbg">
                                <td style="width: 15%" align="right" class="tdbgleft">
                                    UC帐号：
                                </td>
                                <td>
                                    <asp:Label ID="LblUC" runat="server"></asp:Label>
                                </td>
                                <td style="width: 15%" align="right" class="tdbgleft">
                                    Aim帐号：
                                </td>
                                <td>
                                    <asp:Label ID="LblAim" runat="server"></asp:Label>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    <table id="Tabs2" cellpadding="2" cellspacing="1" style="width: 95%; background-color: white;
                        display: none">
                        <tr class="tdbg">
                            <td style="width: 15%" align="right" class="tdbgleft">
                                开户银行：
                            </td>
                            <td style="width: 38%">
                                <asp:Label ID="LblBankOfDeposit" runat="server"></asp:Label>
                            </td>
                            <td style="width: 15%" align="right" class="tdbgleft">
                                银行帐号：
                            </td>
                            <td style="width: 38%">
                                <asp:Label ID="LblBankAccount" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right">
                                税号：
                            </td>
                            <td>
                                <asp:Label ID="LblTaxNum" runat="server"></asp:Label>
                            </td>
                            <td class="tdbgleft" align="right">
                                网址：
                            </td>
                            <td>
                                <asp:Label ID="LblHomepage1" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right">
                                行业地位：
                            </td>
                            <td>
                                <asp:Label ID="LblStatusInField" runat="server"></asp:Label>
                            </td>
                            <td class="tdbgleft" align="right">
                                公司规模：
                            </td>
                            <td>
                                <asp:Label ID="LblCompanySize" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right">
                                业务范围：
                            </td>
                            <td>
                                <asp:Label ID="LblBusinessScope" runat="server"></asp:Label>
                            </td>
                            <td class="tdbgleft" align="right">
                                年销售额：
                            </td>
                            <td>
                                <asp:Label ID="LblAnnualSales" runat="server"></asp:Label>
                                万元
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right">
                                经营状态：
                            </td>
                            <td>
                                <asp:Label ID="LblManagementForms" runat="server"></asp:Label>
                            </td>
                            <td class="tdbgleft" align="right">
                                注册资本：
                            </td>
                            <td>
                                <asp:Label ID="LblRegisteredCapital" runat="server"></asp:Label>
                                万元
                            </td>
                        </tr>
                    </table>
                    <table id="Tabs3" cellpadding="2" cellspacing="1" style="width: 95%; background-color: white;
                        display: none">
                        <tr class="tdbg">
                            <td style="width: 15%" align="right" class="tdbgleft">
                                单位名称：
                            </td>
                            <td style="width: 38%">
                                <asp:Label ID="LblCompany" runat="server"></asp:Label>
                            </td>
                            <td style="width: 15%" align="right" class="tdbgleft">
                                所属部门：
                            </td>
                            <td style="width: 38%">
                                <asp:Label ID="LblDepartment" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right">
                                职位：
                            </td>
                            <td>
                                <asp:Label ID="LblPosition" runat="server"></asp:Label>
                            </td>
                            <td class="tdbgleft" align="right">
                                负责业务：
                            </td>
                            <td>
                                <asp:Label ID="LblOperation" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right">
                                称谓：
                            </td>
                            <td>
                                <asp:Label ID="LblTitle" runat="server"></asp:Label>
                            </td>
                            <td class="tdbgleft" align="right">
                                单位地址：
                            </td>
                            <td>
                                <asp:Label ID="LblCompanyAddress" runat="server"></asp:Label>
                            </td>
                        </tr>
                    </table>
                    <table id="Tabs4" cellpadding="2" cellspacing="1" style="width: 95%; background-color: white;
                        display: none">
                        <tr class="tdbg">
                            <td style="width: 15%" align="right" class="tdbgleft">
                                出生日期：
                            </td>
                            <td style="width: 38%">
                                <asp:Label ID="LblBirthday" runat="server"></asp:Label>
                            </td>
                            <td style="width: 15%" align="right" class="tdbgleft">
                                证件号码：
                            </td>
                            <td style="width: 38%">
                                <asp:Label ID="LblIDCard" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right">
                                籍贯：
                            </td>
                            <td>
                                <asp:Label ID="LblNativePlace" runat="server"></asp:Label>
                            </td>
                            <td class="tdbgleft" align="right">
                                民族：
                            </td>
                            <td>
                                <asp:Label ID="LblNation" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right">
                                性别：
                            </td>
                            <td>
                                <asp:Label ID="LblSex" runat="server"></asp:Label>
                            </td>
                            <td class="tdbgleft" align="right">
                                婚姻状况：
                            </td>
                            <td>
                                <asp:Label ID="LblMarriage" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right">
                                学历：
                            </td>
                            <td>
                                <asp:Label ID="LblEducation" runat="server"></asp:Label>
                            </td>
                            <td class="tdbgleft" align="right">
                                毕业学校：
                            </td>
                            <td>
                                <asp:Label ID="LblGraduateFrom" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right">
                                生活爱好：
                            </td>
                            <td>
                                <asp:Label ID="LblInterestsOfLife" runat="server"></asp:Label>
                            </td>
                            <td class="tdbgleft" align="right">
                                文化爱好：
                            </td>
                            <td>
                                <asp:Label ID="LblInterestsOfCulture" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right">
                                娱乐休闲爱好：
                            </td>
                            <td>
                                <asp:Label ID="LblInterestsOfAmusement" runat="server"></asp:Label>
                            </td>
                            <td class="tdbgleft" align="right">
                                体育爱好：
                            </td>
                            <td>
                                <asp:Label ID="LblInterestsOfSport" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right">
                                其他爱好：
                            </td>
                            <td>
                                <asp:Label ID="LblInterestsOfOther" runat="server"></asp:Label>
                            </td>
                            <td class="tdbgleft" align="right">
                                月 收 入：
                            </td>
                            <td>
                                <asp:Label ID="LblIncome" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right">
                                家庭情况：
                            </td>
                            <td colspan="3">
                                <asp:Label ID="LblFamily" runat="server"></asp:Label>
                            </td>
                        </tr>
                    </table>
                    <table id="Tabs6" cellpadding="2" cellspacing="1" style="width: 100%; background-color: white;
                        display: none">
                        <tr>
                            <td>
                                <asp:Repeater ID="RptUser" runat="server" OnItemDataBound="RptUser_ItemDataBound">
                                    <ItemTemplate>
                                        <tr id='Tab' runat="server" class='tdbg'>
                                            <td class='tdbgleft' align='right' style="width: 12%;">
                                                <%# Eval("FieldAlias")%>：
                                            </td>
                                            <td class='tdbg' align='left'>
                                                <asp:Literal ID="litUserText" runat="server"></asp:Literal>
                                            </td>
                                        </tr>
                                    </ItemTemplate>
                                </asp:Repeater>
                            </td>
                        </tr>
                    </table>
                    <table id="Tabs7" cellpadding="2" cellspacing="1" style="width: 100%; background-color: white;
                        display: none">
                        <tr>
                            <td>
                                <asp:Repeater ID="RptCompany" runat="server" OnItemDataBound="RptCompany_ItemDataBound">
                                    <ItemTemplate>
                                        <tr id='Tab' runat="server" class='tdbg'>
                                            <td class='tdbgleft' align='right' style="width: 12%;">
                                                <%# Eval("FieldAlias")%>：
                                            </td>
                                            <td class='tdbg' align='left'>
                                                <asp:Literal ID="litCompanyText" runat="server"></asp:Literal>
                                            </td>
                                        </tr>
                                    </ItemTemplate>
                                </asp:Repeater>
                            </td>
                        </tr>
                    </table>
                </asp:PlaceHolder>
            </td>
        </tr>
    </table>
    <br />
    <table style="height: 60; width: 100%">
        <tr align="center">
            <td>
                <asp:HiddenField ID="HdnClientType" runat="server" />
                <asp:HiddenField ID="HdnClientId" runat="server" />
                <pe:ExtendedButton OnClick="BtnModify_Click" Text="修改客户信息" runat="server" ID="BtnModify" UseSubmitBehavior="False" />
                <pe:ExtendedButton IsChecked="true" OperateCode="ContacterAdd" UseSubmitBehavior="false"
                    runat="server" Text="添加联系人" ID="BtnAddContacter" />
                <pe:ExtendedButton IsChecked="true" OperateCode="ClientAnnalAdd" UseSubmitBehavior="false"
                    runat="server" Text="添加联系记录 " ID="BtnAddClientAnnal" />
                <pe:ExtendedButton IsChecked="true" OperateCode="ServiceAdd" UseSubmitBehavior="false"
                    runat="server" Text="添加服务记录" ID="BtnAddService" />
                <pe:ExtendedButton ID="BtnAddRemindItem" Text="添加预约提醒" runat="server" IsChecked="true"
                    OperateCode="RemindItemAdd" UseSubmitBehavior="false" />
                <pe:ExtendedButton IsChecked="true" OperateCode="ComplainAdd" runat="server" UseSubmitBehavior="false"
                    Text="添加投诉记录" ID="BtnAddComplain" />
                <pe:ExtendedButton IsChecked="true" OperateCode="ClientMoneyManage" runat="server"
                    Text="添加银行汇款" ID="BtnAddRemit" />
                <pe:ExtendedButton IsChecked="true" OperateCode="ClientMoneyManage" runat="server"
                    UseSubmitBehavior="false" Text="添加支出信息" ID="BtnAddPayment" />
                <pe:ExtendedButton IsChecked="true" OperateCode="ClientMoneyManage" runat="server"
                    UseSubmitBehavior="false" Text="添加其他收入" ID="BtnAddIncome" />
                <asp:UpdatePanel ID="UpdatePanel1" runat="server" RenderMode="Inline">
                    <ContentTemplate>
                        <asp:DropDownList ID="DropOrderAdd" runat="server" AutoPostBack="True" 
                            onselectedindexchanged="DropOrderAdd_SelectedIndexChanged" Visible="False">
                        </asp:DropDownList>
                        <pe:ExtendedButton IsChecked="true" OperateCode="OrderAdd" runat="server" UseSubmitBehavior="false"
                    Text="  添加订单  " ID="BtnOrderAdd" OnClick="BtnOrderAdd_Click" />
                    </ContentTemplate>
                </asp:UpdatePanel>
                <asp:UpdatePanel ID="UpdatePanel2" runat="server" RenderMode="Inline">
                    <ContentTemplate>
                        <asp:DropDownList ID="DropCreditProductOrder" runat="server" 
                            AutoPostBack="True" 
                            onselectedindexchanged="DropCreditProductOrder_SelectedIndexChanged" 
                            Visible="False">
                        </asp:DropDownList>
                   <pe:ExtendedButton IsChecked="true" OperateCode="CreditProductOrderAdd" runat="server" UseSubmitBehavior="false"
                    Text="添加积分订单" ID="BtnCreditProductOrderAdd" OnClick="BtnCreditProductOrderAdd_Click" />
                    </ContentTemplate>
                </asp:UpdatePanel>
                <pe:ExtendedButton ID="BtnDelClient"
                    runat="server" Text="删除此客户" OnClick="BtnDelClient_Click" OnClientClick="return confirm('确定要删除此客户吗？')"  />
                <pe:ExtendedButton IsChecked="true" OperateCode="ClientSetPublic" Visible="false"
                    ID="BtnReleaseMyClient" runat="server" Text="释放此客户" OnClick="BtnReleaseMyClient_Click"
                    OnClientClick="return confirm('确定要设为公共客户吗？')" />
            </td>
        </tr>
    </table>
    <br />
    <table width="100%" border="0" cellpadding="0" cellspacing="0" runat="server">
        <tr align="center" runat="server">
            <td id="InfoTabTitle0" class="tabtitle" runat="server">
                联系人
            </td>
            <td id="InfoTabTitle1" class="tabtitle" runat="server">
                会员列表
            </td>
            <td id="InfoTabTitle2" class="tabtitle" runat="server">
                相关订单
            </td>
            <td id="InfoTabTitle3" class="tabtitle" runat="server">
                资金明细
            </td>
            <td id="InfoTabTitle4" class="tabtitle" runat="server">
                发票明细
            </td>
            <td id="InfoTabTitle5" class="tabtitle" runat="server">
                服务记录
            </td>
            <td id="InfoTabTitle6" class="tabtitle" runat="server">
                投诉记录
            </td>
            <td id="InfoTabTitle7" class="tabtitle" runat="server">
                联系记录
            </td>
            <td id="InfoTabTitle8" class="tabtitle" runat="server">
                预约联系纪录
            </td>
            <td id="InfoTabTitle9" class="tabtitle" runat="server">
                客户历史记录
            </td>
            <td id="InfoNull" runat="server">
                &nbsp;
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="EgvContacter" Visible="False" ItemName="联系人" ItemUnit="个"
        AutoGenerateColumns="False" DataKeyNames="ContacterId" AllowPaging="True" runat="server"
        CheckBoxFieldHeaderWidth="3%" IsHoldState="True" SerialText="">
        <Columns>
            <asp:HyperLinkField DataNavigateUrlFields="ContacterId" DataNavigateUrlFormatString="ContacterShow.aspx?ContacterId={0}"
                DataTextField="TrueName" HeaderText="姓名">
                <HeaderStyle Width="25%" />
            </asp:HyperLinkField>
            <asp:TemplateField HeaderText="类型" SortExpression="Disabled">
                <ItemTemplate>
                   <%# (int)Eval("UserType") == 1 ? "主联系人" : (int)Eval("UserType")==0?"个人客户联系人": "其它联系人"%>
                </ItemTemplate>
                <HeaderStyle Width="10%" />
            </asp:TemplateField>
            <asp:BoundField DataField="OfficePhone" HeaderText="工作电话" SortExpression="OfficePhone">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField DataField="Mobile" HeaderText="手机" SortExpression="Mobile">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField DataField="QQ" HeaderText="QQ号码" SortExpression="Title">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField DataField="Email" HeaderText="Email地址" SortExpression="Email">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField DataField="Address" HeaderText="联系地址" SortExpression="Address">
                <HeaderStyle Width="25%" />
                <ItemStyle HorizontalAlign="Left" />
            </asp:BoundField>
        </Columns>
    </pe:ExtendedGridView>
    <pe:ExtendedGridView ID="EgvUser" Visible="false" ItemName="会员" ItemUnit="个" AutoGenerateColumns="False"
        OnRowDataBound="EgvUser_RowDataBound" DataKeyNames="UserId" AllowPaging="True"
        runat="server">
        <Columns>
            <pe:TemplateField HeaderText="用户名" SortExpression="UserName">
                <ItemTemplate>
                    <a href='../User/UserShow.aspx?UserID=<%#DataBinder.Eval(Container.DataItem,"UserID").ToString()%>'>
                        <%#DataBinder.Eval(Container.DataItem,"UserName").ToString()%>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="所属会员组" SortExpression="GroupName">
                <ItemTemplate>
                    <%#Eval("GroupName") %>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="Balance" HeaderText="资金余额" DataFormatString="{0:N2}" SortExpression="Balance"
                HtmlEncode="false" />
            <pe:BoundField DataField="UserPoint" HeaderText="可用点券数" SortExpression="UserPoint" />
            <pe:TemplateField HeaderText="剩余天数" SortExpression="Status">
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" runat="server" ID="LblValidNum">
                    &nbsp;&nbsp;&nbsp;&nbsp;
                    </pe:ExtendedLabel>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="UserExp" HeaderText="可用积分" SortExpression="UserExp" />
            <pe:BoundField DataField="LastLogOnIP" HeaderText="最后登录IP" SortExpression="LastLogOnIP" />
            <pe:BoundField DataField="LastLogOnTime" HeaderText="最后登录时间" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}"
                HtmlEncode="False" SortExpression="LastLogOnTime" />
            <pe:BoundField DataField="LogOnTimes" HeaderText="次数" SortExpression="LogOnTimes" />
            <pe:TemplateField HeaderText="状态" SortExpression="Status">
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" runat="server" ID="LblStatus">
                    &nbsp;&nbsp;&nbsp;&nbsp;
                    </pe:ExtendedLabel>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <pe:ExtendedGridView ID="EgvOrder" Visible="false" ItemName="订单" ItemUnit="个" AutoGenerateColumns="False"
        DataKeyNames="OrderId" AllowPaging="True" runat="server" OnRowDataBound="EgvOrder_RowDataBound">
        <Columns>
            <pe:TemplateField HeaderText="订单编号" SortExpression="OrderNum">
                <ItemTemplate>
                    <a href='../Shop/OrderManage.aspx?OrderID=<%#Eval("OrderId")%>'>
                        <%#Eval("OrderNum")%>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="ClientName" HeaderText="客户名称" SortExpression="ClientName">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:BoundField DataField="UserName" HeaderText="用户名" SortExpression="UserName">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="下单时间" SortExpression="InputTime">
                <HeaderStyle Width="14%" />
                <ItemTemplate>
                    <%# Eval("InputTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="订单金额" SortExpression="MoneyTotal">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <%# Eval("MoneyTotal", "{0:N2}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="收款金额" SortExpression="MoneyReceipt">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <%# Eval("MoneyReceipt", "{0:N2}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="需要发票" SortExpression="NeedInvoice">
                <HeaderStyle Width="5%" />
                <ItemTemplate>
                    <%# (bool)Eval("NeedInvoice") == false ? "<font color=red>×</font>" : "√"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="已开发票">
                <HeaderStyle Width="5%" />
                <ItemTemplate>
                    <%# (bool)Eval("Invoiced") == false ? "<font color=red>×</font>" : "√"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="订单状态">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblOrderStatus" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="付款状态">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblPayStatus" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="物流状态">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblDeliverStatus" runat="server" ForeColor="AliceBlue" />
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <pe:ExtendedGridView ID="EgvBankrollItem" Visible="false" ItemName="记录" ItemUnit="条"
        OnDataBound="EgvBankrollItem_DataBound" OnRowDataBound="EgvBankrollItem_RowDataBound"
        AutoGenerateColumns="False" ShowFooter="True" DataKeyNames="ItemId" AllowPaging="True"
        runat="server">
        <Columns>
            <pe:BoundField DataField="DateAndTime" HeaderText="交易时间" SortExpression="DateAndTime"
                DataFormatString="{0:yyyy-MM-dd}" HtmlEncode="false">
                <HeaderStyle Width="15%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="用户名" SortExpression="UserName">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <a href='../User/UserShow.aspx?UserName=<%# Server.UrlEncode(Convert.ToString(Eval("UserName"))) %>'>
                        <%# Eval("UserName") %>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="交易方式" SortExpression="MoneyType">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%#GetMoneyType(Eval("MoneyType")) %>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="币种" SortExpression="CurrencyType">
                <HeaderStyle Width="5%" />
                <ItemTemplate>
                    <%#GetCurrencyType(Eval("CurrencyType")) %>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="收入金额">
                <ItemStyle HorizontalAlign="Right" />
                <HeaderStyle Width="12%" />
                <ItemTemplate>
                    <%#  Convert.ToDecimal(Eval("Money")) > 0 ? Eval("Money", "{0:N2}") : ""%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="支出金额">
                <ItemStyle HorizontalAlign="Right" />
                <HeaderStyle Width="12%" />
                <ItemTemplate>
                    <%#  Convert.ToDecimal(Eval("Money")) < 0 ? Math.Abs(Convert.ToDecimal(Eval("Money"))).ToString("N2") : ""%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="摘要" SortExpression="Income_PayOut">
                <HeaderStyle Width="5%" />
                <ItemTemplate>
                    <%# (decimal)Eval("Money") >0 ? "收入":"支出"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="银行名称">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%# (int)Eval("MoneyType") == 3 ? GetPayPlatformById((int)Eval("EBankId")).PayPlatformName : (Eval("Bank")== null ? "" : Eval("Bank").ToString())%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="Remark" HeaderText="备注/说明" ItemStyle-HorizontalAlign="left"
                SortExpression="Remark" />
        </Columns>
    </pe:ExtendedGridView>
    <pe:ExtendedGridView ID="EgvInvoice" Visible="false" ItemName="记录" ItemUnit="条" AutoGenerateColumns="False"
        AllowPaging="True" runat="server">
        <Columns>
            <pe:BoundField DataField="InvoiceDate" HeaderStyle-Width="10%" HeaderText="日期" DataFormatString="{0:yyyy-MM-dd}"
                SortExpression="InvoiceDate" HtmlEncode="false" />
            <pe:TemplateField HeaderText="订单编号" SortExpression="OrderNum">
                <HeaderStyle Width="12%" />
                <ItemTemplate>
                    <a href='../Shop/OrderManage.aspx?OrderID=<%# Eval("OrderId") %>'>
                        <%# Eval("OrderNum") %>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="发票类型" HeaderStyle-Width="15%" SortExpression="InvoiceType">
                <ItemTemplate>
                    <%#GetInvoiceType(Convert.ToInt32(Eval("InvoiceType")))%>
                </ItemTemplate>
                <HeaderStyle Width="10%" />
            </pe:TemplateField>
            <asp:HyperLinkField HeaderStyle-Width="10%" DataNavigateUrlFormatString="../Shop/InvoiceItemDetail.aspx?InvoiceID={0}"
                DataNavigateUrlFields="InvoiceId" DataTextField="InvoiceNum" HeaderText="发票号码" />
            <asp:HyperLinkField DataNavigateUrlFormatString="../Shop/InvoiceItemDetail.aspx?InvoiceID={0}"
                DataNavigateUrlFields="InvoiceId" DataTextField="InvoiceTitle" HeaderText="发票抬头" />
            <pe:BoundField HeaderStyle-Width="10%" DataField="TotalMoney" HeaderText="发票金额" DataFormatString="{0:0.00}"
                SortExpression="TotalMoney" HtmlEncode="False" />
            <pe:BoundField HeaderStyle-Width="8%" DataField="Drawer" HeaderText="开票人" SortExpression="Drawer" />
        </Columns>
    </pe:ExtendedGridView>
    <pe:ExtendedGridView ID="EgvService" Visible="false" ItemName="记录" ItemUnit="条" AutoGenerateColumns="False"
        AllowPaging="True" runat="server">
        <Columns>
            <pe:BoundField DataField="ServiceTime" HeaderText="服务时间" SortExpression="ServiceTime"
                DataFormatString="{0:yyyy-MM-dd}" HtmlEncode="false">
                <HeaderStyle Width="15%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="主题">
                <ItemTemplate>
                    <asp:HyperLink ID="HyperLink1" runat="server" NavigateUrl='<%#"ServiceShow.aspx?ItemId=" + Eval("ItemId") %>'
                        Text='<%#Eval("ServiceTitle") %>'></asp:HyperLink>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="服务类型" SortExpression="ItemID">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%#GetServiceType(Convert.ToInt32(Eval("ServiceType")))%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="服务方式" SortExpression="ServiceMode">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%#GetServiceMode(Convert.ToInt32(Eval("ServiceMode")))%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="Processor" HeaderText="服务人员" SortExpression="Processor">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="服务结果" SortExpression="ServiceResult">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%#GetResult(Convert.ToInt32(Eval("ServiceResult")))%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="服务积分" SortExpression="ServicePoint">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%#Eval("ServicePoint")%>分
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="回访确认">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%#Eval("ConfirmTime") == null ? "" : "<strong>√</strong>"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="客户评价" SortExpression="ServiceResult">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%#Convert.ToString(Eval("ConfirmTime")) == "" ? "" : GetConfirmScore(Convert.ToInt32(Eval("ConfirmScore")))%>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <pe:ExtendedGridView ID="EgvComplain" Visible="false" ItemName="记录" ItemUnit="条"
        AutoGenerateColumns="False" AllowPaging="True" runat="server">
        <Columns>
            <pe:BoundField DataField="DateAndTime" HeaderText="投诉时间" SortExpression="DateAndTime"
                DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                <HeaderStyle Width="15%" />
            </pe:BoundField>
            <pe:TemplateField HeaderStyle-Width="10%" HeaderText="投诉类型">
                <ItemTemplate>
                    <%#GetComplainType(Convert.ToInt32(Eval("ComplainType")))%>
                </ItemTemplate>
            </pe:TemplateField>
            <asp:HyperLinkField DataNavigateUrlFields="ItemId" DataNavigateUrlFormatString="ComplainShow.aspx?ItemId={0}"
                DataTextField="Title" HeaderText="主题" />
            <pe:TemplateField HeaderStyle-Width="10%" HeaderText="紧急程度">
                <ItemTemplate>
                    <%#GetMagnitudeOfExigence(Convert.ToInt32(Eval("MagnitudeOfExigence")))%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderStyle-Width="10%" HeaderText="记录状态">
                <ItemTemplate>
                    <%#GetStatus(Convert.ToInt32(Eval("Status")))%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="Processor" HeaderText="处理人" SortExpression="Status">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:BoundField DataField="EndTime" HeaderText="处理时间" SortExpression="Status" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}"
                HtmlEncode="False">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:BoundField DataField="Result" HeaderText="处理结果" SortExpression="Status">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
        </Columns>
    </pe:ExtendedGridView>
    <pe:ExtendedGridView ID="EgvClientAnnal" runat="server" AutoGenerateColumns="False"
        Visible="False" CheckBoxFieldHeaderWidth="3%" IsHoldState="True" SerialText=""
        AllowPaging="True" OnRowDataBound="EgvClientAnnal_RowDataBound" DataSourceID="odsClientAnnal"
        DataKeyNames="ClientAnnalID">
        <Columns>
            <asp:BoundField DataField="RelationTime" HeaderText="联系时间" DataFormatString="{0:yyyy-MM-dd}" />
            <pe:TemplateField HeaderText="联系人" SortExpression="ShortedForm">
                <ItemTemplate>
                    <pe:ExtendedAnchor ID="Contacter" IsChecked="true" runat="server" OperateCode="ContacterView"
                        href='<%#string.Format("ContacterShow.aspx?ContacterId={0}",Eval("Contacter")) %>'  Visible="False">
                    </pe:ExtendedAnchor>
                    <asp:Label runat="server" ID="LblContacter" Visible="False"></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
            <asp:BoundField DataField="RelationType" HeaderText="联系方式" />
            <asp:BoundField DataField="AnnalContent" HeaderText="记录内容" SortExpression="AnnalContent" />
            <asp:BoundField DataField="Inputer" HeaderText="记录人" SortExpression="Inputer" />
            <asp:BoundField DataField="ClientAnnalId" HeaderText="ClientAnnalId" InsertVisible="False"
                ReadOnly="True" SortExpression="ClientAnnalID" Visible="False" />
            <asp:TemplateField HeaderText="常规操作">
                <ItemTemplate>
                    <pe:ExtendedAnchor ID="ClientAnnalViewAnchor" runat="server" href='<%# Eval("ClientAnnalID","ClientAnnalShow.aspx?ClientAnnalID={0}")%>'
                        IsChecked="true" OperateCode="ClientAnnalView" style='<%#ShowOptionButton()%>'>
                        查看</pe:ExtendedAnchor>
                    <pe:ExtendedAnchor ID="ClientAnnalUpdate" runat="server" href='<%# Eval("ClientAnnalID","ClientAnnal.aspx?Action=Modify&id={0}")%>'
                        IsChecked="true" OperateCode="ClientAnnalUpdateAll" style='<%#ShowOptionButton()%>'>
                        修改</pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton ID="ClientAnnalDelete" runat="server" OnClick="LBtnDelete_Click"
                        CommandArgument='<%# Eval("ClientAnnalID") %>' OnClientClick="return confirm('确定要删除此记录吗？')"
                        IsChecked="true" OperateCode="ClientAnnalDelete" style='<%#ShowOptionButton()%>'>删除</pe:ExtendedLinkButton>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField runat="server" ID="HdnHasPurview" />
    <asp:ObjectDataSource ID="odsClientAnnal" runat="server" SelectCountMethod="GetTotal"
        EnablePaging='True' SelectMethod="GetInfoList" TypeName="PowerEasy.Module.Crm.BusinessLogic.ClientAnnal">
        <SelectParameters>
            <asp:Parameter Name="startRowIndex" Type="Int32" />
            <asp:Parameter Name="maximumRows" Type="Int32" />
            <asp:Parameter DefaultValue="4" Name="searchType" Type="Int32" />
            <asp:QueryStringParameter DefaultValue="-1" Name="keyword" QueryStringField="clientID"
                Type="String" />
            <asp:QueryStringParameter Name="field" QueryStringField="field" Type="String" />
            <asp:Parameter DefaultValue="0" Name="listType" Type="Int32" />
            <asp:Parameter DefaultValue="1" Name="purview" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="OdsInfo" runat="server" EnablePaging="True"></asp:ObjectDataSource>
    <pe:ExtendedGridView ID="EgvRemind" runat="server" AutoGenerateColumns="False" Visible="False"
        CheckBoxFieldHeaderWidth="3%" IsHoldState="True" SerialText="" AllowPaging="True"
        OnRowDataBound="EgvService_RowDataBound" DataSourceID="odsRmind" DataKeyNames="CorrelativeClient">
        <Columns>
            <asp:BoundField DataField="RemindTime" HeaderText="提醒时间" ItemStyle-Width="12%" />
            <pe:TemplateField HeaderText="联系人" SortExpression="ShortedForm">
                <ItemTemplate>
                    <pe:ExtendedAnchor ID="CorrelativeContacter" IsChecked="true" runat="server" OperateCode="ContacterView"
                        href='<%#string.Format("ContacterShow.aspx?ContacterId={0}",Eval("CorrelativeContacter")) %>'>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <asp:TemplateField HeaderText="提醒方式">
                <ItemTemplate>
                    <asp:Image ID="Image1" runat="server" ImageUrl="../../Admin/Images/mail.gif" />
                    <asp:Image ID="Image2" runat="server" ImageUrl="../../Admin/Images/mail_gray.gif" />
                    <asp:Image ID="Image5" runat="server" ImageUrl="../../Admin/Images/phone.gif" />
                    <asp:Image ID="Image6" runat="server" ImageUrl="../../Admin/Images/phone_gray.gif" />
                    <asp:Image ID="Image3" runat="server" ImageUrl="../../Admin/Images/pao.gif" />
                    <asp:Image ID="Image4" runat="server" ImageUrl="../../Admin/Images/pao_gray.gif" />
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="Creater" HeaderText="创建人" SortExpression="Inputer" />
            <asp:BoundField DataField="Status" HeaderText="处理情况" SortExpression="Inputer" />
            <asp:BoundField DataField="RemindId" HeaderText="RemindId" InsertVisible="False"
                ReadOnly="True" SortExpression="RemindId" Visible="False" />
            <asp:TemplateField HeaderText="常规操作">
                <EditItemTemplate>
                </EditItemTemplate>
                <ItemTemplate>
                    <a href='<%#string.Format("RemindItemShow.aspx?Remindid={0}",Eval("RemindId")) %>' style='<%#ShowOptionButton()%>'>查看</a>
                    <pe:ExtendedAnchor ID="RemindItemUpdate" OperateCode="RemindItemUpdateAll" runat="server"
                        href='<%#Eval("RemindId","RemindItem.aspx?Action=Modify&remindid={0}")%>' IsChecked="true" style='<%#ShowOptionButton()%>'>
                        修改</pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton ID="ExtendedLinkButton1" runat="server" OnClick="LBtnChangeStatus_Click"
                        OperateCode="RemindItemManage" CommandArgument='<%# Eval("RemindId") %>' IsChecked="true" style='<%#ShowOptionButton()%>'>标记为已处理</pe:ExtendedLinkButton>
                    <pe:ExtendedLinkButton ID="ReminditemDelete" runat="server" OnClick="LBtnDeleteRemind_Click"
                        OperateCode="RemindItemDelete" CommandArgument='<%# Eval("RemindId") %>' OnClientClick="return confirm('确定要删除此记录吗？')"
                        IsChecked="true" style='<%#ShowOptionButton()%>'>删除</pe:ExtendedLinkButton>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="odsRmind" runat="server" SelectCountMethod="GetTotal" EnablePaging='True'
        SelectMethod="GetInfoList" TypeName="PowerEasy.Module.Crm.BusinessLogic.RemindItem">
        <SelectParameters>
            <asp:Parameter Name="startRowIndex" Type="Int32" />
            <asp:Parameter Name="maximumRows" Type="Int32" />
            <asp:Parameter DefaultValue="6" Name="searchType" Type="Int32" />
            <asp:QueryStringParameter DefaultValue="-1" Name="keyword" QueryStringField="ClientID"
                Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <pe:ExtendedGridView ID="EgvClientHistory" runat="server" AutoGenerateColumns="False"
        CheckBoxFieldHeaderWidth="3%" IsHoldState="True" SerialText="" OnRowDataBound="EgvClientHistory_RowDataBound">
        <Columns>
            <asp:TemplateField SortExpression="ActionName" HeaderText="操作名称">
                <ItemTemplate>
                    <a class="expandEditHistory" clienthistoryid='<%#Eval("ClientHistoryID")%>' visible="false"
                        runat="server" id="ImgBtnExpand" />
                    <asp:Label runat="server" ID="lblActionName" Text='<%# Eval("ActionName") %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="ActionTime" HeaderText="操作时间" SortExpression="ActionTime" />
            <asp:BoundField DataField="UserIP" HeaderText="操作员IP" SortExpression="UserIP" />
            <asp:BoundField DataField="UserName" HeaderText="操作人" SortExpression="UserName" />
            <asp:BoundField DataField="Remark" HeaderText="操作备注" SortExpression="Remark" ItemStyle-HorizontalAlign="Left" />
        </Columns>
    </pe:ExtendedGridView>
    <script type="text/javascript">
        function ShowModifyItem(arg, context) {
            <%=m_HistoryItemsCallServer %>        
            return false;
        }

        function ShowCloseModifyItem(context) {
            var $editHistoryContainer = jQuery(context).parent().parent().next('.editHistoryContainer');
            $editHistoryContainer.fadeOut('fast', function() { $editHistoryContainer.remove(); });
            return false;
        }

        //jQuery(".expandEditHistory").toggle(function() {
        //ShowModifyItem(jQuery(this).attr("clienthistoryid"), this);
        //    jQuery(this).css("background-position", "0 -15px");
        //}, function() { jQuery(this).css("background-position", "0 0"); ShowCloseModifyItem(this); });
        jQuery(".expandEditHistory").click(function () {
            if (jQuery(this).css("background-position") == undefined || jQuery(this).css("background-position").indexOf("-15px") < 0) {
                ShowModifyItem(jQuery(this).attr("clienthistoryid"), this); jQuery(this).css("background-position", "0 -15px");
        }
            else {
                jQuery(this).css("background-position", "0 0"); ShowCloseModifyItem(this);
        }
    });

        function ShowHistory_onSuccess(result, context) {
            var itemList = eval(result);
            var $editHistoryContainer = jQuery("<tr class='editHistoryContainer tdbg'><td colspan='2'></td><td /><td /><td /></tr>");
            result = '';
            if (itemList.length > 0) {
                var sb = new Sys.StringBuilder("<table class='border' cellspacing='1' cellpadding='0' style='margin: 0pt auto; width: 100%;'>");
                sb.append("<tr class='gridtitle' style='height:25px;'>");
                sb.append("<th scope='col'>");
                sb.append("字段名");
                sb.append("</th>");
                sb.append("<th scope='col'>");
                sb.append("旧值");
                sb.append("</th>");
                sb.append("<th scope='col'>");
                sb.append("新值");
                sb.append("</th>");
                sb.append("</tr>");

                for (var i in itemList) {
                    sb.append("<tr class='tdbg' align='center'>");
                    sb.append("<td align='center'>");
                    sb.append(itemList[i].FieldName);
                    sb.append("</td>");
                    sb.append("<td align='center'>");
                    sb.append(itemList[i].OldValue);
                    sb.append("</td>");
                    sb.append("<td align='center'>");
                    sb.append(itemList[i].NewValue);
                    sb.append("</td>");
                    sb.append("</tr>");
                }
                sb.append("</table>");
                result = sb.toString();
            }
            else {
                result = '无相关记录';
            }
            $editHistoryContainer.find('td').eq(0).append(result);
            jQuery($editHistoryContainer).insertAfter(jQuery(context).parent().parent()).show('fast');
        }
    </script></asp:Content>