﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.ComplainUI" Title="客户投诉记录添加/修改"
    EnableEventValidation="false" CodeBehind="Complain.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <table border="0" cellpadding="2" cellspacing="1" class="border" width="100%">
        <tr align="center">
            <td colspan="2" class="title">
                <strong>
                    <asp:Label ID="LblTitle" runat="server" Text="添加客户投诉记录"></asp:Label></strong>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                投诉时间：
            </td>
            <td>
                <asp:TextBox ID="TxtDateAndTime" runat="server" MaxLength="30" Width="204px"></asp:TextBox>
                <pe:RegexValidator ValidateType="Date" ID="DateValidator1" runat="server" ControlToValidate="TxtDateAndTime"
                    Display="Dynamic" ErrorMessage="投诉日期的格式不对" SetFocusOnError="True"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 15%; text-align: right; height: 28px;">
                投诉主题：
            </td>
            <td style="width: 85%; height: 28px;">
                <asp:TextBox ID="TxtTitle" runat="server" MaxLength="50" Width="276px"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrTitle" runat="server" ControlToValidate="TxtTitle"
                    Display="Dynamic" ErrorMessage="请输入投诉主题" SetFocusOnError="True"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                投诉客户：
            </td>
            <td>
                <asp:TextBox ID="txtSelectClient" Width="135" runat="server"></asp:TextBox>
                <pec:FloatingDialog ID="fSelectClient" runat="server" Name="选择投诉客户" Title="选择投诉客户"
                    Width="600" Height="500" BeginString="【" EndString="】" Skin="floatingDialogFontSkin" />
                <asp:HiddenField ID="hnSelectClient" runat="server" />
                <asp:RequiredFieldValidator ID="ValrClientId" runat="server" ControlToValidate="txtSelectClient"
                    Display="Dynamic" ErrorMessage="请选择投诉客户"></asp:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                客户方联系人：
            </td>
            <td>
                <span id="ContacterList">
                    <asp:DropDownList ID="DropContacterId" runat="server">
                    </asp:DropDownList>
                </span>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                投诉类型：
            </td>
            <td>
                <asp:DropDownList ID="DropComplainType" runat="server" Width="111px">
                </asp:DropDownList>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                投诉方式：
            </td>
            <td>
                <asp:DropDownList ID="DropComplainMode" runat="server">
                </asp:DropDownList>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                紧急程度：
            </td>
            <td>
                <asp:DropDownList ID="DropMagnitudeOfExigence" runat="server" Width="75px">
                </asp:DropDownList>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                被投诉对象：
            </td>
            <td>
                <asp:TextBox ID="txtSelectAgentName" Width="135" runat="server"></asp:TextBox>
                <pec:FloatingDialog ID="floatSelectAgentName" runat="server" Name="选择投诉客户" Title="选择投诉客户"
                    Width="600" Height="500" BeginString="【" EndString="】" Skin="floatingDialogFontSkin" />
                <asp:HiddenField ID="HnSelectAgentName" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                投诉内容：
            </td>
            <td>
                <asp:TextBox ID="TxtContent" runat="server" Height="80px" TextMode="MultiLine" Width="335px"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                接待人：
            </td>
            <td>
                <asp:TextBox ID="txtSelectFirstReceiver" Width="135" runat="server"></asp:TextBox>
                <pec:FloatingDialog ID="floatSelectFirstReceiver" runat="server" Name="选择接待人" Title="选择接待人"
                    Width="600" Height="500" BeginString="【" EndString="】" Skin="floatingDialogFontSkin" />
                <pe:RequiredFieldValidator ID="ValrFirstReceiver" runat="server" ControlToValidate="txtSelectFirstReceiver"
                    Display="Dynamic" ErrorMessage="请输入接待人" SetFocusOnError="True"></pe:RequiredFieldValidator>
                <asp:HiddenField ID="HnSelectFirstReceiver" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                转交给谁处理：
            </td>
            <td>
                <asp:TextBox ID="txtSelectAdminName" Width="135" runat="server"></asp:TextBox>
                <pec:FloatingDialog ID="floatSelectAdminName" runat="server" Name="选择交接人" Title="选择交接人"
                    Width="600" Height="500" BeginString="【" EndString="】" Skin="floatingDialogFontSkin" />
                <asp:HiddenField ID="HnSelectAdminName" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                备注：
            </td>
            <td>
                <asp:TextBox ID="TxtRemark" runat="server" Height="60px" TextMode="MultiLine" Width="335px"></asp:TextBox>
            </td>
        </tr>
        <tr align="center">
            <td class="tdbg" colspan="2" style="height: 40px">
                <asp:Button ID="BtnSave" runat="server" Text="保存投诉记录" OnClick="BtnSave_Click" />
                <asp:Button ID="BtnReturn" runat="server" Text="取消" CausesValidation="false" OnClick="BtnReturn_Click" />
            </td>
        </tr>
    </table>
    <asp:HiddenField ID="HdnAction" runat="server" />
    <script type="text/javascript">
        function ShowContacter() {
            var value = document.getElementById("<%=hnSelectClient.ClientID %>").value
            GetContacterList(value);
        }
        function BindContacterList(result, context) {
            document.getElementById('ContacterList').innerHTML = result;
        }
        function SelectAdmin(arr) {
            if (arr != null) {
                var txtFunctionary = document.getElementById('<%=txtSelectFirstReceiver.ClientID %>');
                var hdnFunctionary = document.getElementById('<%=HnSelectFirstReceiver.ClientID %>');
                var ss = arr.split('$$$');
                txtFunctionary.value = ss[0];
                hdnFunctionary.value = ss[0];
            }
        }
        function selectadmin2(arr) {
            if (arr != null) {
                var txtFunctionary = document.getElementById('<%=txtSelectAdminName.ClientID %>');
                var hdnFunctionary = document.getElementById('<%=HnSelectAdminName.ClientID %>');
                var ss = arr.split('$$$');
                txtFunctionary.value = ss[0];
                hdnFunctionary.value = ss[0];
            }
        }
    </script>
</asp:Content>
