﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.ComplainManage" Title="投诉管理" Codebehind="ComplainManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
<table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
  <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitAll" />>
                        <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="0" onclick="ShowBookmarks"><span>所有状态</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitUnDo" />>    
                       <asp:LinkButton ID="LinkUnDo" runat="server" CommandArgument="4" onclick="ShowBookmarks"><span>未处理</span></asp:LinkButton>
                    </li>
<%--                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitDoing" />>    
                       <asp:LinkButton ID="LinkDoing" runat="server" CommandArgument="5" onclick="ShowBookmarks"><span>处理中</span></asp:LinkButton>
--%>                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitDo" />>    
                       <asp:LinkButton ID="LinkDo" runat="server" CommandArgument="6" onclick="ShowBookmarks"><span>已处理</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitBack" />>    
                       <asp:LinkButton ID="LinkBack" runat="server" CommandArgument="7" onclick="ShowBookmarks"><span>已回访</span></asp:LinkButton>
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="EgvComplain" runat="server" AllowPaging="True" AutoGenerateColumns="False"
        DataSourceID="OdsComplain" SerialText="" OnRowDataBound="EgvComplain_RowDataBound"
        AutoGenerateCheckBoxColumn="True" DataKeyNames="ItemId" CheckBoxFieldHeaderWidth="3%">
        <Columns>
            <pe:BoundField DataField="DateAndTime" HeaderText="投诉时间" SortExpression="DateAndTime"
                DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                <HeaderStyle Width="16%" /> 
            </pe:BoundField>
            <pe:TemplateField HeaderText="客户名称">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" operateCode="ClientView" href='<%# Eval("ClientId", "ClientShow.aspx?ClientId={0}") %>'>
                        <%# Eval("ShortedForm") %>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="ComplainType" HeaderText="投诉类型" SortExpression="ComplainType">
                <HeaderStyle Width="12%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="主题">
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" operateCode="ComplainView" href='<%# Eval("ItemId", "ComplainShow.aspx?ItemId={0}") %>'>
                        <%# Eval("Title") %>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="MagnitudeOfExigence" HeaderText="紧急程度" SortExpression="MagnitudeOfExigence">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField DataField="Status" HeaderText="记录状态" SortExpression="Status">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="12%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" operateCode="ComplainView" href='<%# Eval("ItemId", "ComplainShow.aspx?ItemId={0}") %>'>查看</pe:ExtendedAnchor>
                    <pe:ExtendedAnchor ID="ModifyOwn" IsChecked="true" runat="server" operateCode="ComplainModifyAll"
                        href='<%#string.Format("Complain.aspx?Action=Modify&ItemId={0}",Eval("ItemID")) %>'>修改</pe:ExtendedAnchor>
                    <asp:LinkButton ID="LbtnDelete" runat="server" CommandName="Delete" OnClientClick="if(!this.disabled) return confirm('确实要删除此投诉记录吗？')">删除</asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <br />
    &nbsp;&nbsp;
    <pe:ExtendedButton IsChecked="true" OperateCode="ComplainDelete" ID="BtnDelete" runat="server"
        OnClientClick="return batchconfirm('是否要删除选中的记录？')" Text="删除选中的投诉记录" OnClick="BtnDelete_Click" />
    <pe:OneClickButton ID="BtnExport" runat="server" OnClick="BtnExport_Click" Text="导出到Excel" IsOneClick="false" /><br />
    <asp:HiddenField ID="HdnType" Value="0" runat="server" />
    <asp:ObjectDataSource ID="OdsComplain" runat="server" EnablePaging="True" MaximumRowsParameterName="maxNumberRows"
        SelectCountMethod="GetTotal" SelectMethod="GetList" StartRowIndexParameterName="startRowIndexId"
        TypeName="PowerEasy.Module.Crm.BusinessLogic.Complain" DeleteMethod="Delete">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="field" QueryStringField="Field"
                Type="Int32" />
            <asp:QueryStringParameter DefaultValue="" Name="keyword" QueryStringField="Keyword"
                Type="String" />
             <asp:QueryStringParameter DefaultValue="0" Type="Int32" Name="searchType" QueryStringField="SearchType"/>
              <asp:ControlParameter ControlID="HdnType" Type="Int32" Name="type" PropertyName="Value" />
        </SelectParameters>
        <DeleteParameters>
            <asp:Parameter Name="itemId" Type="string" />
        </DeleteParameters>
    </asp:ObjectDataSource>
    <asp:HiddenField ID="HdnSearchType" runat="server" />
</asp:Content>
