﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true" ValidateRequest="false"
    Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.ContacterManage" Title="联系人管理" Codebehind="ContacterManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
<table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
  <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitAllContacter" />>
                        <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="0" onclick="ShowBookmarks"><span>所有</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitMainConteacter" />>    
                       <asp:LinkButton ID="LinkMain" runat="server" CommandArgument="3" onclick="ShowBookmarks"><span>主联系人</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitClientConteacter" />>    
                       <asp:LinkButton ID="LinkClient" runat="server" CommandArgument="5" onclick="ShowBookmarks"><span>个人客户联系人</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitOtherConteacter" />>    
                       <asp:LinkButton ID="LinkOther" runat="server" CommandArgument="4" onclick="ShowBookmarks"><span>其它联系人</span></asp:LinkButton>
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="EgvContacter" runat="server" AutoGenerateCheckBoxColumn="True"
        AutoGenerateColumns="False" OnRowCommand="EgvContacter_RowCommand" ItemName="联系人"
        OnRowDataBound="EgvContacter_RowDataBound" ItemUnit="个" DataKeyNames="ContacterId"
        AllowPaging="True" DataSourceID="OdsContacter" CheckBoxFieldHeaderWidth="3%" 
        IsHoldState="True" SerialText="">
        <Columns>
            <asp:BoundField DataField="ContacterId" HeaderText="ID" 
                SortExpression="ContacterId">
            <HeaderStyle Width="6%" />
            </asp:BoundField>
            <asp:HyperLinkField DataNavigateUrlFields="ContacterId" 
                DataNavigateUrlFormatString="ContacterShow.aspx?ContacterId={0}" 
                DataTextField="TrueName" HeaderText="姓名">
            <HeaderStyle Width="10%" />
            </asp:HyperLinkField>
            <asp:BoundField DataField="Title" HeaderText="称谓" SortExpression="Title">
            <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField DataField="OfficePhone" HeaderText="工作电话" 
                SortExpression="OfficePhone">
            <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField DataField="Mobile" HeaderText="手机" SortExpression="Mobile">
            <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField DataField="Email" HeaderText="Email地址" SortExpression="Email" />
            <asp:TemplateField HeaderText="类型" SortExpression="Disabled">
                <ItemTemplate>
                    <%# (int)Eval("UserType") == 1 ? "主联系人" : (int)Eval("UserType")==0?"个人客户联系人": "其它联系人"%>
                </ItemTemplate>
                <HeaderStyle Width="10%" />
            </asp:TemplateField>
            <asp:HyperLinkField DataNavigateUrlFields="ClientId" 
                DataNavigateUrlFormatString="ClientShow.aspx?ClientId={0}" 
                DataTextField="ShortedForm" HeaderText="对应客户">
            <HeaderStyle Width="10%" />
            </asp:HyperLinkField>
            <asp:TemplateField HeaderText="操作">
                <ItemTemplate>
                    <pe:ExtendedAnchor runat="server" 
                        href='<%# string.Format("ContacterShow.aspx?ContacterId={0}",Eval("ContacterId"))  %>' 
                        IsChecked="false" operateCode="None">                     
                        查看
                    </pe:ExtendedAnchor>
                    <pe:ExtendedAnchor ID="ModifyOwn" runat="server" 
                        href='<%# string.Format("Contacter.aspx?Action=Modify&ContacterId={0}",Eval("ContacterId")) %>' 
                        IsChecked="true" operateCode="ContacterModifyAll">
                        修改
                    </pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton ID="LbtnDelete" runat="server" CausesValidation="False" 
                        CommandArgument='<%# Eval("ContacterId") %>' CommandName="Del" IsChecked="true" 
                        OnClientClick="return confirm('将删除相应的联系记录，是否删除该联系人？')" 
                        OperateCode="ContacterDelete">删除</pe:ExtendedLinkButton>
                </ItemTemplate>
                <HeaderStyle Width="13%" />
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnType" Value="0" runat="server" />
    <asp:ObjectDataSource ID="OdsContacter" runat="server" SelectCountMethod="GetTotalOfContacter"
        SelectMethod="GetList" TypeName="PowerEasy.Module.General.BusinessLogic.UserManage.Contacter" EnablePaging="True"
        StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:QueryStringParameter Name="searchType" QueryStringField="SearchType" Type="String" />
            <asp:ControlParameter ControlID="HdnKeyword" Name="keyword" 
                PropertyName="Value" Type="String" />
            <asp:ControlParameter ControlID="HdnType" Type="Int32" Name="type" PropertyName="Value" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:HiddenField ID="HdnKeyword" runat="server" />
    <br />
    &nbsp;&nbsp;
    <pe:ExtendedButton IsChecked="true" OperateCode="ContacterDelete" ID="BtnDelete"
        runat="server" OnClientClick="return batchconfirm('将删除相应的联系记录，是否要删除选中的记录？')" Text="删除选中的联系人" OnClick="BtnDelete_Click" />
    <br />
</asp:Content>
