﻿<%@ WebHandler Language="C#" Class="PowerEasy.Module.Crm.WebSite.Admin.Crm.GetContacter" %>

namespace PowerEasy.Module.Crm.WebSite.Admin.Crm
{
    using System;
    using System.Text;
    using System.Web;
    using System.Collections;
    using System.Collections.Generic;

    using Module.Crm.Model;
    using PowerEasy.Module.General.BusinessLogic.UserManage;

    /// <summary>
    /// 
    /// </summary>
    public class GetContacter : IHttpHandler
    {
        /// <summary>
        /// 
        /// </summary>
        /// <param name="clientId"></param>
        /// <param name="cName"></param>
        /// <param name="cId"></param>
        /// <returns></returns>
        private string GetContacterHtml(int clientId, string cName, string cId)
        {
            Dictionary<int, string> contacterDictionary = Contacter.GetContacterListByClientId(clientId);

            StringBuilder sb = new StringBuilder();

            sb.Append("<select name='" + cName + "' id='" + cId + "'>");

            foreach (KeyValuePair<int, string> element in contacterDictionary)
            {
                sb.Append("<option value='" + element.Key.ToString() + "'>" + element.Value + "</option>");
            }
            sb.Append("</select>");

            return sb.ToString();

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="context"></param>
        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "text/plain";

            int clientId = Int32.Parse(context.Request.Params["ClientId"]);
            string cName = context.Request.Params["CName"];
            string cId = context.Request.Params["CId"];

            context.Response.Write(GetContacterHtml(clientId, cName, cId));
        }

        /// <summary>
        /// 
        /// </summary>
        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}