﻿<%@ Page Title="预约提醒添加/修改" Language="C#" MasterPageFile="~/Admin/MasterPage.master"
    EnableEventValidation="false" AutoEventWireup="true" CodeBehind="RemindItem.aspx.cs"
    Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.RemindItem" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>
                    <pe:AlternateLiteral ID="LblTitle" Text="添加预约提醒记录" AlternateText="修改预约提醒记录" runat="Server" /></b>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 184px">
                <strong>客户名称：</strong>
            </td>
            <td>
                <asp:TextBox ID="txtSelectClient" Width="135" runat="server"></asp:TextBox>
                <pec:FloatingDialog ID="fSelectClient" runat="server" Name="选择客户" Title="选择客户"
                    Width="600" Height="500" BeginString="【" EndString="】" Skin="floatingDialogFontSkin" />
                <asp:HiddenField ID="hnSelectClient" runat="server" />
                <asp:Label ID="LabClientID" runat="server" Visible="false"></asp:Label>
                <pe:RequiredFieldValidator ID="ValrClientName" runat="server" ErrorMessage="请输入对应客户"
                    Display="Dynamic" ControlToValidate="txtSelectClient"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 184px">
                <strong>客户方联系人：</strong>
            </td>
            <td>
                <span id="ContacterList">
                    <asp:DropDownList ID="DropContacterID" Width="80px" runat="server" DataTextField="DataTextField"
                        DataValueField="DataValueField">
                    </asp:DropDownList>
                </span>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 184px">
                <strong>预约联系方式：</strong>
            </td>
            <td>
                <asp:DropDownList ID="DropBookingType" Width="80px" runat="server" DataTextField="DataTextField"
                    DataValueField="DataValueField">
                </asp:DropDownList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 184px">
                <strong>主动提醒方式：</strong>
            </td>
            <td>
                <asp:CheckBox ID="RemindByEmail" Text="邮件提醒" runat="server" />
                <asp:CheckBox ID="RemindBySms" Text="手机短信提醒" runat="server" />
                <asp:CheckBox ID="RemindByTips" Checked="true" Text="冒泡提示提醒" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 184px">
                <strong>预约提醒时间：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtServiceTime" runat="server" Width="200px" MaxLength="30"></asp:TextBox>
                <pe:RegexValidator ValidateType="Date" ID="DateValidator1" runat="server" ControlToValidate="TxtServiceTime"
                    Display="Dynamic" ErrorMessage="时间格式不对"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 184px">
                <strong>提醒内容：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtRemindContent" runat="server" Width="200px" MaxLength="60"></asp:TextBox>
            </td>
        </tr>
    </table>
    <br />
    <center>
        <pe:ExtendedButton ID="EBtnSubmit" OnClick="EBtnSubmit_Click" OperateCode="RemindItemAdd"
            runat="server" Text="保存预约提醒记录" />
        <pe:ExtendedButton ID="EBtnCancel" runat="server" OnClick="EBtnCancel_Click" OperateCode="ClientView"
            Text="返回查看客户信息" ValidationGroup="BtnCancleValidationGroup" />
        <pe:ExtendedButton ID="EBtnReturnManage" runat="server" OperateCode="RemindItemManage"
            OnClick="EBtnReturnManage_Click" Text="返回预约提醒管理" ValidationGroup="BtnCancleValidationGroup" />
    </center>
    <script type="text/javascript">
        function ShowContacter() {
            var obj = document.getElementById("<%=hnSelectClient.ClientID %>");
            GetContacterList(obj.value);
        }
        function BindContacterList(result, context) {
            document.getElementById('ContacterList').innerHTML = result;
        }
    </script>
</asp:Content>
