﻿<%@ Page Title="预约提醒管理" Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true" CodeBehind="RemindItemManage.aspx.cs" Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.RemindItemManage" %>
<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
  <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitAll" />>
                        <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="0" onclick="ShowBookmarks"><span>全部</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitUnFinish" />>    
                       <asp:LinkButton ID="LinkUnFinish" runat="server" CommandArgument="4" onclick="ShowBookmarks"><span>未处理</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitFinish" />>    
                       <asp:LinkButton ID="LinkFinish" runat="server" CommandArgument="5" onclick="ShowBookmarks"><span>已处理</span></asp:LinkButton>
                    </li>
                </ul>
            </td>
        </tr>
    </table>
 <pe:ExtendedGridView ID="EgvRemind" runat="server" AutoGenerateColumns="False" 
        OnRowDataBound="EgvService_RowDataBound" DataKeyNames="RemindId"
        CheckBoxFieldHeaderWidth="3%" SerialText="" AllowPaging="True" 
        AutoGenerateCheckBoxColumn="True" DataSourceID="odsRmind" 
        IsHoldState="True">
        <Columns>
            <asp:BoundField DataField="RemindTime" HeaderText="提醒时间"/>
            <pe:TemplateField HeaderText="客户名称" SortExpression="ShortedForm">
                <ItemTemplate>
                    <pe:ExtendedAnchor ID="CorrelativeClient" IsChecked="true" runat="server" operateCode="ClientView" href='<%#string.Format("ClientShow.aspx?clientID={0}",Eval("CorrelativeClient")) %>'></pe:ExtendedAnchor>
                </ItemTemplate>
                </pe:TemplateField>
             <asp:TemplateField HeaderText="提醒方式">
                <ItemTemplate>
                    <asp:Image ID="Image1" runat="server" ImageUrl="../../Admin/Images/mail.gif"/>
                    <asp:Image ID="Image2" runat="server" ImageUrl="../../Admin/Images/mail_gray.gif"/>
                    <asp:Image ID="Image5" runat="server" ImageUrl="../../Admin/Images/phone.gif"/>
                    <asp:Image ID="Image6" runat="server" ImageUrl="../../Admin/Images/phone_gray.gif"/>
                    <asp:Image ID="Image3" runat="server" ImageUrl="../../Admin/Images/pao.gif"/>
                    <asp:Image ID="Image4" runat="server" ImageUrl="../../Admin/Images/pao_gray.gif"/>
                </ItemTemplate>     
            </asp:TemplateField>
             <asp:BoundField DataField="Creater" HeaderText="创建人" SortExpression="Inputer" />
            <asp:BoundField DataField="Status" HeaderText="处理情况" SortExpression="Inputer" />
            <asp:BoundField DataField="RemindId" HeaderText="RemindId" InsertVisible="False"
                ReadOnly="True" Visible="False" />
            <asp:BoundField DataField="RemindByEmail" HeaderText="发送邮件提醒"  Visible="False" SortExpression="AnnalTime"/>
            <asp:BoundField DataField="RemindByTips" HeaderText="冒泡主动提醒"  Visible="False" SortExpression="AnnalTime"/>
            <asp:BoundField DataField="RemindBySms" HeaderText="发送短信提醒"  Visible="False" SortExpression="Inputer" />
            <asp:TemplateField HeaderText="常规操作">
                <EditItemTemplate>
                </EditItemTemplate>
                <ItemTemplate>
                <a href='<%#string.Format("RemindItemShow.aspx?RemindId={0}",Eval("RemindId")) %>'>查看</a>
                    <pe:ExtendedLinkButton ID="UpdateStatus" runat="server" OnClick="LBtnChangeStatus_Click" OperateCode="RemindItemUpdateAll"
                    CommandArgument='<%# Eval("RemindId") %>' IsChecked="true">标记为已处理</pe:ExtendedLinkButton>
                    <pe:ExtendedAnchor ID="RemindItemUpdate" OperateCode="RemindItemUpdateAll" runat="server" href='<%#Eval("RemindId","RemindItem.aspx?Action=Modify&remindid={0}")%>'
                        IsChecked="true">
                        修改</pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton ID="ClientAnnalDelete" runat="server" OnClick="LBtnDelete_Click" OperateCode="RemindItemDelete"
                        CommandArgument='<%# Eval("RemindId") %>' OnClientClick="return confirm('确定要删除此记录吗？')"
                        IsChecked="true">删除</pe:ExtendedLinkButton>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="odsRmind" runat="server"  
        SelectCountMethod="GetTotal" EnablePaging='True'
        SelectMethod="GetInfoList" TypeName="PowerEasy.Module.Crm.BusinessLogic.RemindItem"
         >
        <SelectParameters>
            <asp:Parameter Name="startRowIndex" Type="Int32" />
            <asp:Parameter Name="maximumRows" Type="Int32" />
            <asp:QueryStringParameter DefaultValue="-1" Name="searchType" QueryStringField="searchType"
                Type="Int32" />
            <asp:QueryStringParameter DefaultValue="-1" Name="keyword" 
                QueryStringField="keyword" Type="String" />
            <asp:QueryStringParameter Name="FieldValue" 
                QueryStringField="FieldValue" Type="String" DefaultValue="0" />
                <asp:QueryStringParameter Name="Field"
                QueryStringField="Field" Type="String" DefaultValue="0" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <pe:ExtendedButton IsChecked="true"  ID="BtnDelete" runat="server" OperateCode="RemindItemDelete"
        OnClientClick="return batchconfirm('是否要删除选中的记录？')" Text="删除选中的预约提醒记录" OnClick="BtnDeleteList_Click" />
</asp:Content>
