﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Crm.WebSite.Admin.Crm.ServiceManage" Title="服务管理"
    CodeBehind="ServiceManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:Bookmarks ID="BookmarksService" ControlID="HdnType" ExtendedGridViewID="EgvService"
        runat="server">
        <pe:BookmarkItem Title="全部">0</pe:BookmarkItem>
        <pe:BookmarkItem Title="未完成" Value="4"/>
        <pe:BookmarkItem Title="已完成" Value="5"/>
    </pe:Bookmarks>
    <pe:ExtendedGridView ID="EgvService" runat="server" ItemUnit="个" AutoGenerateColumns="False"
        OnRowDataBound="EgvService_RowDataBound" DataKeyNames="ItemId" AllowPaging="True"
        DataSourceID="OdsService" CheckBoxFieldHeaderWidth="3%" SerialText="" AutoGenerateCheckBoxColumn="True">
        <Columns>
            <pe:BoundField DataField="ServiceTime" HeaderText="服务时间" SortExpression="ServiceTime"
                DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                <HeaderStyle Width="16%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="客户名称" SortExpression="ShortedForm">
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" OperateCode="ClientView" href='<%#string.Format("ClientShow.aspx?ClientID={0}",Eval("ClientId")) %>'>
                        <%#Eval("ClientName")%></pe:ExtendedAnchor>
                </ItemTemplate>
                <HeaderStyle Width="7%" />
            </pe:TemplateField>
            <pe:TemplateField HeaderText="主题" SortExpression="ServiceTitle">
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" OperateCode="ServiceView" href='<%#string.Format("ServiceShow.aspx?ItemId={0}",Eval("ItemId")) %>'>
                        <%# PowerEasy.Framework.Common.DataSecurity.HtmlEncode(Eval("ServiceTitle")) %>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField HeaderText="服务类型" SortExpression="ServiceType" DataField="ServiceType">
                <HeaderStyle Width="7%" />
            </pe:BoundField>
            <pe:BoundField HeaderText="服务方式" SortExpression="ServiceMode" DataField="ServiceMode">
                <HeaderStyle Width="7%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="服务人员">
                <HeaderStyle Width="7%" />
                <ItemTemplate>
                    <a href='../User/UserShow.aspx?UserName=<%#Eval("Processor") %>'>
                        <%#Eval("Processor")%></a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField HeaderText="服务结果" SortExpression="ServiceResult" DataField="ServiceResult">
                <HeaderStyle Width="7%" />
            </pe:BoundField>
            <pe:BoundField HeaderText="服务积分" SortExpression="ServerPoint" DataField="ServicePoint">
                <HeaderStyle Width="7%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="回访确认">
                <HeaderStyle Width="7%" />
                <ItemTemplate>
                    <%#Eval("ConfirmTime") == null ? "" : "<strong>√</strong>"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField HeaderText="客户评价" DataField="ConfirmScore">
                <HeaderStyle Width="7%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor ID="ExtendedAnchor1" IsChecked="true" runat="server" OperateCode="ComplainView"
                        href='<%# Eval("ItemId", "ServiceShow.aspx?ItemId={0}") %>'>
                        查看</pe:ExtendedAnchor>
                    <asp:HyperLink ID="LnkServiceCall" NavigateUrl='<%#string.Format("ClientConfirmAdd.aspx?clientName={0}",Eval("ClientName")) %>'
                        Enabled="false" runat="server">回访</asp:HyperLink>
                    <pe:ExtendedAnchor ID="ModifyOwn" IsChecked="true" runat="server" OperateCode="ServiceModifyAll"
                        href='<%#string.Format("Service.aspx?Action=Modify&ItemId={0}",Eval("ItemId")) %>'>
                        修改</pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="ServiceDelete" ID="LbtnDelete"
                        runat="server" CausesValidation="False" CommandName="Delete" OnClientClick="return confirm('是否删除该记录？')">删除</pe:ExtendedLinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <br />
    &nbsp;&nbsp;
    <pe:ExtendedButton IsChecked="true" OperateCode="ServiceDelete" ID="BtnDelete" runat="server"
        OnClientClick="return batchconfirm('是否要删除选中的记录？')" Text="删除选中的服务记录" OnClick="BtnDelete_Click" />&nbsp;
    <pe:OneClickButton ID="BtnExport" runat="server" OnClick="BtnExport_Click" Text="导出到Excel"
        IsOneClick="false" /><br />
    <asp:HiddenField ID="HdnType" runat="server" Value="0" />
    <asp:ObjectDataSource ID="OdsService" runat="server" SelectCountMethod="GetTotalOfService"
        SelectMethod="GetList" TypeName="PowerEasy.Module.Crm.BusinessLogic.Service" DeleteMethod="Delete"
        EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <DeleteParameters>
            <asp:Parameter Name="itemId" Type="String" />
        </DeleteParameters>
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="searchType" QueryStringField="SearchType"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="0" Name="field" QueryStringField="Field"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="" Name="keyword" QueryStringField="KeyWord"
                Type="String" />
            <asp:ControlParameter ControlID="HdnType" Type="Int32" Name="type" PropertyName="Value" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:HiddenField ID="HdnComplexSearch" runat="server" />
    <br />
</asp:Content>
