﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Codebehind="AddressManage.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.AddressManage"
    Title="收货地址管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <pe:ExtendedGridView ID="EgvAddress" runat="server" AutoGenerateColumns="False" CheckBoxFieldHeaderWidth="3%"
    DataSourceID="OdsAddress" OnRowDataBound="EgvAddress_RowDataBound" AllowPaging="True" ItemUnit="个"
    Width="100%" DataKeyNames="AddressId" OnRowCommand="EgvAddress_RowCommand" ShowFooter="false" 
    EmptyDataText="没有任何符合条件的收货地址！" AutoGenerateCheckBoxColumn="True" SerialText=""
    RowDblclickBoundField="AddressID" RowDblclickUrl="AddressModify.aspx?AddressID={$Field}">
    <Columns>
        <asp:BoundField DataField="AddressID" HeaderText="地址ID" SortExpression="AddressID">
            <headerstyle width="5%" />
        </asp:BoundField>
        <pe:TemplateField HeaderText="用户名" HeaderStyle-Width="10%">
            <ItemTemplate>
                <a href='<%#string.Format("../User/UserShow.aspx?UserName={0}",Server.UrlEncode(Eval("UserName").ToString())) %>'>
                    <%#Eval("UserName")%>
                </a>
            </ItemTemplate>
        </pe:TemplateField>
        <asp:BoundField DataField="ConsigneeName" HeaderText="收货人姓名" SortExpression="ConsigneeName">
            <headerstyle width="8%" />
        </asp:BoundField>
        <pe:TemplateField HeaderText="所在地区" ItemStyle-HorizontalAlign="left">
            <ItemTemplate>
                <asp:Label ID="LblArea" runat="server"></asp:Label>
            </ItemTemplate>
            <headerstyle width="15%" />
        </pe:TemplateField>
        <asp:TemplateField HeaderText="街道地址" ItemStyle-HorizontalAlign="left">
            <ItemTemplate>
                <asp:Label runat="server" ID="LblAddress"></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        <asp:BoundField DataField="ZipCode" HeaderText="邮政编码" SortExpression="ZipCode" >
            <headerstyle width="8%" />
        </asp:BoundField>
        <asp:BoundField DataField="HomePhone" HeaderText="电话号码" >
            <headerstyle width="10%" />
        </asp:BoundField>
        <asp:BoundField DataField="Mobile" HeaderText="手机号码" >
            <headerstyle width="10%" />
        </asp:BoundField>
        <asp:TemplateField HeaderText="操作">
            <headerstyle width="10%" />
            <ItemTemplate>
                <asp:LinkButton ID="LbtnModify" runat="server" CommandName="Modify" CommandArgument='<%# Eval("AddressID") %>'>修改</asp:LinkButton>
                <asp:LinkButton ID="LbtnDelete" runat="server" CommandName="Del" CommandArgument='<%# Eval("AddressID") %>'
                    CausesValidation="False" OnClientClick="return confirm('是否要删除此收货地址？')">删除</asp:LinkButton>
            </ItemTemplate>
        </asp:TemplateField>
    </Columns>
    </pe:ExtendedGridView>
<asp:ObjectDataSource ID="OdsAddress" runat="server" SelectMethod="GetAddressList" SelectCountMethod="GetTotalOfAddress"
    TypeName="PowerEasy.Module.General.BusinessLogic.UserManage.Address" EnablePaging="True" StartRowIndexParameterName="startRowIndexId"
        MaximumRowsParameterName="maxNumberRows">
    <SelectParameters>
        <asp:QueryStringParameter DefaultValue="" Name="type" QueryStringField="Type"
            Type="String" />
        <asp:QueryStringParameter DefaultValue="" Name="key" QueryStringField="Key"
            Type="String" />
    </SelectParameters>
</asp:ObjectDataSource>
<br />
<pe:ExtendedButton IsChecked="false" OnClientClick="return batchconfirm('是否要删除选中的订单？');" ID="BtnDelete" runat="server"
    Text="删除选中的地址" OnClick="BtnDelete_Click" />
<br />
</asp:Content>