﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Codebehind="AddressModify.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.AddressModify"
    Title="收货地址修改" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">    
    <table border="0" cellpadding="2" cellspacing="1" class="border" width="100%">
    <tr align="center" class="spacingtitle">
        <td colspan="2">
            收货人信息
        </td>
    </tr>
    <tr class="tdbg">
        <td align="right" style="width: 30%; height: 27px;">
            <b>用户名：</b></td>
        <td align="left" style="height: 27px">
            <asp:Label ID="LblUserName" runat="server"></asp:Label>
        </td>
    </tr>
    <tr class="tdbg">
        <td align="right" style="width: 30%; height: 27px;">
            <b>收货人姓名：</b></td>
        <td align="left" style="height: 27px">
            <asp:TextBox ID="TxtConsigneeName" runat="server" />
            <pe:RequiredFieldValidator ID="ValrContacterName" runat="server" ControlToValidate="TxtConsigneeName"
                Display="dynamic" ErrorMessage="请输入收货人姓名！" SetFocusOnError="true" /></td>
    </tr>
    <tr class="tdbg" style="font-weight: bold; color: #000000">
        <td align="right">
            <b><span style="background-color: #e6eff8">所在地区：</span></b></td>
        <td align="left">
            <pec:AddressPicker ID="AddressPick" runat="server" />
        </td>
    </tr>
    <tr class="tdbg">
        <td align="right">
            <b>邮政编码：</b></td>
        <td align="left">
            <asp:TextBox ID="TxtZipCode" runat="server" />
            <pe:RequiredFieldValidator ID="ValrZipCode" runat="server" ControlToValidate="TxtZipCode"
                Display="Dynamic" ErrorMessage="请输入收货人邮编！" SetFocusOnError="true" ShowRequiredText="false" />
            <pe:RegexValidator ValidateType="ZipCode" ID="VzipZipCode" runat="server" ControlToValidate="TxtZipCode"
                Display="dynamic" SetFocusOnError="true" />
        </td>
    </tr>
    <tr class="tdbg">
        <td align="right">
            <b>电话号码：</b></td>
        <td align="left">
            <asp:TextBox ID="TxtPhone" runat="server" />
            <pe:RegexValidator ValidateType="Mobile" ID="VtelPhone" ControlToValidate="TxtPhone" SetFocusOnError="true"
                Display="dynamic" ErrorMessage="电话号码格式不正确" runat="server" />
            <asp:CustomValidator ID="ValxPhone" ClientValidationFunction="ValxPhone_ClientValidate"
                Display="dynamic" ValidateEmptyText="true" SetFocusOnError="true" runat="server"
                ErrorMessage="至少要输入电话号码和手机号码中的一个" OnServerValidate="ValxPhone_ServerValidate"
                ControlToValidate="TxtPhone" />
        </td>
    </tr>
    <tr class="tdbg">
        <td align="right">
            <b>手机号码：</b>
        </td>
        <td align="left">
            <asp:TextBox ID="TxtMobile" runat="server" />&nbsp;
            <pe:RegexValidator ValidateType="Mobile" ID="VmblMobile" ControlToValidate="TxtMobile" Display="dynamic"
                SetFocusOnError="true" ErrorMessage="手机号码格式不正确" runat="server" />
        </td>
    </tr>
    <tr class="tdbgbottom">
        <td colspan="2">
            <asp:Button ID="BtnSave" runat="server" OnClick="BtnSave_Click" Text="保存" />
            &nbsp;&nbsp;&nbsp;
            <input type="button" id="BtnCancel" value="取消" onclick="javascript:history.back();" class="inputbutton"/>
            </td>
    </tr>
    </table>
    <script language="javascript" type="text/javascript">
        function ValxPhone_ClientValidate(s,e)
        {
            var phone = document.getElementById('<%=TxtPhone.ClientID %>').value;
            var mobile = document.getElementById('<%=TxtMobile.ClientID %>').value;
            if(phone == "" && mobile == "")
            {
                e.IsValid = false;
            }
            else
            {
                e.IsValid = true;
            }
        }
    </script>
</asp:Content>