﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Codebehind="CategorySaleroom.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.CategorySaleroom"
    Title="商品类别销售额排名" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">

    <table class="border" cellpadding="1" cellspacing="1" width="100%">
        <tr align="center">
            <td class="spacingtitle">
                <b>按时间查找销售排名数据</b>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbg" align="center">
                <pec:StatisticalTime ID="PECStatisticalTime" runat="server" DateType="1" DefaultBeginDateYear="-1" IsAutoPostBack="false" OnSearchButtonOnClick="PECStatisticalTime_OnSearchButtonOnClick" />
            </td>
        </tr>
    </table>
    <br />
    <div style="text-align: center; font-size: large;">
        <asp:Label ID="LblTitle" runat="server" Text="商品类别销售额排名"></asp:Label></div>
    <div style="text-align: right;">
        <asp:LinkButton runat="server" ID="LbtnCount" ForeColor="Red" Text="按商品类别销量排名" OnClick="LbtnCount_Click"></asp:LinkButton>
        |
        <asp:LinkButton runat="server" ID="LbtnMoney" Text="按商品类别销售额排名" OnClick="LbtnMoney_Click"></asp:LinkButton>
    </div>
    <pe:ExtendedGridView AllowPaging="true" ID="EgvCategorySaleroom" runat="server" AutoGenerateColumns="false"
        AutoGenerateSerialColumn="true" SerialText="排名" DataSourceID="OdsCategorySaleroom">
        <Columns>
            <pe:BoundField HeaderText="类别名称" DataField="NodeName">
            </pe:BoundField>
            <pe:BoundField HeaderText="销售量" ItemStyle-HorizontalAlign="Right" DataField="SalesVolumn">
            </pe:BoundField>
            <pe:BoundField HeaderText="销售额" ItemStyle-HorizontalAlign="Right" DataField="Saleroom"
                DataFormatString="{0:N2}" HtmlEncode="false">
            </pe:BoundField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsCategorySaleroom" runat="server" SelectCountMethod="GetTotalOfCategorySaleroom"
        SelectMethod="GetCategorySaleroomList" TypeName="PowerEasy.Module.Shop.BusinessLogic.CategorySaleroom"
        EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:Parameter Name="orderType" Type="Int32" DefaultValue="0" />
            <asp:Parameter Name="dateType" Type="Int32" DefaultValue="3" />
            <asp:Parameter Name="year" Type="DateTime" />
            <asp:Parameter Name="month" Type="DateTime" />
            <asp:Parameter Name="beginDate" Type="DateTime" />
            <asp:Parameter Name="endDate" Type="DateTime" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
