﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Codebehind="ConsignmentList.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ConsignmentList"
    Title="发货处理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
<table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
  <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrAllOrder" />>
                         <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="0" onclick="ShowBookmarks"><span>所有</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrUnSender" />> 
                        <asp:LinkButton ID="LinkUnSend" runat="server" CommandArgument="7" onclick="ShowBookmarks"><span>未送货</span></asp:LinkButton> 
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrUnSign" />>    
                       <asp:LinkButton ID="LinkUnSign" runat="server" CommandArgument="8" onclick="ShowBookmarks"><span>未签收</span></asp:LinkButton> 
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrParticalSend" />>    
                         <asp:LinkButton ID="LinkParticalSend" runat="server" CommandArgument="21" onclick="ShowBookmarks"><span>部分发货</span></asp:LinkButton> 
                    </li>
                     <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrSend" />>    
                         <asp:LinkButton ID="LinkSend" runat="server" CommandArgument="13" onclick="ShowBookmarks"><span>已全部发货</span></asp:LinkButton> 
                    </li>
                     <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LtrSign" />>    
                         <asp:LinkButton ID="LinkSign" runat="server" CommandArgument="14" onclick="ShowBookmarks"><span>已签收</span></asp:LinkButton> 
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="GdvOrderList" runat="server" AutoGenerateColumns="False"
        DataSourceID="OdsOrder" DataKeyNames="OrderId" OnRowDataBound="GdvOrderList_RowDataBound"
        AllowPaging="True" ItemName="订单" ItemUnit="个" EmptyDataText="没有任何符合条件的订单！"
        ShowFooter="false" CheckBoxFieldHeaderWidth="3%" 
        RowDblclickBoundField="OrderId" 
        RowDblclickUrl="ConsignmentManage.aspx?OrderID={$Field}">
        <Columns>
            <pe:TemplateField HeaderText="订单编号" SortExpression="OrderNum">
                <HeaderStyle Width="11%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor ID="EbtnLink" IsChecked="true" OperateCode="OrderView" href='<%#string.Format("ConsignmentManage.aspx?OrderID={0}",Eval("OrderId")) %>'
                        runat="server">
                        <%#Eval("OrderNum")%>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="用户名" HeaderStyle-Width="10%">
                <ItemTemplate>
                    <a href='<%#string.Format("../User/UserShow.aspx?UserName={0}",Server.UrlEncode(Eval("UserName").ToString())) %>'>
                        <%#Eval("UserName")%>
                    </a>
                </ItemTemplate>
<HeaderStyle Width="10%"></HeaderStyle>
            </pe:TemplateField>
             <pe:TemplateField HeaderText="收货人" SortExpression="ContacterName">
                <ItemTemplate>
                    <a href='<%# string.IsNullOrEmpty(Eval("UserName").ToString()) ? "#" : "../User/UserShow.aspx?UserName="+Eval("UserName").ToString() %>'><%# Eval("ContacterName")%></a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="Address" HeaderText="收货人地址"  ItemStyle-HorizontalAlign="Left">
<ItemStyle HorizontalAlign="Left"></ItemStyle>
            </pe:BoundField>
            <pe:BoundField DataField="ZipCode" HeaderText="邮政编码"  HeaderStyle-Width="8%">
<HeaderStyle Width="7%"></HeaderStyle>
            </pe:BoundField>
            <pe:BoundField DataField="Phone" HeaderText="联系电话"  HeaderStyle-Width="10%">
<HeaderStyle Width="10%"></HeaderStyle>
            </pe:BoundField>
            <pe:TemplateField HeaderText="付款状态">
                <HeaderStyle Width="7%" />
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblPayStatus" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="物流状态">
                <HeaderStyle Width="7%" />
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblDeliverStatus" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="PrintState" HeaderText="已打印" HeaderStyle-Width="5%"></pe:BoundField>
            <pe:TemplateField HeaderText="打印时间">
                <HeaderStyle Width="7%" />
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblPrintTime" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
        <FooterStyle CssClass="tdbg" />
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnOrderType" runat="server" Value="0" />
    <asp:ObjectDataSource ID="OdsOrder" runat="server" SelectCountMethod="GetTotalOfOrder"
        SelectMethod="GetList" TypeName="PowerEasy.Module.Shop.BusinessLogic.Order" EnablePaging="True" StartRowIndexParameterName="startRowIndexId"
        MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="searchType" QueryStringField="SearchType" Type="String" />
            <asp:QueryStringParameter DefaultValue="0" Name="field" QueryStringField="Field" Type="String" />
            <asp:QueryStringParameter DefaultValue="Consignment" Name="keyword" QueryStringField="KeyWord" Type="String" />
            <asp:QueryStringParameter DefaultValue="Consignment" Name="action" QueryStringField="Action" Type="String" />
            <asp:ControlParameter ControlID="HdnOrderType" Type="Int32" Name="orderTypes" PropertyName="Value" />
            <asp:Parameter DefaultValue="" Name="filtration" Type="String" />
            <asp:Parameter Name="IsAdmin" Type="Boolean" DefaultValue="true" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
