﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    ValidateRequest="false" Codebehind="Coupon.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.Coupon" EnableEventValidation="false"
    Title="优惠券添加/修改" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>
                    <asp:Label ID="LblTitle" runat="server" Text="添加优惠券规则"></asp:Label></b>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 35%" class="tdbgleft">
                <b>优惠券名称：</b></td>
            <td>
                <asp:TextBox ID="TxtCouponName" runat="server" MaxLength="50"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrCouponName" runat="server" ErrorMessage="优惠券名称不能为空"
                    ControlToValidate="TxtCouponName" Display="Dynamic"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <b>优惠券号码生成格式：</b>
                <br />
                说明：每个?代表一个英文字母，#代表一个数字， *代表一个英文字母或数字(自定义符号必须是半角)
            </td>
            <td>
                <asp:TextBox ID="TxtCouponNumPattern" runat="server" Text="PE???###?#*" MaxLength="50"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrCouponNumPattern" runat="server" ErrorMessage="优惠券号码生成格式不能为空"
                    ControlToValidate="TxtCouponNumPattern" Display="Dynamic"></pe:RequiredFieldValidator>
                <asp:RegularExpressionValidator ID="Vale" runat="server" ControlToValidate="TxtCouponNumPattern"
                    Display="dynamic" SetFocusOnError="true" ValidationExpression="\S*(\?+\#*\**|\#+\?*\**|\*+\#*\?*)\S*"
                    ErrorMessage="优惠券号码生成格式中至少需要有“?、#、*”中的一种"></asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <b>面值：</b></td>
            <td>
                <asp:TextBox ID="TxtMoney" runat="server" MaxLength="50"></asp:TextBox> 
                <pe:RequiredFieldValidator ID="ValrMoney" runat="server" ErrorMessage="优惠券面值不能为空"
                    ControlToValidate="TxtMoney" Display="Dynamic"></pe:RequiredFieldValidator>
                <pe:RegexValidator ValidateType="Money" ID="VmoneyMoney" ControlToValidate="TxtMoney" Display="dynamic"
                    runat="server"></pe:RegexValidator>优惠券面值添加后不允许修改
           </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <b>优惠券状态：</b></td>
            <td>
                <asp:RadioButtonList ID="RadlState" RepeatDirection="Horizontal" runat="server">
                    <asp:ListItem Selected="true" Value="1">启用</asp:ListItem>
                    <asp:ListItem Value="0">禁用</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <b>适用会员组：</b></td>
            <td>
                <asp:CheckBoxList ID="ChklUserGroup" DataTextField="value" RepeatColumns="4" DataValueField="key"
                    RepeatDirection="horizontal" runat="server">
                </asp:CheckBoxList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <b>获得优惠券方式：</b>
                <br/>
                说明：预先生成的优惠券需要人工派送，其它则是订单结清后系统自动派送至前台会员帐户中
            </td>
            <td>
                <asp:RadioButtonList AutoPostBack="true" ID="RadlCouponCreateType" RepeatColumns="2"
                    runat="server" RepeatDirection="horizontal" OnSelectedIndexChanged="RadlCouponCreateType_SelectedIndexChanged">
                    <asp:ListItem Selected="true" Value="0">购买任意商品可得到此优惠券</asp:ListItem>
                    <asp:ListItem Value="1">购买指定模型下的商品可得到此优惠券</asp:ListItem>
                    <asp:ListItem Value="2">购买指定商品可得到此优惠券</asp:ListItem>
                    <asp:ListItem Value="3">订单满足一定金额可得到此优惠券</asp:ListItem>
                    <asp:ListItem Value="4">预先生成一定数量的优惠券</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <asp:PlaceHolder runat="server" ID="PlhSelectProduct" Visible="false">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <b>
                        <asp:Label runat="server" ID="LblSelectProductTitle"></asp:Label></b></td>
                <td>
                    <asp:PlaceHolder runat="server" ID="PlhList" Visible="false">
                        <table>
                            <tr>
                                <td rowspan="2" style="width: 100px">
                                    <asp:ListBox Width="200" Height="70" DataTextField="Value" DataValueField="Key" ID="LstSelectedProduct"
                                        runat="server"></asp:ListBox>
                                     <asp:CustomValidator ID="ValxSelectedProduct" ClientValidationFunction="ValxSelectedProduct_ClientValidate" Display="dynamic" ValidateEmptyText="true" SetFocusOnError="true" runat="server" ErrorMessage="指定商品不能为空" ControlToValidate="LstSelectedProduct"></asp:CustomValidator>
                                     <asp:CustomValidator ID="ValxSelectedModel" ClientValidationFunction="ValxSelectedModel_ClientValidate" Display="dynamic" ValidateEmptyText="true" SetFocusOnError="true" runat="server" ErrorMessage="指定模型不能为空" ControlToValidate="LstSelectedProduct"></asp:CustomValidator>
                                    <asp:HiddenField ID="HdnSelecedtProduct" runat="server" />
                                    <asp:HiddenField ID="HdnAllValue" runat="server" />
                                </td>
                                <td style="width: 100px">
                                    <pe:FloatDivDialog ID="BtnSelectProduct" runat="server" Height="450" Width="600" CloseText="关闭" Name="添加" Skin="inputbutton"  Title="添加商品" ShowType="1"></pe:FloatDivDialog>
                                </td>
                            </tr>
                            <tr>
                                <td style="width: 100px">
                                    <input type="button" class="inputbutton" onclick="DelProduct('<%=LstSelectedProduct.ClientID%>','<%=HdnSelecedtProduct.ClientID %>','<%=HdnAllValue.ClientID %>')"
                                        value="删除" />
                                </td>
                            </tr>
                        </table>
                    </asp:PlaceHolder>
                    <asp:TextBox ID="TxtOrderMoney" runat="server" Visible="false"></asp:TextBox>
                </td>
            </tr>
        </asp:PlaceHolder>
         <tr class="tdbg" runat="server" id="couponNum" visible="false">
            <td class="tdbgleft">
                <b>每次生成张数：</b></td>
            <td>
                <asp:TextBox ID="TxtCouponNum" runat="server" Text="1" MaxLength="50"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrCouponNum" runat="server" ErrorMessage="优惠券生成张数不能为空" ControlToValidate="TxtCouponNum" Display="Dynamic"></pe:RequiredFieldValidator>
                <asp:RangeValidator ID="rangCouponNum" ControlToValidate="TxtCouponNum" SetFocusOnError="true" Display="Dynamic" MaximumValue="65535" MinimumValue="1" Type="Integer" runat="server" ErrorMessage="请输入大于0小于等于65535之间的整数"></asp:RangeValidator>
                </td>
        </tr>
        <tr class="tdbg" runat="server" id="beginDate">
            <td class="tdbgleft">
                <b>赠送开始时间：</b></td>
            <td>
                <pe:DatePicker ID="DpkBeginDate" runat="server"></pe:DatePicker>
                <pe:RegexValidator ValidateType="Date" ID="VdateBeginDate" ControlToValidate="DpkBeginDate" runat="server"
                    Display="Dynamic" SetFocusOnError="True"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg" runat="server" id="endDate">
            <td class="tdbgleft">
                <b>赠送截止时间：</b></td>
            <td>
                <pe:DatePicker ID="DpkEndDate" runat="server"></pe:DatePicker>
                <pe:RegexValidator ValidateType="Date" ID="VdateEndDate" ControlToValidate="DpkEndDate" runat="server"
                    Display="Dynamic" SetFocusOnError="True"></pe:RegexValidator>
                    <asp:CompareValidator ID="CompareValidator2" Operator="GreaterThan"
                Type="Date" ControlToValidate="DpkEndDate" ControlToCompare="DpkBeginDate" Display="Dynamic"
                runat="server" ErrorMessage="开始时间不能小于截止时间！" />
            </td>
        </tr>
         <tr class="tdbg">
            <td class="tdbgleft">
                <b>使用开始时间：</b></td>
            <td>
                <pe:DatePicker ID="DpkUseBeginDate" runat="server"></pe:DatePicker>
                <pe:RegexValidator ValidateType="Date" ID="VdateUseBeginDate" ControlToValidate="DpkUseBeginDate" runat="server"
                    Display="Dynamic" SetFocusOnError="True"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <b>使用截止时间：</b></td>
            <td>
                <pe:DatePicker ID="DpkUseEndDate" runat="server"></pe:DatePicker>
                <pe:RegexValidator ValidateType="Date" ID="VdateUseEndDate" ControlToValidate="DpkUseEndDate" runat="server"
                    Display="Dynamic" SetFocusOnError="True"></pe:RegexValidator>
                <asp:CompareValidator ID="CompareValidator1" Operator="GreaterThan" Type="Date" ControlToValidate="DpkUseEndDate" 
                    ControlToCompare="DpkUseBeginDate" Display="Dynamic"
                runat="server" ErrorMessage="开始时间不能小于截止时间！" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <b>限用商品：</b></td>
            <td>
                <asp:RadioButtonList ID="RadlProductLimit" runat="server" RepeatDirection="horizontal"
                    AutoPostBack="true" OnSelectedIndexChanged="RadlProductLimit_SelectedIndexChanged">
                    <asp:ListItem Selected="true" Value="0">所有商品</asp:ListItem>
                    <asp:ListItem Value="1">指定模型下的商品</asp:ListItem>
                    <asp:ListItem Value="2">指定商品</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <asp:PlaceHolder runat="server" ID="PlhProductLimit" Visible="false">
            <tr class="tdbg">
                <td class="tdbgleft">
                    <b>
                        <asp:Label runat="server" ID="LblProductLimitTitle"></asp:Label></b></td>
                <td>
                    <table>
                        <tr>
                            <td rowspan="2" style="width: 100px">
                                <asp:ListBox Width="200" Height="70" DataTextField="Value" DataValueField="Key" ID="LstLimit"
                                    runat="server"></asp:ListBox>
                                     <asp:CustomValidator ID="ValcLimitProduct" ClientValidationFunction="ValcLimitProduct_ClientValidate" Display="dynamic" ValidateEmptyText="true" SetFocusOnError="true" runat="server" ErrorMessage="指定商品不能为空" ControlToValidate="LstLimit"></asp:CustomValidator>
                                     <asp:CustomValidator ID="ValcLimitModel" ClientValidationFunction="ValcLimitdModel_ClientValidate" Display="dynamic" ValidateEmptyText="true" SetFocusOnError="true" runat="server" ErrorMessage="指定模型不能为空" ControlToValidate="LstLimit"></asp:CustomValidator>
                                <asp:HiddenField ID="HdnLimit" runat="server" />
                                <asp:HiddenField ID="HdnLimitAllValue" runat="server" />
                            </td>
                            <td style="width: 100px">
                                <pe:FloatDivDialog ID="BtnLimit" runat="server" Height="450" Width="600" CloseText="关闭" Name="添加" Skin="inputbutton"  Title="添加商品" ShowType="1"></pe:FloatDivDialog>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 100px">
                                <input type="button" class="inputbutton" onclick="DelProduct('<%=LstLimit.ClientID%>','<%=HdnLimit.ClientID %>','<%=HdnLimitAllValue.ClientID %>')"
                                    value="删除" />
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </asp:PlaceHolder>
        <tr class="tdbg">
            <td class="tdbgleft">
                <b>使用该优惠券需要订单满足金额为：</b></td>
            <td>
                <asp:TextBox ID="TxtOrderTotalMoney" runat="server" MaxLength="50"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrOrderTotalMoney" runat="server" ErrorMessage="订单满足金额不能为空"
                    ControlToValidate="TxtOrderTotalMoney" Display="Dynamic"></pe:RequiredFieldValidator>
                <asp:RegularExpressionValidator ID="ValeOrderTotalMoney" ControlToValidate="TxtOrderTotalMoney"
                    runat="server" Display="dynamic" SetFocusOnError="true" ValidationExpression="[1-9]+[0-9]*(\.?[0-9]+)?|0\.0*[0-9]*|0"
                    ErrorMessage="订单满足金额格式不正确"></asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr class="tdbg" runat="server" id="Notice" visible="true">
            <td class="tdbgleft">
                <b>通知类型：</b></td>
            <td>
                <asp:CheckBoxList ID="ChklNoticeType" runat="server" 
                    RepeatDirection="Horizontal" >
                    <asp:ListItem Value="1">站内短消息</asp:ListItem>
                    <asp:ListItem Value="2">邮件</asp:ListItem>
                    <asp:ListItem Value="4">手机短信</asp:ListItem>
                </asp:CheckBoxList>
            </td>
        </tr>
        <tr class="tdbg" runat="server" id="TRBuild" visible="false">
            <td class="tdbgleft">
                <b>生成选项：</b>
            </td>
            <td>
                <asp:RadioButtonList ID="RablBuild" runat="server" 
                    RepeatDirection="Horizontal" >
                    <asp:ListItem Value="0" Selected="True">保存规则时生成优惠劵</asp:ListItem>
                    <asp:ListItem Value="1">只保存规则</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td colspan="2" style="text-align: center">
                <asp:HiddenField ID="HdnCouponID" runat="server" />
                <asp:Button ID="BtnSave" runat="server" Text="保存" OnClick="BtnSave_Click" />&nbsp;&nbsp;
                <input name="Cancel" type="button" class="inputbutton" id="Cancel" value="取消" onclick="Redirect('CouponManage.aspx')" />
            </td>
        </tr>
    </table>

    <script language="javascript" type="text/javascript">
       
        function SetListValue(listControl,hdnControl,hdnAllValueControl,arr)
        {
            var list = document.getElementById(listControl)
            var hdn = document.getElementById(hdnControl);
            var allValue = document.getElementById(hdnAllValueControl);         
            if (arr != null){
               var ss=arr.split('$$$');
               if(checkName(list,ss[1]))
               {
                   return;
               }
               else
               {    
                    list.options[list.length] = new Option(ss[0],ss[1]);
                    if(hdn.value == "")
                    {
                        hdn.value = ss[1];
                        allValue.value = ss[0] + "$$$" + ss[1];
                        
                    }
                    else
                    {
                        hdn.value = hdn.value + "," + ss[1];
                        allValue.value = allValue.value + "," + ss[0] + "$$$" + ss[1];
                    }
                }
            }
        }
          
          
        function DoProductListPostBack(productString)
        {
            var list = "<%=LstSelectedProduct.ClientID%>";
            var hdn = "<%=HdnSelecedtProduct.ClientID%>";
            var allValue = "<%=HdnAllValue.ClientID%>";
            SetListValue(list, hdn, allValue, productString);
            CloseFloatingDialog();                     
        }

        function DoProductListPostBack2(productString)
        {
            var list = "<%=LstLimit.ClientID%>";
            var hdn = "<%=HdnLimit.ClientID%>";
            var allValue = "<%=HdnLimitAllValue.ClientID%>";
            SetListValue(list, hdn, allValue, productString);
            CloseFloatingDialog();                       
        }
          
        function checkName(listControl,checkName)
        {
            for(i=0;i<listControl.length;i++)
            {
                if(listControl.options[i].value == checkName)
                {
                    return true;
                }
            }
            return false;
        }
          
                
        function DelProduct(listControl,hdnControl,hdnAllValueControl)
        {         
        var list = document.getElementById(listControl);
        if(list.length==0 || list.selectedIndex==-1){return false;}   
        var hdn = document.getElementById(hdnControl);
        var hdnAllValue = document.getElementById(hdnAllValueControl);
        var arr = hdn.value.split(',');
        var arrAllValue = hdnAllValue.value.split(',');
        var newValue ="";
        var allValue = "";
        for(i=0;i<arr.length;i++)
        {
            if(arr[i] != list.options[list.selectedIndex].value)
            {
                if(newValue == "")
                {
                    newValue = arr[i];
                    allValue = arrAllValue[i];
                } 
                else
                {
                    newValue = newValue + "," + arr[i];
                    allValue = allValue + "," + arrAllValue[i];
                }
            }
        }
        list.options[list.selectedIndex]=null;
        hdn.value = newValue;   
        hdnAllValue.value = allValue; 
        }
        
        function ValxSelectedProduct_ClientValidate(s,e)
        {
            CheckSelected(s,e,"2","<%=HdnSelecedtProduct.ClientID %>","<%=RadlCouponCreateType.UniqueID%>");       
        }

        function ValxSelectedModel_ClientValidate(s,e)
        {
            CheckSelected(s,e,"1","<%=HdnSelecedtProduct.ClientID %>","<%=RadlCouponCreateType.UniqueID%>");             
        }
        
        function ValcLimitProduct_ClientValidate(s,e)
        {
            CheckSelected(s,e,"2","<%=HdnLimit.ClientID %>","<%=RadlProductLimit.UniqueID%>");       
        }

        function ValcLimitdModel_ClientValidate(s,e)
        {
            CheckSelected(s,e,"1","<%=HdnLimit.ClientID %>","<%=RadlProductLimit.UniqueID%>");             
        }
        
        function CheckSelected(s,e,selectType,HdnControl,RadlControl)
        {
            var listValue = document.getElementById(HdnControl).value;
            var selcetType;
            
           var objSel = document.getElementsByName(RadlControl);
           
           for(i=0;i<objSel.length;i++ )
           {
               if(objSel[i].checked==true)
                   selcetType = objSel[i].value;
           } 
           if(selcetType == selectType && listValue == "")
           {
                e.IsValid = false;
           }
           else
           {
                e.IsValid = true;
           }        
        }
        

    </script>

</asp:Content>
