﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true" CodeBehind="CouponList.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.CouponList" Title="选择优惠券" %>
<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
<table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
  <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LblAll" />>
                        <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="0" onclick="ShowBookmarks"><span>所有</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LblUnUse" />>    
                       <asp:LinkButton ID="LinkUnUse" runat="server" CommandArgument="1" onclick="ShowBookmarks"><span>未使用</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LblUse" />>    
                       <asp:LinkButton ID="LinkUse" runat="server" CommandArgument="2" onclick="ShowBookmarks"><span>已使用</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LblNotNotice" />>    
                       <asp:LinkButton ID="LinkNotNotice" runat="server" CommandArgument="3" onclick="ShowBookmarks"><span>未派送</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LblNotice" />>    
                       <asp:LinkButton ID="LinkNotice" runat="server" CommandArgument="4" onclick="ShowBookmarks"><span>已派送未使用</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LblNoticeUsed" />>    
                       <asp:LinkButton ID="LinkNoticeUsed" runat="server" CommandArgument="5" onclick="ShowBookmarks"><span>已派送已使用</span></asp:LinkButton>
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView AllowPaging="true" ID="EgvCoupon" runat="server" AutoGenerateColumns="false" AutoGenerateCheckBoxColumn="true"
        DataSourceID="OdsCoupon" OnRowDataBound="EgvCoupon_RowDataBound" DataKeyNames="UserName">
        <Columns>
            <pe:BoundField HeaderText="优惠券号码" HeaderStyle-Width="12%">
            </pe:BoundField>
            <pe:BoundField HeaderText="优惠券名称">
            </pe:BoundField>
            <pe:BoundField HeaderText="面值" HeaderStyle-Width="10%">
            </pe:BoundField>
            <pe:BoundField HeaderText="用户名" HeaderStyle-Width="10%">
            </pe:BoundField>
             <pe:BoundField HeaderText="使用的订单" HeaderStyle-Width="15%">
            </pe:BoundField>
            <pe:BoundField HeaderText="已使用" HeaderStyle-Width="6%">
            </pe:BoundField>
            <pe:BoundField HeaderText="使用截止时间" HeaderStyle-Width="10%">
            </pe:BoundField>
            <pe:BoundField HeaderText="操作" HeaderStyle-Width="8%">
            </pe:BoundField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnType" runat="server" Value="0" />
    <asp:ObjectDataSource ID="OdsCoupon" runat="server" EnablePaging="true" TypeName="PowerEasy.Module.Shop.BusinessLogic.Coupon"
        SelectMethod="GetAllDetailList" SelectCountMethod="GetAllTotalOfCoupon" MaximumRowsParameterName="maxNumberRows"
        StartRowIndexParameterName="startRowIndexId">
        <SelectParameters>
            <asp:QueryStringParameter Name="searchType" QueryStringField="SearchType" Type="Int32" DefaultValue="0" />
            <asp:QueryStringParameter Name="keyword" QueryStringField="KeyWord" Type="String"/>
            <asp:ControlParameter ControlID="HdnType" Type="Int32" Name="type" PropertyName="Value" />
            <asp:QueryStringParameter DefaultValue="-1" Name="CouponID" 
                QueryStringField="CouponID" Type="Int32" />
        </SelectParameters>
     </asp:ObjectDataSource>
     <br />
    <asp:Button ID="BtnNotice" runat="server" Text="派送选中的优惠劵" OnClientClick="return batchconfirm('是否要派送选中的优惠劵？');" OnClick="BtnNotice_Click" />
    <pe:FloatDivDialog ID="FdvCouponInfo" runat="server"  Title="查看优惠劵" EnableViewState="false"
        Width="430" Height="250" Enabled="true" >
    </pe:FloatDivDialog>
    <script type="text/javascript">
        //打开浮动窗口
        function showDiv(index) {
            jQuery('#<%=FdvCouponInfo.ClientID %>' + '__HdnLoadUrl').prop('value', 'CouponItemView.aspx?CouponNum=' + index + "&From=DivIframe");
            jQuery('#<%=FdvCouponInfo.ClientID %>' + '__LitID').click();
        }
    </script>
 </asp:Content>
