﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Codebehind="CouponManage.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.CouponManage"
    Title="优惠券规则管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <pe:ExtendedGridView ID="EgvCoupon" runat="server" AllowPaging="True" AutoGenerateColumns="False"
        AutoGenerateCheckBoxColumn="True" DataKeyNames="CouponId" DataSourceID="OdsCoupon"
        ItemName="优惠券规则" ItemUnit="项" OnRowCommand="EgvCoupon_RowCommand" OnRowDataBound="EgvCoupon_RowDataBound">
        <Columns>
            <pe:BoundField HeaderText="优惠券规则名称" DataField="CouponName">
            </pe:BoundField>
            <pe:BoundField HeaderText="号码格式" DataField="CouponNumPattern" HeaderStyle-Width="12%">
<HeaderStyle Width="12%"></HeaderStyle>
            </pe:BoundField>
            <pe:BoundField HeaderText="面值" DataField="Money" HeaderStyle-Width="12%" DataFormatString="{0:N2}"
                HtmlEncode="false">
<HeaderStyle Width="12%"></HeaderStyle>
            </pe:BoundField>
            <pe:BoundField HeaderText="赠送起始时间" DataField="BeginDate" HeaderStyle-Width="12%" DataFormatString="{0:yyyy-MM-dd}"
                HtmlEncode="false">
            </pe:BoundField>
            <pe:TemplateField HeaderText="赠送截止时间" HeaderStyle-Width="12%">
                <ItemTemplate>
                    <asp:Label ID="LabEndDate" runat="server"></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="已启用" HeaderStyle-Width="6%">
                <ItemTemplate>
                    <%#Convert.ToBoolean(Eval("State")) ? "<font color='green'>√</font>" : "<font color='red'>×</font>"%>
                </ItemTemplate>

<HeaderStyle Width="6%"></HeaderStyle>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="常规操作">
                <HeaderStyle Width="23%"></HeaderStyle>
                <ItemTemplate>
                    <asp:LinkButton ID="LbtnPassed" runat="server" CommandName="Passed" CommandArgument='<%# Bind("CouponId") %>'
                        Visible='<%#Convert.ToInt32(Eval("State"))==0 %>'>启用</asp:LinkButton>
                    <asp:LinkButton ID="LbtnCancelPassed" runat="server" CommandName="CancelPassed" CommandArgument='<%# Bind("CouponId") %>'
                        Visible='<%#Convert.ToInt32(Eval("State"))==1 %>'>禁用</asp:LinkButton>
                    <a href='CouponView.aspx?CouponID=<%#Eval("CouponId") %>'>查看</a>
                     <a href='Coupon.aspx?Action=Modify&CouponID=<%#Eval("CouponId") %>'>修改</a>
                    <asp:LinkButton ID="LbtnDelete" runat="server" CommandName="Del" CommandArgument='<%# Bind("CouponId") %>'
                        OnClientClick="return confirm('删除选中的优惠券规则,系统会自动删除已赠送给用户的优惠券，是否继续？')">删除</asp:LinkButton>
                    <a href="CouponList.aspx?CouponID=<%#Eval("CouponID") %>">优惠券</a>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsCoupon" runat="server" SelectCountMethod="GetTotalOfCoupon"
        SelectMethod="GetList" TypeName="PowerEasy.Module.Shop.BusinessLogic.Coupon" EnablePaging="True" StartRowIndexParameterName="startRowIndexId"
        MaximumRowsParameterName="maxNumberRows"></asp:ObjectDataSource>
    <br />
    &nbsp;&nbsp;
    <pe:ExtendedButton IsChecked="true" OperateCode="Coupon" ID="BtnDelete" runat="server"
        OnClientClick="return batchconfirm('删除选中的优惠券规则,系统会自动删除已赠送给用户的优惠券，是否继续？')" Text="删除选中的优惠券规则"
        OnClick="BtnDelete_Click" />
</asp:Content>
