﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.CourierManage" Title="快递公司管理"
    CodeBehind="CourierManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider"
        AdditionalNode="所有快递公司信息" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="extendgrdCourier" runat="server" AutoGenerateColumns="False"
        DataKeyNames="CourierId" OnRowCommand="extendgrdCourier_RowCommand" SerialText="" 
        OnRowDataBound="extendgrdCourier_RowDataBound" IsHoldState="True">
        <Columns>
            <asp:BoundField DataField="CourierId" HeaderText="ID" SortExpression="CourierId">
                <HeaderStyle Width="5%" />
            </asp:BoundField>
            <asp:BoundField DataField="ShortName" HeaderText="名称缩写" HtmlEncode="False" SortExpression="ShortName">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField DataField="FullName" HeaderText="全称" SortExpression="FullName" HtmlEncode="False">
                <HeaderStyle Width="15%" />
            </asp:BoundField>
            <asp:BoundField DataField="Contacter" HeaderText="联系人" HtmlEncode="False" SortExpression="Contacter">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField DataField="Telephone" HeaderText="电话" HtmlEncode="False" SortExpression="Telephone">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField DataField="Address" HeaderText="地址" HtmlEncode="False" SortExpression="Address">
                <HeaderStyle Width="25%" />
            </asp:BoundField>
            <pe:TemplateField HeaderText="已启用" SortExpression="Status">
                <HeaderStyle Width="5%" />
                <ItemTemplate>
                    <%# (int)Eval("Status") == 1 ? "√" : "<font color=red>×</font>"%>
                </ItemTemplate>
            </pe:TemplateField>
            <asp:TemplateField HeaderText="常规操作">
                <ItemTemplate>
                    <asp:LinkButton ID="LbtnStatus" runat="server" CommandArgument='<%# Bind("CourierId") %>'
                        CommandName='<%# (int)Eval("Status")==1 ? "DisEnable" : "Enable" %>' Text='<%# ((int)Eval("Status"))==1 ? "禁用" : "启用" %>'></asp:LinkButton>
                    <pe:ExtendedAnchor ID="extendAnchor" runat="server" href='<%#Eval("CourierId","Couriers.aspx?Action=Modify&CourierId={0}") %>'
                        IsChecked="true" OperateCode="CourierManage">
                        修改</pe:ExtendedAnchor>
                    <asp:LinkButton ID="LbtnDelete" runat="server" CausesValidation="False" CommandArgument='<%# Eval("CourierId") %>'
                        CommandName="Delete">删除</asp:LinkButton>
                </ItemTemplate>
                <HeaderStyle Width="10%" />
                <ItemStyle Width="10%" />
            </asp:TemplateField>
            <pe:TemplateField HeaderText="排序操作" SortExpression="OrderId">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <asp:DropDownList ID="DropOrderId" runat="server" AutoPostBack="True" DataSourceID="OdsCourier"
                        DataTextField="OrderId" DataValueField="OrderId" OnSelectedIndexChanged="DdlOrderId_SelectedIndexChanged"
                        SelectedValue='<%# Bind("OrderId") %>' Width="60px">
                    </asp:DropDownList>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsCourier" runat="server" DeleteMethod="Delete" SelectMethod="GetCourierList"
        TypeName="PowerEasy.Module.Shop.BusinessLogic.Courier">
        <DeleteParameters>
            <asp:Parameter Name="courierId" Type="Int32" />
        </DeleteParameters>
    </asp:ObjectDataSource>
</asp:Content>
