﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.DeliverItemList" Title="发退货记录管理" Codebehind="DeliverItemList.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
<table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
  <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitAll" />>
                         <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="0"
                             onclick="ShowBookmarks"><span>全部记录</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitConsignment" />>
                         <asp:LinkButton ID="LinkConsignment" runat="server" CommandArgument="3"
                             onclick="ShowBookmarks"><span>发货记录</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitHandBack" />>    
                        <asp:LinkButton ID="LinkHandBack" runat="server" CommandArgument="4"
                             onclick="ShowBookmarks"><span>退货记录</span></asp:LinkButton>
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="EgvDeliverItem" runat="server" AutoGenerateColumns="False"
        AllowPaging="True" DataSourceID="OdsDeliverItem" CheckBoxFieldHeaderWidth="3%"
        SerialText="" OnRowDataBound="EgvDeliverItem_OnRowDataBound"
        RowDblclickBoundField="DeliverId" RowDblclickUrl="DeliverItemDetail.aspx?DeliverItemID={$Field}">
        <Columns>
            <pe:BoundField DataField="DeliverDate" DataFormatString="{0:yyyy-MM-dd}" HtmlEncode="False"
                HeaderText="日期" SortExpression="DeliverDate">
                <HeaderStyle Width="9%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="方向">
                <HeaderStyle Width="6%" />
                <ItemTemplate>
                    <%# (Int32)Eval("DeliverDirection") == 1 ? "发货" : "<font color=red>退货</font>"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="客户名称">
                <HeaderStyle Width="9%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" operateCode="ClientView" href='<%# Eval("ClientId", "~/Admin/Crm/ClientShow.aspx?ClientID={0}") %>'>
                        <%# Eval("ClientName") %>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="用户名">
                <HeaderStyle Width="9%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" operateCode="UserView" href='<%# Eval("UserName", "~/Admin/User/UserShow.aspx?UserName={0}") %>'>
                        <%# Eval("UserName") %>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="收货人姓名">
                <HeaderStyle Width="9%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" OperateCode="OrderView" href='<%# Eval("OrderId", "OrderManage.aspx?OrderID={0}") %>'>
                        <%# Eval("ContacterName") %>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="订单编号">
                <HeaderStyle Width="13%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" OperateCode="OrderView" href='<%# Eval("OrderId", "OrderManage.aspx?OrderID={0}") %>'>
                        <%# Eval("OrderNum") %>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="快递公司">
                <HeaderStyle Width="8%" />
                <ItemTemplate>     
                    <asp:Literal ID="LitExpressCompany" runat="server"></asp:Literal>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="ExpressNumber" HeaderText="快递单号" SortExpression="ExpressNumber">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="操作人">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <%# Eval("Inputer")%>
                </ItemTemplate>
            </pe:TemplateField>
              <pe:TemplateField HeaderText="经手人">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                  <%# Eval("HandlerName")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="已签收">
                <HeaderStyle Width="7%" />
                <ItemTemplate>
                    <%# (bool)Eval("Received") == false ? "" : "<font color=red>√</font>"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="操作">
                <ItemTemplate>
                    <a href='<%#string.Format("DeliverItemDetail.aspx?DeliverItemID={0}",Eval("DeliverId"))%>'>
                        查看</a>
                        <pe:ExtendedLinkButton ID="LBtnSignIn" IsChecked="true" OperateCode="OrderReceived" runat="server"  OnClick="LBtnSignIn_Click" Text="签收"></pe:ExtendedLinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnType" runat="server" Value="0" />
    <asp:ObjectDataSource ID="OdsDeliverItem" runat="server" SelectCountMethod="GetTotalOfDeliverItem"
        SelectMethod="GetList" TypeName="PowerEasy.Module.Shop.BusinessLogic.DeliverItem" EnablePaging="True"
        StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:QueryStringParameter Name="searchType" QueryStringField="SearchType" Type="Int32" />
            <asp:QueryStringParameter Name="keyword" QueryStringField="KeyWord" Type="String" />
            <asp:QueryStringParameter Name="quickSearch" QueryStringField="QuickSearch" Type="Int32" />
            <asp:ControlParameter ControlID="HdnType" Type="Int32" Name="type" PropertyName="Value" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
