﻿<%@ Page Language="C#" MasterPageFile="~/Admin/Guide.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.DeliverItemListGuide" Codebehind="DeliverItemListGuide.aspx.cs"
    Title="发退货记录查询向导" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphTitle" runat="Server">
    发退货记录查询
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphSubMenu" runat="Server">
    <div class="guideexpand" onclick="Switch(this)">
        快速查找</div>
    <div class="guide">
        <ul>
            <li><a href="DeliverItemList.aspx" target="main_right">全部记录</a></li>
            <li><a href="DeliverItemList.aspx?QuickSearch=1" target="main_right">最近10天内的新记录</a></li>
            <li><a href="DeliverItemList.aspx?QuickSearch=2" target="main_right">最近一月内的新记录</a></li>
        </ul>
    </div>
    <div class="guideexpand" onclick="Switch(this)">
        高级查询</div>
    <div class="guidesearch">
        <ul>
            <li>
                <select id="SelField" style="width: 140px">
                    <option value="1">客户名称</option>
                    <option value="2">收货人姓名</option>
                    <option value="3">用户名</option>
                    <option value="4">快递公司</option>
                    <option value="5">快递单号</option>
                    <option value="6">经手人</option>
                    <option value="7">发退货日期</option>
                </select>
            </li>
            <li>
                <input id="TxtKeyWord" style="width: 134px;" type="text" class="inputtext" />
            </li>
            <li>
                <input id="BtnSearch" type="button" class="inputbutton" value="查询" onclick="OpenMainRight()" />
            </li>
        </ul>
    </div>

    <script type="text/javascript">
    function OpenMainRight()
    {
        var field=0;
        var keyword = document.getElementById("TxtKeyWord").value.trim();
        if (keyword == '') {
            alert("请输入查询关键字！");
            return;
        }        
        var objSel = document.getElementById("SelField");
        field = objSel.options[objSel.options.selectedIndex].value;
        if (field == "7" && !isDate(keyword)) {
            alert("请输入有效日期，日期格式如：YYYY-MM-DD");
            return;            
        }
        var url = "DeliverItemList.aspx?SearchType="+field+"&KeyWord="+escape(keyword);
         JumpToMainRight(url);
    }
    </script>

</asp:Content>
