﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.DeliverTypeUI" Title="送货方式添加/修改"
    MaintainScrollPositionOnPostback="true" CodeBehind="DeliverType.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>
                    <asp:Label ID="LblTitle" runat="server" Text="Label"></asp:Label></b>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right">
                <b>送货方式名称：</b>
            </td>
            <td>
                <asp:TextBox ID="TxtTypeName" runat="server" MaxLength="30"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrTypeName" runat="server" ControlToValidate="TxtTypeName"
                    Display="Dynamic" ErrorMessage="请指定送货方式名称" SetFocusOnError="True"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right">
                <b>送货方式简介：</b>
            </td>
            <td>
                <asp:TextBox ID="TxtIntro" runat="server" Width="213px" MaxLength="50" Height="43px"
                    TextMode="MultiLine"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right">
                <b>运费：</b>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlChargeType" runat="server" RepeatColumns="4" RepeatDirection="Horizontal"
                    Width="427px" AutoPostBack="True" OnSelectedIndexChanged="RadlChargeType_SelectedIndexChanged">
                    <asp:ListItem Selected="True" Value="0">免费</asp:ListItem>
                    <asp:ListItem Value="1">按重量计算运费</asp:ListItem>
                    <asp:ListItem Value="2">按订单金额的百分比计算运费</asp:ListItem>
                    <asp:ListItem Value="3">固定值</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tbody id="TbodyTaxRateSetting" runat="server">
            <tr class="tdbg">
                <td align="right">
                    <strong>税率设置：</strong>
                </td>
                <td>
                    <pec:TaxRateSetting ID="TaxRateSet" runat="server" />
                </td>
            </tr>
        </tbody>
        <tbody id="TbodyTaxRate" runat="server">
            <tr class="tdbg">
                <td align="right">
                    <strong>税率：</strong>
                </td>
                <td>
                    <asp:TextBox ID="TxtTaxRate" runat="server" Width="48px">0</asp:TextBox>%
                    <asp:RangeValidator ID="ValrTaxRate" runat="server" ControlToValidate="TxtTaxRate"
                        Display="Dynamic" ErrorMessage="请输入 0 ～ 100 的数值!" MaximumValue="100" MinimumValue="0"
                        SetFocusOnError="True" Type="Double"></asp:RangeValidator>
                </td>
            </tr>
        </tbody>
        <tbody id="TbodyFixMoney" runat="server" visible="false">
            <tr class="tdbg">
                <td align="right">
                    <strong>固定值：</strong>
                </td>
                <td>
                    <asp:TextBox ID="TxtFixMoney" runat="server" MaxLength="12"></asp:TextBox>
                    元
                    <asp:CompareValidator ID="ValcFixMoney" runat="server" ControlToValidate="TxtFixMoney"
                        Display="Dynamic" ErrorMessage="请输入非负的有效数值！" Operator="GreaterThanEqual" Type="Double"
                        ValueToCompare="0"></asp:CompareValidator>
                </td>
            </tr>
        </tbody>
        <tr class="tdbg">
            <td align="right">
                &nbsp;
            </td>
            <td>
                <asp:CheckBox ID="ChkIsDefault" runat="server" Text="设为默认送货方式" />
            </td>
        </tr>
    </table>
    <div id="div1" class="tdbg border" style="padding-right: 3px; padding-left: 3px;
        padding-bottom: 5px; padding-top: 5px;">
        <asp:Panel ID="PnlChargeType1" runat="server" Width="100%" Visible="False">
            <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border" id="ChargeSetting"
                style="margin-top: 5px;">
                <tr class="title">
                    <td colspan="2">
                        <b>同一城市间运费标准：</b>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>基本运费：</b>
                    </td>
                    <td style="width: 652px">
                        <asp:TextBox ID="TxtCharge_Min1" runat="server" Width="70px" MaxLength="10">8</asp:TextBox>
                        元
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>基本运费的起算重量：</b>
                    </td>
                    <td style="width: 652px">
                        <asp:TextBox ID="TxtWeight_Min1" runat="server" Width="70px" MaxLength="10">1</asp:TextBox>千克（Kg）<br />
                        当商品重量不超过上述指定起算重量时，实际运费按基本运费计算。
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>浮动运费：</b>
                    </td>
                    <td style="width: 652px">
                        当商品总重量超过基本运费的起算重量后，除了收取基本运费外，每<asp:TextBox ID="TxtWeightPerUnit1" runat="server"
                            Width="70px" MaxLength="10">1</asp:TextBox>
                        千克的商品增加运费
                        <asp:TextBox ID="TxtChargePerUnit1" runat="server" Width="70px" Rows="10">3</asp:TextBox>元
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>最高运费：</b>
                    </td>
                    <td style="width: 652px">
                        <asp:TextBox ID="TxtCharge_Max1" runat="server" Width="70px" MaxLength="10">100</asp:TextBox>元（当基本运费＋浮动运费超过最高运费时，实际运费按最高运费计算）
                    </td>
                </tr>
                <tr class="title">
                    <td colspan="2">
                        <b>同一区域间（比如珠江三角州、长江三角州等特别区域）的运费标准：</b>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>区域范围：</b>
                    </td>
                    <td style="width: 652px">
                        <asp:TextBox ID="TxtarrArea" runat="server" ReadOnly="true" Width="400px"></asp:TextBox>
                        <asp:HiddenField ID="HdnArrArea" runat="server" />
                        <input type="button" name="SelectArea" onclick="SelectCity()" value="选择城市" />
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>基本运费：</b>
                    </td>
                    <td style="width: 652px">
                        <asp:TextBox ID="TxtCharge_Min2" runat="server" Width="70px" MaxLength="10">10</asp:TextBox>元
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>基本运费的起算重量：</b>
                    </td>
                    <td style="width: 652px">
                        <asp:TextBox ID="TxtWeight_Min2" runat="server" Width="70px" MaxLength="10">1</asp:TextBox>千克（Kg）<br />
                        当商品重量不超过上述指定起算重量时，实际运费按基本运费计算。
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>浮动运费：</b>
                    </td>
                    <td style="width: 652px">
                        当商品总重量超过基本运费的起算重量后，除了收取基本运费外，每<asp:TextBox ID="TxtWeightPerUnit2" runat="server"
                            Width="70px" MaxLength="10">1</asp:TextBox>
                        千克的商品增加运费
                        <asp:TextBox ID="TxtChargePerUnit2" runat="server" Width="70px" MaxLength="10">5</asp:TextBox>元
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>最高运费：</b>
                    </td>
                    <td style="width: 652px">
                        <asp:TextBox ID="TxtCharge_Max2" runat="server" Width="70px" MaxLength="10">100</asp:TextBox>元（当基本运费＋浮动运费超过最高运费时，实际运费按最高运费计算）
                    </td>
                </tr>
                <tr class="title">
                    <td colspan="2">
                        <b>同一省份间运费标准：</b>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>基本运费：</b>
                    </td>
                    <td style="width: 652px">
                        <asp:TextBox ID="TxtCharge_Min3" runat="server" Width="70px" MaxLength="10">18</asp:TextBox>元
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>基本运费的起算重量：</b>
                    </td>
                    <td style="width: 652px">
                        <asp:TextBox ID="TxtWeight_Min3" runat="server" Width="70px" MaxLength="10">1</asp:TextBox>千克（Kg）<br />
                        当商品重量不超过上述指定起算重量时，实际运费按基本运费计算。
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>浮动运费：</b>
                    </td>
                    <td style="width: 652px">
                        当商品总重量超过基本运费的起算重量后，除了收取基本运费外，每<asp:TextBox ID="TxtWeightPerUnit3" runat="server"
                            Width="70px" MaxLength="10">1</asp:TextBox>
                        千克的商品增加运费<asp:TextBox ID="TxtChargePerUnit3" runat="server" Width="70px" MaxLength="10">15</asp:TextBox>
                        元
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>最高运费：</b>
                    </td>
                    <td style="width: 652px">
                        <asp:TextBox ID="TxtCharge_Max3" runat="server" Width="70px" MaxLength="10">100</asp:TextBox>元（当基本运费＋浮动运费超过最高运费时，实际运费按最高运费计算）
                    </td>
                </tr>
                <tr class="title">
                    <td colspan="2">
                        <b>外省运费标准：</b>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td colspan="2">
                        外省运费标准较复杂，不同省份运费标准可能会不同，如新疆、西藏、内蒙古的运费就与其他省份不同。因此需要根据不同省份来设置不同的运费标准。<br />
                        <asp:Panel ID="PnlAddCharge" runat="server" Width="100%" Visible="False">
                            <div style="overflow: auto; width: 100%; height: 200px; text-align: center" class="border">
                                <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                                    <ContentTemplate>
                                        <pe:ExtendedGridView ID="GdvAreaType4" runat="server" Width="98%" AutoGenerateColumns="False"
                                            DataKeyNames="Id,DeliverTypeId" EmptyDataText="目前没有任何外省运费标准" OnRowCommand="GdvAreaType4_RowCommand">
                                            <Columns>
                                                <pe:BoundField DataField="ArrArea" HeaderText="省份列表">
                                                    <ItemStyle HorizontalAlign="Left" />
                                                </pe:BoundField>
                                                <pe:BoundField DataField="ChargeMin" HeaderText="基本运费" DataFormatString="{0:C}" HtmlEncode="False">
                                                    <HeaderStyle Width="10%" />
                                                </pe:BoundField>
                                                <pe:BoundField DataField="WeightMin" HeaderText="起算重量" DataFormatString="{0:N2}Kg"
                                                    HtmlEncode="False">
                                                    <HeaderStyle Width="10%" />
                                                </pe:BoundField>
                                                <pe:BoundField DataField="ChargePerUnit" HeaderText="单位运费" DataFormatString="{0:C}"
                                                    HtmlEncode="False">
                                                    <HeaderStyle Width="10%" />
                                                </pe:BoundField>
                                                <pe:BoundField DataField="WeightPerUnit" HeaderText="单位重量" DataFormatString="{0:N2}Kg"
                                                    HtmlEncode="False">
                                                    <HeaderStyle Width="10%" />
                                                </pe:BoundField>
                                                <pe:BoundField DataField="ChargeMax" HeaderText="最高运费" DataFormatString="{0:C}" HtmlEncode="False">
                                                    <HeaderStyle Width="10%" />
                                                </pe:BoundField>
                                                <pe:TemplateField HeaderText="操作">
                                                    <ItemTemplate>
                                                        <span style="cursor: pointer" onclick="JavaScript:window.open('DeliverCharge.aspx?Id=<%# Eval("Id").ToString()%>&Action=Modify','window','width=640,height=380')">
                                                            修改</span>
                                                        <asp:LinkButton ID="LbtnDelete" runat="server" CommandArgument='<%# Eval("Id") %>'
                                                            CommandName="Del" OnClientClick="return confirm('确定要删除此运费标准吗?')">删除</asp:LinkButton>
                                                    </ItemTemplate>
                                                    <HeaderStyle Width="10%" />
                                                </pe:TemplateField>
                                            </Columns>
                                            <HeaderStyle CssClass="tdbg2" Font-Bold="False" />
                                        </pe:ExtendedGridView>
                                    </ContentTemplate>
                                </asp:UpdatePanel>
                                <div style="text-align: left; width: 95%">
                                    <table border="0" cellpadding="0" cellspacing="0" style="width: 100%">
                                        <tr>
                                            <td>
                                                <asp:Label ID="LblChargeMsg1" runat="server" Font-Bold="True" Text="还有以下省份没有设定运费标准："></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <asp:Label ID="LblChargeMsg2" runat="server"></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="text-align: center">
                                                <asp:UpdatePanel runat="server" ID="Upnl">
                                                    <ContentTemplate>
                                                        <asp:Button ID="BtnAddAreaType4" runat="server" Text="添加外省运费标准" UseSubmitBehavior="False"
                                                            OnClick="BtnAddAreaType4_Click" />
                                                    </ContentTemplate>
                                                </asp:UpdatePanel>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </asp:Panel>
                        <pe:ExtendedLiteral HtmlEncode="false" ID="LtrShowStep" runat="server" Text="<strong>添加外省运费标准的步骤：<br /></strong>先完成当前送货方式的添加工作，再修改此送货方式，在修改时添加不同省份的运费标准。必须做此步，否则将按国际运费标准执行。" />
                    </td>
                </tr>
                <tr class="title">
                    <td colspan="2">
                        <b>国际运费标准：</b>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px; height: 27px;" align="right">
                        <b>基本运费：</b>
                    </td>
                    <td style="width: 652px; height: 27px;">
                        <asp:TextBox ID="TxtCharge_Min5" runat="server" MaxLength="10" Width="70px">50</asp:TextBox>元
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>基本运费的起算重量：</b>
                    </td>
                    <td style="width: 652px">
                        <asp:TextBox ID="TxtWeight_Min5" runat="server" MaxLength="10" Width="70px">1</asp:TextBox>千克（Kg）<br />
                        当商品重量不超过上述指定起算重量时，实际运费按基本运费计算。
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>浮动运费：</b>
                    </td>
                    <td style="width: 652px">
                        当商品总重量超过基本运费的起算重量后，除了收取基本运费外，每<asp:TextBox ID="TxtWeightPerUnit5" runat="server"
                            MaxLength="6" Width="70px">1</asp:TextBox>
                        千克的商品增加运费<asp:TextBox ID="TxtChargePerUnit5" runat="server" Width="70px">20</asp:TextBox>
                        元
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>最高运费：</b>
                    </td>
                    <td style="width: 652px">
                        <asp:TextBox ID="TxtCharge_Max5" runat="server" Width="70px" MaxLength="10">100</asp:TextBox>元（当基本运费＋浮动运费超过最高运费时，实际运费按最高运费计算）
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="PnlChargeType2" runat="server" Width="100%" Visible="False">
            <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border" id="ChargeSetting2">
                <tr class="title">
                    <td colspan="2">
                        <b>按订单金额的百分比计算运费标准：</b>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>基本运费：</b>
                    </td>
                    <td>
                        <asp:TextBox ID="TxtCharge_Min" runat="server" MaxLength="10" Width="70px">0</asp:TextBox>元
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>订单金额的百分比率：</b>
                    </td>
                    <td>
                        <asp:TextBox ID="TxtCharge_Percent" runat="server" MaxLength="10" Width="70px">0</asp:TextBox>%
                        <asp:CompareValidator ID="ValcChargePercent" runat="server" ControlToValidate="TxtCharge_Percent"
                            Display="Dynamic" ErrorMessage="请输入 0 ～ 100 的数值!！" Operator="GreaterThanEqual"
                            Type="Double" ValueToCompare="0"></asp:CompareValidator>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 150px" align="right">
                        <b>最高运费：</b>
                    </td>
                    <td>
                        <asp:TextBox ID="TxtCharge_Max" runat="server" MaxLength="10" Width="70px">100</asp:TextBox>元（当订单金额*百份比率+基本运费超过最高运费时，实际运费按最高运费计算）
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="PnlReleaseCharge" runat="server" Width="100%" Visible="False">
            <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border" id="ChargeSetting3">
                <tr class="title">
                    <td colspan="2">
                        <b>运费优惠标准：</b>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td colspan="2">
                        <asp:RadioButtonList ID="RadlReleaseType" runat="server">
                            <asp:ListItem Selected="True" Value="0">不实行任何优惠</asp:ListItem>
                            <asp:ListItem Value="1">实行下列优惠方式</asp:ListItem>
                        </asp:RadioButtonList>
                        &nbsp;<br />
                        &nbsp;&nbsp;&nbsp;&nbsp;①当订单总金额达到
                        <asp:TextBox ID="TxtMinMoney1" runat="server" MaxLength="10" Width="70px">1000</asp:TextBox>元时，免除
                        <asp:TextBox ID="TxtReleaseCharge" runat="server" MaxLength="10" Width="50px">10</asp:TextBox>
                        元运费（如果大于运费总额，则实际免除额为运费总额）<br />
                        &nbsp;&nbsp;&nbsp;&nbsp;②当订单总金额达到
                        <asp:TextBox ID="TxtMinMoney2" runat="server" MaxLength="10" Width="70px">5000</asp:TextBox>
                        元时，并且运费总额不超过
                        <asp:TextBox ID="TxtMaxCharge" runat="server" MaxLength="10" Width="50px">100</asp:TextBox>
                        元时，免除全部运费<br />
                        &nbsp;&nbsp;&nbsp;&nbsp;③当订单总金额达到
                        <asp:TextBox ID="TxtMinMoney3" runat="server" MaxLength="10" Width="70px">10000</asp:TextBox>元时，免除全部运费<br />
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <div style="width: 100%; text-align: center; padding-bottom: 10px; padding-top: 10px;">
            <pe:ExtendedButton IsChecked="true" OperateCode="DeliverTypeManage" ID="BtnSave"
                runat="server" Text="保存送货方式" OnClick="BtnSave_Click" UseSubmitBehavior="False" />
        </div>
    </div>

    <script type="text/javascript">
        function SelectCity() {
            window.open('CityList.aspx?OpenerText=<%=TxtarrArea.ClientID %>&OpenerText2=<%=HdnArrArea.ClientID %>', '', 'width=600,height=450,resizable=0,scrollbars=yes');

        }
    </script>

</asp:Content>
