﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.DeliverTypeManage" Title="送货方式管理" Codebehind="DeliverTypeManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider"
        AdditionalNode=" 所有送货方式" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="ExtendedGridView1" runat="server" AutoGenerateColumns="False"
        DataSourceID="OdsDeliverType" DataKeyNames="TypeId" OnRowCommand="ExtendedGridView1_RowCommand"
        SerialText="" OnRowDataBound="ExtendedGridView1_RowDataBound"
        RowDblclickBoundField="TypeId" RowDblclickUrl="DeliverType.aspx?Action=Modify&amp;TypeId={$Field}">
        <Columns>
            <pe:BoundField DataField="TypeId" HeaderText="ID" SortExpression="TypeId">
                <HeaderStyle Width="5%" />
            </pe:BoundField>
            <pe:BoundField DataField="TypeName" HeaderText="送货方式名称" SortExpression="TypeName"
                >
                <HeaderStyle Width="12%" />
            </pe:BoundField>
            <pe:BoundField DataField="Intro" HeaderText="送货方式简介" SortExpression="Intro"  />
            <pe:TemplateField HeaderText="计算方式" SortExpression="ChargeType">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%# GetChargeType(PowerEasy.Framework.Common.DataConverter.ToInt32(Eval("ChargeType")))%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="是否默认" SortExpression="IsDefault">
                <HeaderStyle Width="9%" />
                <ItemTemplate>
                    <%# (bool)Eval("IsDefault") == false ? "" : "√"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="已启用" SortExpression="IsDisabled">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <%# (bool)Eval("IsDisabled") != false ? "<font color=red>×</font>" : "√"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="常规操作">
                <HeaderStyle Width="20%" />
                <ItemTemplate>
                    <asp:LinkButton ID="LbtnDefault" runat="server" CommandArgument='<%# Bind("TypeId") %>'
                        CommandName="Default">设为默认</asp:LinkButton>
                    <asp:LinkButton ID="LbtnDisable" runat="server" CommandArgument='<%# Bind("TypeId") %>'
                        CommandName="Disable" Text='<%# (bool)Eval("IsDisabled") ? "启用" : "禁用" %>'></asp:LinkButton>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" OperateCode="DeliverTypeManage"
                        href='<%#Eval("TypeId","DeliverType.aspx?Action=Modify&TypeId={0}") %>'>修改</pe:ExtendedAnchor>
                    <asp:LinkButton ID="LbtnDelete" runat="server" CausesValidation="False" CommandArgument='<%# Eval("TypeId") %>'
                        CommandName="Delete">删除</asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="排序操作" SortExpression="OrderId">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <asp:DropDownList ID="DropOrderId" runat="server" AutoPostBack="True" DataSourceID="OdsDeliverType"
                        DataTextField="OrderId" DataValueField="OrderId" OnSelectedIndexChanged="DdlOrderId_SelectedIndexChanged"
                        SelectedValue='<%# Bind("OrderId") %>' Width="60px">
                    </asp:DropDownList>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <br />
    <div id="prompt-note">
	    <dl>
	    <dt class="prompt-note-tit">
	    <span>提示说明</span>
	    </dt>
	    <dd class="prompt-note-con">
		    说明：“禁用”某送货方式后，前台订购时将不再显示此送货方式，但已有订单中仍然显示。
	    </dd>  
	    </dl>
    </div>
    
    <asp:ObjectDataSource ID="OdsDeliverType" runat="server" DeleteMethod="Delete" SelectMethod="GetDeliverTypeList"
        TypeName="PowerEasy.Module.Shop.BusinessLogic.DeliverType">
        <DeleteParameters>
            <asp:Parameter Name="typeId" Type="Int32" />
        </DeleteParameters>
    </asp:ObjectDataSource>
</asp:Content>
