﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.GroupBuy"
    MasterPageFile="~/Admin/MasterPage.master" Title="团购添加/修改" ValidateRequest="false"
    CodeBehind="GroupBuy.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <pe:AlternateLiteral ID="AltrTitle" Text="添加团购" AlternateText="修改团购" runat="Server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                <b>团购商品：</b>
            </td>
            <td>
                <asp:UpdatePanel ID="UpdatePanel1" runat="server" OnLoad="UpdatePanel1_Load">
                    <ContentTemplate>
                        <asp:TextBox ID="TxtProductName" runat="server" MaxLength="30">
                        </asp:TextBox>
                        <pec:FloatingDialog ID="FdAddProduct" runat="server" Name="添加商品" BeginString="【"
                            EndString="】" Title="添加商品" Width="700" Height="450" LoadUrl="../Shop/ProductPicker.aspx"
                            Skin="floatingDialogFontSkin" />
                        <pe:RequiredFieldValidator ID="ValrProductName" runat="server" ControlToValidate="TxtProductName"
                            Display="Dynamic" ErrorMessage="请指定团购商品" SetFocusOnError="True"></pe:RequiredFieldValidator>
                        <asp:HiddenField ID="HdnProductId" runat="server" />
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                <b>折扣率：</b>
            </td>
            <td>
                <asp:TextBox ID="TxtDiscount" runat="server" MaxLength="20" Width="50" Text="90"></asp:TextBox>%
                <pe:RegexValidator ID="ValDiscount" ValidateType="Money" runat="server" ControlToValidate="TxtDiscount"
                    Display="Dynamic" ErrorMessage="请输入正确的数字！" SetFocusOnError="True"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                <b>截止日期：</b>
            </td>
            <td>
                <pe:DatePicker ID="DpkEndDate" runat="server" Width="150" IsLongDate="true" ></pe:DatePicker>
                <pe:RequiredFieldValidator ID="ValrEndDate" ControlToValidate="DpkEndDate" runat="server"
                    ErrorMessage="截止日期不能为空！" Display="Dynamic" RequiredText=""></pe:RequiredFieldValidator>
                <pe:RegexValidator ValidateType="Date" ID="VdateEndDate" runat="server" ControlToValidate="DpkEndDate"
                    Display="Dynamic" ErrorMessage="日期格式不正确！" SetFocusOnError="true" ValidationGroup="Vdate"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                <b>定金类型：</b>
            </td>
            <td>
                <asp:RadioButtonList ID="RadEarnestMoneyType" runat="server" RepeatDirection="Horizontal">
                    <asp:ListItem Value="0" Selected="True">百分比</asp:ListItem>
                    <asp:ListItem Value="1">指定资金</asp:ListItem>
                    <asp:ListItem Value="2">不需定金</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                <b>定金：</b>
            </td>
            <td>
                <asp:TextBox ID="TxtEarnestMoney" runat="server" MaxLength="30" Text="0"></asp:TextBox>
                <pe:RegexValidator ValidateType="Number" runat="server" ControlToValidate="TxtEarnestMoney"
                    Display="Dynamic" ErrorMessage="请输入正确的数字！" SetFocusOnError="True"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                <b>团购名称：</b>
            </td>
            <td>
                <asp:TextBox ID="TxtGroupBuyName" runat="server" Width="300" TextMode="Multiline" Height="50"></asp:TextBox>
                <pe:RequiredFieldValidator runat="server" ID="ValGroupBuyName" ControlToValidate="TxtGroupBuyName"
                    Display="Dynamic" ErrorMessage="请输入团购名称！" SetFocusOnError="True">
                </pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                <b>团购简介：</b>
            </td>
            <td>
                <pe:UEditor ID="GroupBuyIntroEditor" runat="server" Toolbar="Simple">
                </pe:UEditor>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft">
                <b>团购状态：</b>
            </td>
            <td>
                <asp:RadioButtonList ID="RadStatus" runat="server" RepeatDirection="Horizontal">
                    <asp:ListItem Value="0" Selected="True">未审核</asp:ListItem>
                    <asp:ListItem Value="1">审核</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
    </table>
    <asp:HiddenField ID="HdnID" runat="server" />
    <asp:HiddenField ID="HdnStartNum" runat="server" />
    <asp:HiddenField ID="HdnEndNum" runat="server" />
    <asp:HiddenField ID="HdnDiscount" runat="server" />
    <div style="width: 100%; text-align: center; padding-bottom: 10px; padding-top: 10px;">
        <asp:Button ID="EBtnSubmit" runat="server" Text=" 保 存 " OnClick="EBtnSubmit_Click" />
        <input name="Cancel" type="button" class="inputbutton" id="Cancel" value="取消" onclick="Redirect('GroupBuyManage.aspx')" />
    </div>
    <script type="text/javascript">
        function DoProductPickerPostBack(arrProductList) {
            __doPostBack('<%=UpdatePanel1.ClientID %>', arrProductList);
            CloseFloatingDialog();
        }
    </script>
</asp:Content>
