﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.GroupBuyManage"
    MasterPageFile="~/Admin/MasterPage.master" Title="团购添加/修改" ValidateRequest="false"
    Codebehind="GroupBuyManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
     <table border='0' cellpadding='0' cellspacing='1' width='100%' height='100%'>
      <tr>
        <td id="AdminTabs">
            <ul>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteALL" />>
                    <asp:LinkButton ID="LinkALL" runat="server"   CommandArgument="-1"
                        onclick="ShowBookmarks"><span>所有内容</span></asp:LinkButton>
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteUnaudited" />> 
                    <asp:LinkButton ID="LinkUnaudited" runat="server"  CommandArgument="0"
                        onclick="ShowBookmarks"><span>未审核</span></asp:LinkButton>  
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteAudit" />>    
                    <asp:LinkButton ID="LinkAudit" runat="server" CommandArgument="1"
                        onclick="ShowBookmarks"><span>已审核</span></asp:LinkButton> 
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="ExtendedFailure" />>
                    <asp:LinkButton ID="LinkFailure"  CommandArgument="2"  runat="server" 
                        onclick="ShowBookmarks"><span>已失败</span></asp:LinkButton>  
                </li>
                <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteSettle" />>
                    <asp:LinkButton ID="LinkSettle"  CommandArgument="3"  runat="server" 
                        onclick="ShowBookmarks"><span>已结清</span></asp:LinkButton>  
                </li>
            </ul>
          </td>
    </table>
    <pe:ExtendedGridView ID="EgvGroupBuy" runat="server" AllowPaging="True" AutoGenerateColumns="False"
        AutoGenerateCheckBoxColumn="True" DataKeyNames="ID" DataSourceID="OdsGroupBuy"
        ItemName="项目" ItemUnit="个" OnRowDataBound="EgvGroupBuy_RowDataBound" RowDblclickBoundField="Id"
         RowDblclickUrl="GroupBuy.aspx?Action=Modify&ID={$Field}">
        <Columns>
            <pe:BoundField DataField="ID" HeaderText="ID">
                <HeaderStyle Width="6%" />
            </pe:BoundField>
            <pe:BoundField DataField="GroupBuyName" HeaderText="团购名称">
                <HeaderStyle Width="15%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="团购商品" SortExpression="ProductName">
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                    <asp:Label ID="LblProductName" runat="server" Text=""></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="截止日期" SortExpression="EndDate">
                <HeaderStyle Width="6%" />
                <ItemTemplate>
                    <asp:Label ID="LblEndDate" runat="server" Text=""></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="状态" SortExpression="Status">
                <HeaderStyle Width="6%" />
                <ItemTemplate>
                    <pe:ExtendedLabel ID="LblStatus" runat="server" HtmlEncode="false"></pe:ExtendedLabel>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="20%" />
                <ItemTemplate>
                    <a id="EahGroupBuyEnabled" href='<%# AppendSecurityCode("GroupBuyManage.aspx?Action=runGroupBuy&ID=" + Eval("ID"))%>'
                        runat="server">通过审核</a> <a id="EahGroupBuyDisable" href='<%# AppendSecurityCode("GroupBuyManage.aspx?Action=disGroupBuy&ID=" + Eval("ID"))%>'
                            runat="server">取消审核</a> <a id="EahGroupBuyModify" href='<%# "GroupBuy.aspx?Action=Modify&ID=" + Eval("ID")%>'
                                runat="server">修改</a> <a id="EahGroupBuyDelete" href='<%# AppendSecurityCode("GroupBuyManage.aspx?Action=Delete&ID=" + Eval("ID"))%>'
                                    onclick="return confirm('是否删除该团购？');" runat="server">删除</a>
                    <a id="EahGroupBuyOrderList" href='<%# "OrderList.aspx?SearchType=101&KeyWord=" + Eval("ID")%>' runat="server">查看订单</a> 
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
	<asp:HiddenField ID="HdnStatus" runat="server" Value="-1" />
    <asp:ObjectDataSource ID="OdsGroupBuy" runat="server" SelectMethod="GetGroupBuyList"
        SelectCountMethod="GetCountNumber" TypeName="PowerEasy.Module.Shop.BusinessLogic.GroupBuy"
        EnablePaging="True" StartRowIndexParameterName="startRowIndexId"
        MaximumRowsParameterName="maxNumberRows" OldValuesParameterFormatString="original_{0}">
        <SelectParameters>
		    <asp:QueryStringParameter Name="searchType" QueryStringField="SearchType" Type="int32" />
            <asp:QueryStringParameter Name="keyword" QueryStringField="Keyword" Type="string" />
			<asp:ControlParameter ControlID="HdnStatus" Type="Int32" Name="status" PropertyName="Value" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" />选中本页显示的所有团购
    &nbsp;&nbsp;
    <asp:Button ID="EBtnBatchDelete" Text="删除选中的团购" OnClientClick="return batchconfirm('是否要删除团购？');"
        OnClick="EBtnBatchDelete_Click" CausesValidation="False" runat="server" />
    <asp:Button ID="EBtnBatchEnable" Text="批量审核选中的团购" OnClientClick="return batchconfirm('是否要通过审核团购？');"
        OnClick="EBtnBatchEnable_Click" CausesValidation="False" runat="server" />
    <asp:Button ID="EBtnBatchDisable" Text="批量取消审核选中的团购" OnClientClick="return batchconfirm('是否要取消审核团购？');"
        OnClick="EBtnBatchDisable_Click" CausesValidation="False" runat="server" />
</asp:Content>
