﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.InvoiceAdd" Title="录入发票信息" Codebehind="InvoiceAdd.aspx.cs" Async="true" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>发票信息</b>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                客户名称：</td>
            <td>
                <asp:Label ID="LblClientName" runat="server"></asp:Label>
                <asp:HiddenField ID="HdnClientId" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft" style="width: 15%">
                用户名：
            </td>
            <td>
                <asp:Label ID="LblUserName" runat="server"></asp:Label>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                订单编号：</td>
            <td>
                <asp:Label ID="LblOrderNum" runat="server"></asp:Label>
                <asp:HiddenField ID="HdnOrderId" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                订单金额：</td>
            <td>
                <asp:Label ID="LblMoneyTotal" runat="server"></asp:Label>元</td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                已 付 款：</td>
            <td>
                <asp:Label ID="LblMoneyReceipt" runat="server"></asp:Label>元</td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                开票日期：</td>
            <td>
                <pe:DatePicker ID="DpkInvoiceDate" runat="server"></pe:DatePicker>
                <pe:RequiredFieldValidator ID="ValrInvoiceDate" runat="server" ControlToValidate="DpkInvoiceDate"
                    ErrorMessage="请输入开票日期" Display="Dynamic" SetFocusOnError="True"></pe:RequiredFieldValidator><pe:RegexValidator ValidateType="Date"
                        ID="VdateInvoiceDate" ControlToValidate="DpkInvoiceDate" runat="server" Display="Dynamic"
                        SetFocusOnError="True"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%; height: 27px;" class="tdbgleft" align="right">
                发票类型：</td>
            <td>
                <asp:DropDownList ID="DropInvoiceType" Width="100px" runat="server">
                    <asp:ListItem Selected="True" Value="0">地税普通发票</asp:ListItem>
                    <asp:ListItem Value="1">国税普通发票</asp:ListItem>
                    <asp:ListItem Value="2">增值税发票</asp:ListItem>
                </asp:DropDownList>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                发票号码：</td>
            <td>
                <asp:TextBox ID="TxtInvoiceNum" runat="server" Width="100px" MaxLength="50"></asp:TextBox></td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                发票抬头：</td>
            <td>
                <asp:TextBox Width="350px" ID="TxtInvoiceTitle" runat="server" MaxLength="50"></asp:TextBox></td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                发票内容：</td>
            <td>
                <asp:TextBox ID="TxtInvoiceContent" runat="server" Width="400px" Columns="50" Height="60px"
                    Rows="4" TextMode="MultiLine"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                发票金额：</td>
            <td>
                <asp:TextBox ID="TxtTotalMoney" runat="server" Width="100px" MaxLength="50"></asp:TextBox>元
                <pe:RequiredFieldValidator ID="ValrTotalMoney" SetFocusOnError="true" runat="server"
                    ErrorMessage="请输入发票总金额！" ControlToValidate="TxtTotalMoney" Display="Dynamic"></pe:RequiredFieldValidator>
                <asp:RegularExpressionValidator runat="server" ID="ValeTotalMoney" ControlToValidate="TxtTotalMoney" ErrorMessage="请输入正确的发票总金额！" SetFocusOnError="True" Display="Dynamic" ValidationExpression="^(-?)[1-9]+[0-9]*(\.?[0-9]+)?|0\.0*[1-9]+0*|[1-9]$" ></asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                开 票 人：</td>
            <td>
                <asp:TextBox ID="TxtDrawer" runat="server" Width="100px" MaxLength="50"></asp:TextBox></td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                内部记录：</td>
            <td>
                <asp:TextBox ID="TxtMemo" runat="server" Width="400px" Columns="50" Height="60px"
                    Rows="4" TextMode="MultiLine"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                通知会员：</td>
            <td>
                <pec:SendMessageOfOrder ID="SendMessageOfOrder1" Description="已经开具发票" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td colspan="2" style="text-align: center">
                <asp:HiddenField ID="HdnAdminName" runat="server" />
                <pe:ExtendedButton IsChecked="true" OperateCode="OrderInvoice" ID="BtnSaveInvoice"
                    runat="server" OnClientClick="javascript:Page_ClientValidate();if(Page_IsValid){return confirm('确定录入的发票信息都正确无误了吗？');}"
                    Text="保　存" OnClick="BtnSaveInvoice_Click" />
                <asp:Button ID="BtnReturn" runat="server" Text="取消" CausesValidation="false" OnClick="BtnReturn_Click" />
            </td>
        </tr>
    </table>
</asp:Content>
