﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.InvoiceItemList" Title="发票记录管理" Codebehind="InvoiceItemList.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
<table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
  <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitAll" />>
                         <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="0"
                             onclick="ShowBookmarks"><span>所有</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="Litds" />>
                         <asp:LinkButton ID="Linkds" runat="server" CommandArgument="3"
                             onclick="ShowBookmarks"><span>地税普通发票</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="Litpf" />>    
                        <asp:LinkButton ID="Linkpf" runat="server" CommandArgument="4"
                             onclick="ShowBookmarks"><span>国税普通发票</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="Litzf" />>    
                        <asp:LinkButton ID="Linkzf" runat="server" CommandArgument="5"
                             onclick="ShowBookmarks"><span>国税增值税发票</span></asp:LinkButton>
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="EgvInvoice" runat="server" AutoGenerateColumns="False" AllowPaging="True"
        DataSourceID="OdsInvoice" CheckBoxFieldHeaderWidth="3%" SerialText=""
        RowDblclickBoundField="InvoiceId" RowDblclickUrl="InvoiceItemDetail.aspx?InvoiceID={$Field}">
        <Columns>
            <pe:BoundField DataField="InvoiceDate" HeaderText="日期" DataFormatString="{0:yyyy-MM-dd}"
                SortExpression="InvoiceDate" HtmlEncode="False">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="客户名称" SortExpression="ClientName">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" operateCode="ClientView" href='<%#string.Format("../Crm/ClientShow.aspx?ClientID={0}",Eval("ClientId")) %>'>
                        <%# Eval("ClientName") %>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="用户名" SortExpression="UserName">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" operateCode="UserView" href='<%# "../User/UserShow.aspx?Action=Show&UserName="+Server.UrlEncode(Convert.ToString(Eval("UserName"))) %>'>
                        <%# Eval("UserName") %>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="订单编号" SortExpression="OrderNum">
                <HeaderStyle Width="12%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" OperateCode="OrderView" href='<%#string.Format("../Shop/OrderManage.aspx?OrderID={0}",Eval("OrderId")) %>'>
                        <%# Eval("OrderNum") %>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="发票类型" SortExpression="InvoiceType">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%#GetInvoiceType(Convert.ToInt32(Eval("InvoiceType")))%>
                </ItemTemplate>
            </pe:TemplateField>
            <asp:HyperLinkField DataNavigateUrlFormatString="InvoiceItemDetail.aspx?InvoiceID={0}"
                DataNavigateUrlFields="InvoiceId" DataTextField="InvoiceNum" HeaderText="发票号码">
                <headerstyle width="8%" />
            </asp:HyperLinkField>
            <pe:BoundField DataField="InvoiceTitle" HeaderText="发票抬头">
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle Width="12%" />
            </pe:BoundField>
            <pe:BoundField DataField="TotalMoney" HeaderText="发票金额" DataFormatString="{0:N2}"
                HtmlEncode="False" SortExpression="TotalMoney">
                <ItemStyle HorizontalAlign="Right" />
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="操作人">
                <HeaderStyle Width="6%" />
                <ItemTemplate>
                    <%# Eval("Inputer")%>
                </ItemTemplate>
            </pe:TemplateField>
             <pe:TemplateField HeaderText="开票人">
                <HeaderStyle Width="6%" />
                <ItemTemplate>
                    <%# Eval("Drawer")%>
                </ItemTemplate>
            </pe:TemplateField>
            <asp:HyperLinkField DataNavigateUrlFormatString="InvoiceItemDetail.aspx?InvoiceID={0}"
                DataNavigateUrlFields="InvoiceId" HeaderText="操作" Text="查看">
                <headerstyle width="5%" />
            </asp:HyperLinkField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:HiddenField ID="HdnType" runat="server" Value="0" />
    <asp:ObjectDataSource ID="OdsInvoice" runat="server" SelectCountMethod="GetTotalOfInvoiceItem"
        SelectMethod="GetList" TypeName="PowerEasy.Module.Shop.BusinessLogic.Invoice" EnablePaging="True"
        StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:QueryStringParameter Name="searchType" QueryStringField="SearchType" Type="String" />
            <asp:QueryStringParameter Name="keyword" QueryStringField="KeyWord" Type="String" />
            <asp:QueryStringParameter Name="quickSearch" QueryStringField="QuickSearch" Type="String" />
            <asp:ControlParameter ControlID="HdnType" Type="Int32" Name="type" PropertyName="Value" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
