﻿<%@ Page Language="C#" MasterPageFile="~/Admin/Guide.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.InvoiceItemListGuide" Codebehind="InvoiceItemListGuide.aspx.cs"
    Title="开发票记录查询向导" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphTitle" runat="Server">
    开发票记录查询
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphSubMenu" runat="Server">
    <div class="guideexpand" onclick="Switch(this)">
        快速查找</div>
    <div class="guide">
        <ul>
            <li><a href="InvoiceItemList.aspx" target="main_right">开发票记录</a></li>
            <li><a href="InvoiceItemList.aspx?QuickSearch=1" target="main_right">最近10天内的新记录</a></li>
            <li><a href="InvoiceItemList.aspx?QuickSearch=2" target="main_right">最近一月内的新记录</a></li>
        </ul>
    </div>
    <div class="guideexpand" onclick="Switch(this)">
        高级查询</div>
    <div class="guidesearch">
        <ul>
            <li>
                <select id="SelField" style="width: 140px">
                    <option value="1">客户名称</option>
                    <option value="2">开票人</option>
                    <option value="3">发票日期</option>
                    <option value="6">发票抬头</option>
                </select>
            </li>
            <li>
                <input id="TxtKeyWord" style="width: 134px;" type="text" class="inputtext" />
            </li>
            <li>
                <input id="BtnSearch" type="button" class="inputbutton" value="查询" onclick="OpenMainRight()" />
            </li>
        </ul>
    </div>

    <script type="text/javascript">
    function OpenMainRight()
    {
        var field=0;
        var keyword = document.getElementById("TxtKeyWord").value.trim();
        if (keyword == "") {
            alert("请输入查询关键字！");
            return;
         }
        var objSel = document.getElementById("SelField");
        field = objSel.options[objSel.options.selectedIndex].value;
        if (field == "3" && !isDate(keyword)) {
            alert("请输入有效日期，日期格式如：YYYY-MM-DD");
            return;            
         }
        var url = "InvoiceItemList.aspx?SearchType="+field+"&KeyWord="+escape(keyword);
        JumpToMainRight(url);
    }
    </script>

</asp:Content>
