﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="MemberOrderliness.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.MemberOrderliness"
    Title="会员购物规律分析" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table class="border" cellpadding="1" cellspacing="1" width="100%">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>按时间统计会员购物规律分析数据</b>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbg" style="width: 30%" align="right">
                <b>会员名称：</b>
            </td>
            <td class="tdbg">
                <asp:TextBox runat="server" ID="TxtMemberName"></asp:TextBox>
                <pe:RequiredFieldValidator ID="RfvMemberName" runat="server" ControlToValidate="TxtMemberName" Display="Dynamic" ErrorMessage="会员名称不能为空"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbg" style="width: 30%" align="right">
                <b>统计时间：</b>
            </td>
            <td class="tdbg">
                <pec:StatisticalTime ID="PECStatisticalTime" runat="server" IsLeftAlign="true" DateType="1" DefaultBeginDateYear="-1" IsAutoPostBack="false" OnSearchButtonOnClick="PECStatisticalTime_OnSearchButtonOnClick" PostBackUrl="~/Admin/Shop/MemberOrderliness.aspx" />
            </td>
        </tr>
    </table>
    <br />
    <div style="text-align: center; font-size: large;">
        <asp:Label ID="LblTitle" runat="server"></asp:Label></div>
    <pe:ExtendedGridView AllowPaging="true" ID="EgvMemberOrderliness" runat="server"
        AutoGenerateColumns="false" DataSourceID="OdsMemberOrderliness">
        <Columns>
            <pe:BoundField HeaderText="商品名称" DataField="ProductName">
            </pe:BoundField>
            <pe:BoundField HeaderText="购买数量" ItemStyle-HorizontalAlign="Right" DataField="Amount">
            </pe:BoundField>
            <pe:BoundField HeaderText="金 额" ItemStyle-HorizontalAlign="Right" DataField="SubTotal"
                DataFormatString="{0:N2}" HtmlEncode="false">
            </pe:BoundField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsMemberOrderliness" runat="server" SelectCountMethod="GetTotalOfMemberOrderliness"
        SelectMethod="GetMemberOrderlinessList" TypeName="PowerEasy.Module.Shop.BusinessLogic.MemberOrderliness"
        EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:QueryStringParameter Name="userName" QueryStringField="UserName" Type="String" />
            <asp:QueryStringParameter Name="isAll" QueryStringField="IsAll" Type="Boolean" DefaultValue="true" />
            <asp:QueryStringParameter Name="beginDate" QueryStringField="BeginDate" Type="DateTime" />
            <asp:QueryStringParameter Name="endDate" QueryStringField="EndDate" Type="DateTime" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
