﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="MemberOrders.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.MemberOrders"
    Title="会员订单量排名" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table class="border" cellpadding="1" cellspacing="1" width="100%">
        <tr align="center">
            <td class="spacingtitle">
                <b>按时间统计会员订单排名数据</b>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbg" align="center">
                <pec:StatisticalTime ID="PECStatisticalTime" runat="server" DateType="1"  DefaultBeginDateYear="-1" IsAutoPostBack="false" OnSearchButtonOnClick="PECStatisticalTime_OnSearchButtonOnClick" />
            </td>
        </tr>
    </table>
    <br />
    <div style="text-align: center; font-size: large;">
        <asp:Label ID="LblTitle" runat="server" Text="会员订单排名"></asp:Label>
    </div>
    <pe:ExtendedGridView AllowPaging="true" ID="EgvMemberOrders" runat="server" AutoGenerateColumns="false"
        AutoGenerateSerialColumn="true" SerialText="订单排名" DataSourceID="OdsMemberOrders" OnRowDataBound="EgvMemberOrders_OnRowDataBound">
        <Columns>
            <pe:TemplateField HeaderText="会员名称">
                <ItemTemplate>
                    <asp:HyperLink runat="server" ID="HyplMemberName"></asp:HyperLink>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField HeaderText="订单数量" ItemStyle-HorizontalAlign="Right" DataField="OrderNum">
            </pe:BoundField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsMemberOrders" runat="server" SelectCountMethod="GetTotalOfMemberOrders"
        SelectMethod="GetMemberOrdersList" TypeName="PowerEasy.Module.Shop.BusinessLogic.MemberOrders"
        EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:Parameter Name="isAll" Type="Boolean" DefaultValue="true"/>
            <asp:Parameter Name="beginDate" Type="DateTime" />
            <asp:Parameter Name="endDate" Type="DateTime" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
