﻿<%@ Page Language="C#" ValidateRequest="false" MasterPageFile="~/Admin/MasterPage.master"
    AutoEventWireup="true" CodeBehind="OrderAdd.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.OrderAdd"
    Title="添加普通商品订单" EnableEventValidation="false" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <asp:ScriptManager ID="SmgeRegion" runat="server" EnablePartialRendering="true">
    </asp:ScriptManager>

    <script type="text/javascript">

        function DoPostBack(username) {
            __doPostBack("AddUserButton", username);
        }
        
    </script>

    <table border="0" cellpadding="2" cellspacing="1" class="border" width="100%">
        <tr align="center">
            <td class="spacingtitle" colspan="2">
                <asp:Label ID="LblTitle" runat="server" Text="添加普通商品订单" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 30%; text-align: right">
                订单用户：
            </td>
            <td>
                <asp:TextBox ID="TxtUserName" runat="server"></asp:TextBox>
                <pec:FloatingDialog ID="FdSelectUser" runat="server" Width="670" Height="400" Name="会员列表"
                    BeginString="&lt;=【" EndString="】" Skin="floatingDialogFontSkin" Title="会员列表"
                    LoadUrl="../User/UserNameList.aspx?Select=single" />
                <pe:RequiredFieldValidator ID="ValrUserName" ControlToValidate="TxtUserName" runat="server"
                    SetFocusOnError="true" Display="dynamic" ErrorMessage="请输入订单用户！"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 30%; text-align: right">
                收货人姓名：
            </td>
            <td>
                <asp:TextBox ID="TxtContacterName" runat="server"></asp:TextBox>
                <pec:FloatingDialog ID="FdAddress" runat="server" Width="600" Height="450" Name="收货人列表"
                    BeginString="&lt;=【" EndString="】" Skin="floatingDialogFontSkin" Title="收货人列表"
                    Visible="false" />
                <pe:RequiredFieldValidator ID="ValrContacterName" ControlToValidate="TxtContacterName"
                    runat="server" SetFocusOnError="true" Display="dynamic" ErrorMessage="请输入收货人姓名！"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 30%; text-align: right">
                收货人地址：
            </td>
            <td>
                <pec:AddressPicker ID="AddressPick" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 30%; text-align: right">
                收货人邮编：
            </td>
            <td>
                <asp:UpdatePanel ID="UpnlZipCode" runat="server" UpdateMode="Conditional">
                    <ContentTemplate>
                        <asp:TextBox ID="TxtZipCode" runat="server"></asp:TextBox>
                        <pe:RegexValidator ValidateType="ZipCode" ID="VzipZipCode" ControlToValidate="TxtZipCode"
                            Display="dynamic" SetFocusOnError="true" runat="server"></pe:RegexValidator>
                        <pe:RequiredFieldValidator ID="ValrZipCode" ShowRequiredText="false" ControlToValidate="TxtZipCode"
                            runat="server" SetFocusOnError="true" Display="Dynamic" ErrorMessage="请输入收货人邮编！"></pe:RequiredFieldValidator>
                    </ContentTemplate>
                    <Triggers>
                        <asp:AsyncPostBackTrigger ControlID="AddressPick" EventName="AddressChanged" />
                    </Triggers>
                </asp:UpdatePanel>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 30%; text-align: right">
                收货人电话：
            </td>
            <td>
                <asp:TextBox ID="TxtPhone" runat="server"></asp:TextBox>
                <pe:RegexValidator ValidateType="Mobile" ID="VtelPhone" ControlToValidate="TxtPhone"
                    SetFocusOnError="true" Display="dynamic" ErrorMessage="收货人电话格式不正确" runat="server"></pe:RegexValidator>
                <asp:CustomValidator ID="ValxPhone" ClientValidationFunction="ValxPhone_ClientValidate"
                    Display="dynamic" ValidateEmptyText="true" SetFocusOnError="true" runat="server"
                    ErrorMessage="至少要输入收货人电话和收货人手机中的一个" OnServerValidate="ValxPhone_ServerValidate"
                    ControlToValidate="TxtPhone"></asp:CustomValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 30%; text-align: right">
                收货人邮箱：
            </td>
            <td>
                <asp:TextBox ID="TxtEmail" runat="server"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValfEmail" ControlToValidate="TxtEmail" runat="server"
                    SetFocusOnError="true" Display="dynamic" ErrorMessage="请输入收货人邮箱！"></pe:RequiredFieldValidator><pe:RegexValidator
                        ValidateType="Email" ID="VmailEmail" Display="dynamic" SetFocusOnError="true"
                        ControlToValidate="TxtEmail" runat="server"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 30%; text-align: right">
                收货人手机：
            </td>
            <td>
                <asp:TextBox ID="TxtMobile" runat="server"></asp:TextBox>
                <pe:RegexValidator ValidateType="Mobile" ID="VmblMobile" ControlToValidate="TxtMobile"
                    Display="dynamic" SetFocusOnError="true" ErrorMessage="收货人手机格式不正确" runat="server"></pe:RegexValidator>
            </td>
        </tr>
        <tr runat="server" id="TdAgent" class="tdbg">
            <td class="tdbgleft" style="width: 30%; text-align: right">
                代理商：
            </td>
            <td>
                <pec:SelectAgent ID="SelectAgent1" runat="server"></pec:SelectAgent>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 30%; text-align: right">
                送货方式：
            </td>
            <td>
                <asp:UpdatePanel ID="UpnlDeliverType" UpdateMode="Conditional" runat="server">
                    <ContentTemplate>
                        <asp:DropDownList ID="DropDeliverType" DataTextField="TypeName" AutoPostBack="true"
                            DataValueField="TypeId" runat="server" OnSelectedIndexChanged="DropDeliverType_SelectedIndexChanged">
                        </asp:DropDownList>
                        &nbsp;&nbsp;<%= IsCreditProductOrder ? "注意：积分商品订单只能使用默认的送货方式" :"" %><br />
                        <asp:Label ID="LblDeliverTypeIntro" runat="server"></asp:Label>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
        <tr class="tdbg" runat="server" id="TdPaymentType">
            <td class="tdbgleft" style="width: 30%; text-align: right">
                付款方式：
            </td>
            <td>
                <asp:UpdatePanel ID="UpnlPaymentType" UpdateMode="Conditional" runat="server">
                    <ContentTemplate>
                        <table width="100%" class="border" cellspacing="1" cellpadding="2">
                            <tr class="tdbg">
                                <td>
                                    <asp:DropDownList ID="DropPaymentType" DataTextField="TypeName" DataValueField="TypeId"
                                        AutoPostBack="true" OnSelectedIndexChanged="DropPaymentType_SelectedIndexChanged"
                                        runat="server">
                                    </asp:DropDownList>
                                </td>
                            </tr>
                            <tr class="tdbg">
                                <td>
                                    <asp:Label ID="LblPaymentTypeIntro" runat="server"></asp:Label>
                                </td>
                            </tr>
                        </table>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
        <tr class="tdbg" runat="server" id="TdInvoice">
            <td class="tdbgleft" style="width: 30%; text-align: right">
                发票信息：
            </td>
            <td>
                <asp:TextBox ID="TxtInvoiceContent" Text="发票抬头： 
商品名称： 
发票金额： 元" TextMode="MultiLine" Height="40px" runat="server" Width="250px"></asp:TextBox>
                <asp:CheckBox ID="ChkNeedInvoice" runat="server" Text="需要发票" />
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft" style="height: 25px">
                跟单员：
            </td>
            <td style="height: 25px">
                   <asp:TextBox ID="TxtAuthor" runat="server" CssClass="inputxt" MaxLength="255"></asp:TextBox>
                   <pe:FloatDivDialog ID="FAuthor" runat="server" BeginString="【" EndString="】" Height="450" Width="650" CloseText="关闭" Name="选择跟单员" Skin="floatingDialogFontSkin"  Title="选择跟单员" ButtonWidth="80"  ></pe:FloatDivDialog>

            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 30%; text-align: right">
                内部记录：
            </td>
            <td>
                <asp:TextBox ID="TxtMemo" TextMode="MultiLine" Height="50px" runat="server" Width="250px"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td colspan="2">
                <asp:UpdatePanel ID="UpnlOrderOption" runat="server" UpdateMode="Conditional">
                    <Triggers>
                        <asp:AsyncPostBackTrigger ControlID="RepModel" />
                    </Triggers>
                    <ContentTemplate>
                        <table cellpadding="2" cellspacing="1" style="width: 98%; background-color: white;">
                            <asp:Repeater ID="RepModel" runat="server" OnItemDataBound="RepModel_OnItemDataBound">
                                <ItemTemplate>
                                    <tr id='Tab' runat="server" class='tdbg'>
                                        <td class='tdbgleft' align='right' style="width: 30%;">
                                            <div class="DivWordBreak">
                                                <%# Eval("FieldAlias")%>
                                                ：&nbsp;<br />
                                                <%# Eval("Tips") %>
                                            </div>
                                        </td>
                                        <td class='tdbg' align='left'>
                                            <pe:AdminFieldControl ID="Field" runat="server" EnableNull='<%# (bool)Eval("EnableNull") %>'
                                                FieldAlias='<%# Eval("FieldAlias")%>' Tips='<%# Eval("Tips") %>' FieldName='<%#Eval("FieldName")%>'
                                                ControlType='<%# Eval("FieldType") %>' FieldLevel='<%# Eval("FieldLevel") %>'
                                                Description='<%# Eval("Description")%>' Settings='<%# ((PowerEasy.Module.General.Model.CommonModel.FieldInfo)Container.DataItem).Settings %>'
                                                Value='<%# Eval("DefaultValue") %>'>
                                            </pe:AdminFieldControl>
                                        </td>
                                    </tr>
                                </ItemTemplate>
                            </asp:Repeater>
                        </table>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
        <tr class="tdbgbottom">
            <td colspan="2">
                <asp:HiddenField ID="HdnAdminName" runat="server" />
                <asp:HiddenField ID="HdnFunctionary" runat="server" />
                <pe:ExtendedButton IsChecked="true" OperateCode="OrderAdd" ID="BtnAdd" runat="server"
                    Text="下一步" OnClick="BtnAdd_Click" />&nbsp;&nbsp;&nbsp;
                <asp:Button ID="BtnCancel" runat="server" CausesValidation="false" OnClick="BtnCancel_Click"
                    Text="取  消" />
            </td>
        </tr>
    </table>

    <script language="javascript" type="text/javascript">
        function ValxPhone_ClientValidate(s, e) {
            var phone = document.getElementById('<%=TxtPhone.ClientID %>').value;
            var mobile = document.getElementById('<%=TxtMobile.ClientID %>').value;
            if (phone == "" && mobile == "") {
                e.IsValid = false;
            }
            else {
                e.IsValid = true;
            }
        }
    </script>

</asp:Content>
