﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true" CodeBehind="OrderFeedbackManage.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.OrderFeedbackManage" Title="订单反馈管理" %>
<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
  <tr>
            <td id="AdminTabs">
                <ul>
                    <!-- CSS Tabs -->
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitAllFeedBack" />>
                        <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="0" onclick="ShowBookmarks"><span>所有反馈</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitUnFeedBack" />> 
                        <asp:LinkButton ID="LinkUnFeedBack" runat="server" CommandArgument="1" onclick="ShowBookmarks"><span>未回复</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitFeedBack" />>    
                       <asp:LinkButton ID="LinkFeedBack" runat="server" CommandArgument="2" onclick="ShowBookmarks"><span>已回复</span></asp:LinkButton>
                    </li>
                </ul>
            </td>
        </tr>
    </table>
    <pe:ExtendedGridView ID="EgvFeedback" runat="server" AutoGenerateColumns="False" AutoGenerateCheckBoxColumn="false" DataSourceID="OdsFeedback"
        EmptyDataText="没有反馈记录" SerialText="" OnRowCommand="EgvFeedback_RowCommand" AllowPaging="True" OnRowDataBound="EgvFeedback_RowDataBound" CssClass="TableWrap">
        <Columns> 
            <pe:TemplateField HeaderText="订单编号">
                <HeaderStyle Width="16%" />
                <ItemTemplate>
                    <asp:HyperLink ID="LnkOrderNum" runat="server"></asp:HyperLink>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField HeaderText="时间" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                <HeaderStyle Width="16%" />
            </pe:BoundField> 
            <pe:TemplateField HeaderText="用户名">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <asp:HyperLink ID="LnkUserName" runat="server"></asp:HyperLink>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="客户名称">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                     <pe:ExtendedLabel ID="LblClientName" runat="server" HtmlEncode="false"></pe:ExtendedLabel>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="内容">
                <ItemStyle CssClass="TdWrap" />
                <ItemStyle HorizontalAlign="Left" />
                <ItemTemplate>
                    <pe:ExtendedLabel ID="LblContent" runat="server" ></pe:ExtendedLabel>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="已回复">
                <HeaderStyle Width="7%" />
            </pe:TemplateField>
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="16%" />
                <ItemTemplate>
                        <asp:LinkButton ID="LbtnReply" runat="server" Text="回复" CommandName="ReplyContent"></asp:LinkButton>
                        <asp:LinkButton ID="LbtnModify" runat="server" Text="修改" CommandName="Modify" Visible="false"></asp:LinkButton>
                        <asp:LinkButton ID="LbtnShow" runat="server" Text="查看" CommandName="Show"></asp:LinkButton>
                        <asp:LinkButton ID="LbtnDelFeedback" runat="server" Text="删除" CommandName="Del"></asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
     <asp:HiddenField ID="HdnType" runat="server" Value="0" />
    <asp:ObjectDataSource ID="OdsFeedback" runat="server" SelectCountMethod="TotalOfOrderFeedbackDetail"
        SelectMethod="GetList" TypeName="PowerEasy.Module.Shop.BusinessLogic.OrderFeedback" EnablePaging="True"
        StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:QueryStringParameter Name="searchType" QueryStringField="SearchType" Type="int32" />
            <asp:QueryStringParameter Name="keyword" QueryStringField="KeyWord" Type="String" />
            <asp:ControlParameter ControlID="HdnType" Type="Int32" Name="types" PropertyName="Value" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
