﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.OrderModify" CodeBehind="OrderModify.aspx.cs"
    ValidateRequest="false" Title="订单修改" EnableEventValidation="false" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <asp:ScriptManager ID="SmgePayment" runat="server" ScriptMode="Inherit">
    </asp:ScriptManager>
    <script language="javascript" type="text/javascript">

        function DoProductPickerPostBack(arrProductList) {
            try {
                __doPostBack('<%=UpdatePanel2.ClientID %>', arrProductList);
                CloseFloatDiaglog();
            } catch (e) {
                Sys.Debug.traceDump(e.message);
            }
        }

        function BatchAddCrieditProducts(arrProductList) {
            try {
                __doPostBack('<%=UplCreditProduct.ClientID %>', arrProductList);
                CloseFloatDiaglog();
            } catch (e) {
                Sys.Debug.traceDump(e.message);
            }
        }

        function CloseFloatDiaglog() {
            var floatingDialogId = '<%=FdAddProduct.ClientID %>'.replace(/_/g, '');
            jQuery('#floatingDialog' + floatingDialogId).hide();
            jQuery("#jqDnrFloatDivBg").hide();
        }

        function ValxPhone_ClientValidate(s, e) {
            var phone = document.getElementById('<%=TxtPhone.ClientID %>').value;
            var mobile = document.getElementById('<%=TxtMobile.ClientID %>').value;
            if (phone == "" && mobile == "") {
                e.IsValid = false;
            }
            else {
                e.IsValid = true;
            }
        }

        var jq = jQuery.noConflict();

        function GetTotal() {
            var totalnumber = 0;
            var totalUserExp = 0;
            jq("#TableCreditProduct input[id$='TxtAmount']").each(function () {
                totalnumber += parseInt(this.value);
            });
            jq("#TableCreditProduct span[id$='LblTotalUserExp']").each(function () {
                totalUserExp += parseInt(this.innerHTML);
            })
            jq("#TotalNumber").html(totalnumber);
            jq("#TotalUserExp").html(totalUserExp);
        }

        function BindRptCreditProduct() {
            jq("#TableCreditProduct input[id$='TxtAmount']").each(function () {
                jq(this).change(function () {
                    var prefix = this.id.replace("TxtAmount", "");
                    var amount = parseInt(this.value);
                    var stocks = parseInt(jq("#" + prefix + "LblStock").html());
                    if (isNaN(amount) || amount < 0) {
                        alert("请输入有效数值！");
                        amount = 0;
                    }
                    if (amount > stocks) {
                        alert("订购数量不能超过现有库存！");
                        amount = 0;
                    }
                    this.value = amount = isNaN(amount) ? 0 : amount;
                    var userExp = parseInt(jq("#" + prefix + "LblUserExp").html());
                    jq("#" + prefix + "LblTotalUserExp").html(amount * userExp);
                    GetTotal();
                });
            });
        }

        jq(function () {
            try {
                BindRptCreditProduct();
                GetTotal();
            } catch (e) {
                Sys.Debug.traceDump(e.message);
            }
        });

        Sys.Application.add_load(function () {
            try {
                Sys.WebForms.PageRequestManager.getInstance().add_endRequest(BindRptCreditProduct);
                GetTotal();
            } catch (e) {
                Sys.Debug.traceDump(e.message);
            }
        });
        
        
    </script>
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td class="title">
                <b>订 单 信 息</b>（订单编号：<asp:Label ID="LblOrderNum" runat="server" />）
            </td>
        </tr>
        <tr>
            <td>
                <table width="100%" border="0" cellpadding="2" cellspacing="0">
                    <tr class="tdbg">
                        <td style="width: 18%;">
                            客户名称：<asp:Label ID="LblClientName" runat="server" Style="color: #ff0000;" />
                        </td>
                        <td style="width: 20%;">
                            用 户 名：<asp:Label ID="LblUserName" runat="server" Style="color: #ff0000;" />
                        </td>
                        <td style="width: 20%;">
                            <asp:Label ID="LblUserExp" runat="server"></asp:Label>
                        </td>
                        <td colspan="2">
                            下单时间：<asp:Label ID="LblInputTime" runat="server" Style="color: #ff0000;" />
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <% if (!m_IsCreditProduct)
                           {%>
                        <td style="width: 18%;">
                            需要发票：<asp:Label ID="LblNeedInvoice" runat="server" />
                        </td>
                        <td style="width: 20%;">
                            已开发票：<asp:Label ID="LblInvoiced" runat="server" />
                        </td>
                        <%} %>
                        <td style="width: 20%;">
                            订单状态：<pe:ExtendedLabel HtmlEncode="false" ID="LblStatus" runat="server" />
                        </td>
                        <td style="width: 18%;">
                            <%= m_IsCreditProduct ? "积分状态：":"付款情况："%>
                            <pe:ExtendedLabel HtmlEncode="false" ID="LblMoneyTotal" runat="server" />
                        </td>
                        <td <%=m_IsCreditProduct ? "colspan='3'": "" %>>
                            物流状态：<pe:ExtendedLabel HtmlEncode="false" ID="LblDeliverStatus" runat="server" />
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr align="center">
            <td>
                <table width="100%" border="0" cellpadding="2" cellspacing="1">
                    <tr class="tdbg">
                        <td style="width: 12%; height: 27px;" class="tdbgleft" align="right">
                            收货人姓名：
                        </td>
                        <td style="width: 38%; height: 27px;" align="left">
                            <asp:TextBox ID="TxtContacterName" runat="server" Width="80px" MaxLength="50" />
                            <pe:RequiredFieldValidator ID="ValrContacterName" Display="Dynamic" Text="请输入收货人姓名！"
                                ControlToValidate="TxtContacterName" SetFocusOnError="true" runat="server" ErrorMessage="RequiredFieldValidator"></pe:RequiredFieldValidator>
                        </td>
                        <td style="width: 12%; height: 27px;" class="tdbgleft" align="right">
                            联系电话：
                        </td>
                        <td style="width: 38%; height: 27px;" align="left">
                            <asp:TextBox ID="TxtPhone" runat="server" MaxLength="50" />
                            <pe:RegexValidator ValidateType="Mobile" ID="VtelPhone" ControlToValidate="TxtPhone"
                                SetFocusOnError="true" Display="dynamic" ErrorMessage="收货人电话格式不正确" runat="server"></pe:RegexValidator>
                            <asp:CustomValidator ID="ValxPhone" ClientValidationFunction="ValxPhone_ClientValidate"
                                Display="dynamic" ValidateEmptyText="true" SetFocusOnError="true" runat="server"
                                ErrorMessage="至少要输入收货人电话和收货人手机中的一个" ControlToValidate="TxtPhone"></asp:CustomValidator>
                        </td>
                    </tr>
                    <tr class="tdbg" valign="top">
                        <td style="width: 12%; height: 27px;" class="tdbgleft" align="right">
                            收货人地址：
                        </td>
                        <td style="width: 38%; height: 27px;" align="left">
                            <asp:TextBox ID="TxtAddress" runat="server" Width="200px" MaxLength="255" />
                            <pe:RequiredFieldValidator ID="ValrAddress" Display="Dynamic" Text="请输入收货人地址！" SetFocusOnError="true"
                                ControlToValidate="TxtAddress" runat="server" ErrorMessage="RequiredFieldValidator"></pe:RequiredFieldValidator>
                        </td>
                        <td style="width: 12%; height: 27px;" class="tdbgleft" align="right">
                            邮政编码：
                        </td>
                        <td style="width: 38%; height: 27px;" align="left">
                            <asp:TextBox ID="TxtZipCode" runat="server" MaxLength="10" />
                            <pe:RequiredFieldValidator ID="ValrZipCode" Display="Dynamic" Text="请输入邮政编码！" SetFocusOnError="true"
                                ControlToValidate="TxtZipCode" runat="server" ErrorMessage="RequiredFieldValidator"></pe:RequiredFieldValidator><pe:RegexValidator
                                    ValidateType="ZipCode" ID="VzipZipCode" ControlToValidate="TxtZipCode" Display="dynamic"
                                    SetFocusOnError="true" runat="server"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td style="width: 12%;" class="tdbgleft" align="right">
                            收货人邮箱：
                        </td>
                        <td style="width: 38%;" align="left">
                            <asp:TextBox ID="TxtEmail" runat="server" MaxLength="50" />
                            <pe:RequiredFieldValidator ID="ValrEmail" Display="Dynamic" SetFocusOnError="true"
                                Text="请输入收货人邮箱！" ControlToValidate="TxtEmail" runat="server" ErrorMessage="RequiredFieldValidator"></pe:RequiredFieldValidator><pe:RegexValidator
                                    ValidateType="Email" ID="VmailEmail" ControlToValidate="TxtEmail" Display="dynamic"
                                    SetFocusOnError="true" runat="server"></pe:RegexValidator>
                        </td>
                        <td style="width: 12%;" class="tdbgleft" align="right">
                            收货人手机：
                        </td>
                        <td style="width: 38%;" align="left">
                            <asp:TextBox ID="TxtMobile" runat="server" MaxLength="50" />
                            <pe:RegexValidator ValidateType="Mobile" ID="VmblMobile" ControlToValidate="TxtMobile"
                                Display="dynamic" SetFocusOnError="true" ErrorMessage="收货人手机格式不正确" runat="server"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td style="width: 12%;" class="tdbgleft" align="right">
                            &nbsp;跟 单 员：
                        </td>
                        <td style="width: 38%;" align="left">
                            <asp:TextBox ID="txtSelectFunctionary" Width="135" runat="server"></asp:TextBox>
                            <pec:FloatingDialog ID="floatSelectFunctionary" runat="server" Name="选择跟单员" Title="选择跟单员"
                                Width="600" Height="500" BeginString="【" EndString="】" Skin="floatingDialogFontSkin" />
                            <asp:HiddenField ID="HnSelectFunctionary" runat="server" />
                        </td>
                        <td style="width: 12%;" class="tdbgleft" align="right">
                            购买日期：
                        </td>
                        <td style="width: 38%;" align="left">
                            <pe:DatePicker ID="DpkBeginDate" runat="server"></pe:DatePicker>
                            <pe:RegexValidator ValidateType="Date" ID="VdateBeginDate" ControlToValidate="DpkBeginDate"
                                runat="server" Display="Dynamic" SetFocusOnError="True"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg" runat="server" id="TdAgent">
                        <td style="width: 12%;" class="tdbgleft" align="right">
                            &nbsp;代 理 商：
                        </td>
                        <td style="width: 38%;" align="left">
                            <pec:SelectAgent ID="SelectAgent1" runat="server"></pec:SelectAgent>
                        </td>
                        <td style="width: 12%;" class="tdbgleft" align="right">
                            发票信息：
                        </td>
                        <td style="width: 38%;" align="left">
                            <asp:TextBox ID="TxtInvoiceContent" runat="server" Height="50px" TextMode="MultiLine"
                                Text="发票抬头： 
商品名称： 
发票金额： 元" Width="200px" />&nbsp;<asp:CheckBox ID="ChkNeedInvoice" runat="server" OnCheckedChanged="ChkNeedInvoice_CheckedChanged"
    AutoPostBack="true" />需要发票
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td style="width: 12%;" class="tdbgleft" align="right">
                            &nbsp;订单类型：
                        </td>
                        <td style="width: 38%;" align="left">
                            <asp:DropDownList ID="DropOrderType" runat="server" DataTextField="DataTextField"
                                DataValueField="DataValueField">
                            </asp:DropDownList>
                        </td>
                        <td style="width: 12%;" class="tdbgleft" align="right">
                            送货方式：
                        </td>
                        <td style="width: 38%;" align="left">
                            <asp:DropDownList ID="DropDeliverType" DataTextField="TypeName" DataValueField="TypeId"
                                runat="server">
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr class="tdbg" valign="top">
                        <td style="width: 12%;" class="tdbgleft" align="right">
                            内部记录：
                        </td>
                        <td style="width: 38%;" align="left">
                            <asp:TextBox ID="TxtMemo" Visible="false" runat="server" Height="50px" TextMode="MultiLine" Width="200px" />
                        </td>
                        <td style="width: 12%;" class="tdbgleft" align="right">
                            <asp:Label ID="LblPaymentType" runat="server" Text="付款方式："></asp:Label>
                        </td>
                        <td style="width: 38%;" align="left">
                            <asp:DropDownList ID="DropPaymentType" DataTextField="TypeName" DataValueField="TypeId"
                                runat="server">
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr class="tdbg" id="TdDeliverChargeType" runat="server">
                        <td style="width: 12%;" class="tdbgleft" align="right">
                            运费计算方式：
                        </td>
                        <td style="width: 38%;" align="left" colspan="3">
                            <asp:RadioButtonList ID="RadlDeliverChargeType" RepeatLayout="Flow" Enabled="false"
                                RepeatDirection="horizontal" runat="server">
                                <asp:ListItem Selected="true" Value="0">不重新计算</asp:ListItem>
                                <asp:ListItem Value="1">重新计算</asp:ListItem>
                                <asp:ListItem Value="2">手工指定为</asp:ListItem>
                            </asp:RadioButtonList>
                            <asp:TextBox ID="TxtDeliverCharge" Width="50px" runat="server" Enabled="false"></asp:TextBox>元
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="left" colspan="4">
                            <b>订单自定义选项：</b>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="left" colspan="4">
                            <table cellpadding="2" cellspacing="1" style="width: 98%; background-color: white;">
                                <asp:Repeater ID="RepModel" runat="server" OnItemDataBound="RepModel_OnItemDataBound">
                                    <ItemTemplate>
                                        <tr id='Tab' runat="server" class='tdbg'>
                                            <td class='tdbgleft' align='right' style="width: 12%;">
                                                <div class="DivWordBreak">
                                                    <strong>
                                                        <%# Eval("FieldAlias")%>
                                                        ：&nbsp;</strong><br />
                                                    <%# Eval("Tips") %>
                                                </div>
                                            </td>
                                            <td class='tdbg' align='left'>
                                                <pe:AdminFieldControl ID="Field" runat="server" EnableNull='<%# (bool)Eval("EnableNull") %>'
                                                    FieldAlias='<%# Eval("FieldAlias")%>' Tips='<%# Eval("Tips") %>' FieldName='<%#Eval("FieldName")%>'
                                                    ControlType='<%# Eval("FieldType") %>' FieldLevel='<%# Eval("FieldLevel") %>'
                                                    Description='<%# Eval("Description")%>' Settings='<%# ((PowerEasy.Module.General.Model.CommonModel.FieldInfo)Container.DataItem).Settings %>'
                                                    Value='<%# Eval("DefaultValue") %>'>
                                                </pe:AdminFieldControl>
                                            </td>
                                        </tr>
                                    </ItemTemplate>
                                </asp:Repeater>
                            </table>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td>
                <asp:UpdatePanel ID="UplCreditProduct" runat="server" UpdateMode="Conditional" OnLoad="UplCreditProduct_Load">
                    <ContentTemplate>
                        <asp:Repeater ID="RptCreditProduct" runat="server" OnItemCommand="RptCreditProduct_ItemCommand"
                            OnItemDataBound="RptCreditProduct_ItemDataBound">
                            <HeaderTemplate>
                                <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border" id="TableCreditProduct">
                                    <tr align="center" class="title">
                                        <th style="white-space: nowrap;">
                                            商 品 名 称
                                        </th>
                                        <th style="width: 7%">
                                            单位
                                        </th>
                                        <th style="width: 7%">
                                            数量
                                        </th>
                                        <th style="width: 80px;">
                                            现有库存
                                        </th>
                                        <th style="width: 80px;">
                                            库存状态
                                        </th>
                                        <th style="width: 10%">
                                            市场价
                                        </th>
                                        <th style="width: 10%">
                                            换购积分
                                        </th>
                                        <th style="width: 10%">
                                            总积分
                                        </th>
                                        <th style="width: 10%">
                                            服务期限
                                        </th>
                                        <th style="width: 15%">
                                            备注
                                        </th>
                                        <th style="width: 5%">
                                            操作
                                        </th>
                                    </tr>
                            </HeaderTemplate>
                            <ItemTemplate>
                                <tr align="center" class="tdbg">
                                    <td>
                                        <%#Eval("ProductName") %>
                                    </td>
                                    <td>
                                        <%#Eval("Unit")%>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TxtAmount" Style="text-align: center" Text='<%#Eval("Amount") %>'
                                            Width="80%" runat="server" />
                                    </td>
                                    <td style="width: 80px;">
                                        <asp:Label ID="LblStock" runat="server"></asp:Label>
                                    </td>
                                    <td style="width: 80px;">
                                        <pe:ExtendedLabel ID="LblStockState" runat="server" HtmlEncode="false"></pe:ExtendedLabel>
                                    </td>
                                    <td>
                                        <%#Decimal.Round(Convert.ToDecimal(Eval("PriceMarket")),2) %>
                                    </td>
                                    <td>
                                        <asp:Label ID="LblUserExp" Text='<%#Eval("PresentExp") %>' runat="server" />
                                    </td>
                                    <td>
                                        <asp:Label ID="LblTotalUserExp" Text='<%# (int)Eval("PresentExp") * (int)Eval("Amount") %>'
                                            runat="server" />
                                    </td>
                                    <td>
                                        <pe:NumericBox ID="TxtServiceTerm" runat="server" Text='<%#Eval("ServiceTerm") %>' MaxLength="5" width="30%"></pe:NumericBox>
                                        <asp:DropDownList ID="DropServiceTermUnit" runat="server" onchange="ServiceUnitChange('CreditServiceTermGroup')">
                                            <asp:ListItem Value="0">年</asp:ListItem>
                                            <asp:ListItem Value="1">月</asp:ListItem>
                                            <asp:ListItem Value="2">日</asp:ListItem>
                                        </asp:DropDownList>
                                        <asp:CustomValidator ID="ValrServiceTerm" ValidationGroup="CreditServiceTermGroup" runat="server" ClientValidationFunction="CheckServiceLimit" ControlToValidate="TxtServiceTerm"
                             Display="Dynamic" SetFocusOnError="true" ErrorMessage="服务期限不能大于超过100年"></asp:CustomValidator>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TxtItemRemark" Width="80%" Text='<%# Convert.ToString(Eval("Remark")) %>'
                                            runat="server" MaxLength="255"></asp:TextBox>
                                    </td>
                                    <td>
                                        <asp:LinkButton ID="LbtnDelete" runat="server" CommandName="DelCreditProduct" CommandArgument='<%#Eval("ProductId")%>'
                                            CausesValidation="False">删除</asp:LinkButton>
                                    </td>
                                </tr>
                            </ItemTemplate>
                            <FooterTemplate>
                                <tr class="tdbg">
                                    <td colspan="2" align="right">
                                        合计数量：
                                    </td>
                                    <td align="center" id="TotalNumber">
                                        0
                                    </td>
                                    <td colspan="4" align="right">
                                        合计积分：
                                    </td>
                                    <td align="center" id="TotalUserExp">
                                        0
                                    </td>
                                    <td colspan="3">
                                    </td>
                                </tr>
                                </table>
                            </FooterTemplate>
                        </asp:Repeater>
                    </ContentTemplate>
                </asp:UpdatePanel>
                <asp:UpdatePanel ID="UpdatePanel2" runat="server" UpdateMode="Conditional" OnLoad="UplOrderItem_Load">
                    <ContentTemplate>
                        <asp:Repeater ID="RptOrderItem" runat="server" OnItemDataBound="RptOrderItem_ItemDataBound"
                            OnItemCommand="RptOrderItem_ItemCommand">
                            <HeaderTemplate>
                                <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
                                    <tr align="center" class="title">
                                        <td style="white-space: nowrap;">
                                            商 品 名 称
                                        </td>
                                        <td style="width: 7%">
                                            单位
                                        </td>
                                        <td style="width: 7%">
                                            数量
                                        </td>
                                        <td style="width: 80px;">
                                            现有库存
                                        </td>
                                        <td style="width: 80px;">
                                            库存状态
                                        </td>
                                        <td style="width: 10%">
                                            市场价
                                        </td>
                                        <td style="width: 10%">
                                            实价
                                        </td>
                                        <td style="width: 10%">
                                            指定价
                                        </td>
                                        <td style="width: 10%">
                                            服务期限
                                        </td>
                                        <td style="width: 15%">
                                            备注
                                        </td>
                                        <td style="width: 5%">
                                            操作
                                        </td>
                                    </tr>
                            </HeaderTemplate>
                            <ItemTemplate>
                                <tr align="center" class="tdbg">
                                    <td>
                                        <asp:TextBox ID="TxtProductName" Style="text-align: center" Enabled="false" Text='<%#ShowProductNameForType(Convert.ToString(Eval("ProductName")),Eval("Property")==null ? "":Eval("Property").ToString(),Convert.ToInt32(Eval("SaleType"))) %>'
                                            Width="80%" runat="server"></asp:TextBox>
                                        <asp:HiddenField ID="HdnProductCharacter" runat="server" Value='<%#Eval("ProductCharacter") %>' />
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TxtUnit" Style="text-align: center" Enabled="false" Text='<%#Eval("Unit")%>'
                                            Width="80%" runat="server"></asp:TextBox>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TxtAmount" Style="text-align: center" Text='<%#Eval("Amount") %>'
                                            OnTextChanged="TxtModifyOrder" Width="80%" runat="server" AutoPostBack="true"></asp:TextBox>
                                    </td>
                                    <td style="width: 80px;">
                                        <asp:Literal ID="LtrStock" runat="server"></asp:Literal>
                                    </td>
                                    <td style="width: 80px;">
                                        <pe:ExtendedLabel ID="LblStockState" runat="server" HtmlEncode="false"></pe:ExtendedLabel>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TxtPrice_Original" Style="text-align: right" Enabled="false" Text='<%#Decimal.Round(Convert.ToDecimal(Eval("PriceMarket")),2) %>'
                                            Width="80%" runat="server"></asp:TextBox>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TxtPrice" Style="text-align: right" Enabled="false" Text='<%#Decimal.Round(Convert.ToDecimal(Eval("Price")),2) %>'
                                            Width="80%" runat="server"></asp:TextBox>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TxtTruePrice" Style="text-align: right" Text='<%#Decimal.Round(Convert.ToDecimal(Eval("TruePrice")),2) %>'
                                            Width="80%" runat="server" MaxLength="10" OnTextChanged="TxtModifyOrder" AutoPostBack="true"></asp:TextBox>
                                    </td>
                                    <td>
                                        <pe:NumericBox ID="TxtServiceTerm" runat="server" Text='<%#Eval("ServiceTerm") %>' MaxLength="5" width="30%"></pe:NumericBox>
                                        <asp:DropDownList ID="DropServiceTermUnit" runat="server" onchange="ServiceUnitChange('ServiceTermGroup')">
                                            <asp:ListItem Value="0">年</asp:ListItem>
                                            <asp:ListItem Value="1">月</asp:ListItem>
                                            <asp:ListItem Value="2">日</asp:ListItem>
                                        </asp:DropDownList>
                                        <asp:CustomValidator ID="ValrServiceTerm" ValidationGroup="ServiceTermGroup" runat="server" ClientValidationFunction="CheckServiceLimit" ControlToValidate="TxtServiceTerm"
                             Display="Dynamic" SetFocusOnError="true" ErrorMessage="服务期限不能大于超过100年"></asp:CustomValidator>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TxtItemRemark" Width="80%" Text='<%# Convert.ToString(Eval("Remark")) %>'
                                            runat="server" MaxLength="255"></asp:TextBox>
                                    </td>
                                    <td>
                                        <asp:LinkButton ID="LbtnDelete" runat="server" CommandName="DelOrderItem" CommandArgument='<%#Eval("ProductId") +"|" + Eval("TableName") + "|" + Eval("SaleType")+ "|" + Eval("SubTotal")%>'
                                            CausesValidation="False">删除</asp:LinkButton>
                                    </td>
                                </tr>
                            </ItemTemplate>
                            <FooterTemplate>
                                </table>
                            </FooterTemplate>
                        </asp:Repeater>
                        <div id="Note" visible="false" runat="server" style="text-align: left">
                            <b>
                                <asp:Localize ID="Localize22" Text="你可以用" runat="server" />
                                <asp:Label ID="LblPrice" runat="server" ForeColor="red"></asp:Label>
                                <asp:Localize ID="Localize23" Text="元超值换购以下商品中的任一款：" runat="server" /></b>
                        </div>
                        <asp:Repeater ID="RptPresentList" runat="server" Visible="false" OnItemDataBound="RptPresentList_ItemDataBound">
                            <HeaderTemplate>
                                <table width="100%" class="border" cellpadding="2" cellspacing="1">
                                    <tr class="title" align="center">
                                        <td style="width: 3px;">
                                        </td>
                                        <td id="changePresentHeaderImage" runat="server">
                                            <asp:Localize ID="Localize24" Text="图片" runat="server" />
                                        </td>
                                        <td>
                                            <asp:Localize ID="Localize25" Text="商品名称" runat="server" />
                                        </td>
                                        <td>
                                            <asp:Localize ID="Localize26" Text="单位" runat="server" />
                                        </td>
                                        <td>
                                            <asp:Localize ID="Localize27" Text="数量" runat="server" />
                                        </td>
                                        <td runat="server" id="changePresentHeaderProductType">
                                            <asp:Localize ID="Localize28" Text="商品类别" runat="server" />
                                        </td>
                                        <td runat="server" id="changePresentHeaderSaleType">
                                            <asp:Localize ID="Localize29" Text="销售类型" runat="server" />
                                        </td>
                                        <td runat="server" id="changePresentHeaderMarkPrice">
                                            <asp:Localize ID="Localize30" Text="市场价" runat="server" />
                                        </td>
                                        <td>
                                            <asp:Localize ID="Localize31" Text="实价" runat="server" />
                                        </td>
                                        <td>
                                            <asp:Localize ID="Localize32" Text="金额" runat="server" />
                                        </td>
                                    </tr>
                            </HeaderTemplate>
                            <ItemTemplate>
                                <tr align="center" class="tdbg">
                                    <td style="width: 5px;">
                                        <input type="radio" value='<%#Eval("PresentId").ToString()%>' name="RdbPresentId"
                                            id="RdbPresentId">
                                    </td>
                                    <td id="changePresentImage" runat="server" align="center">
                                        <pe:ExtendedImage ID="changePresentListImage" runat="server"></pe:ExtendedImage>
                                    </td>
                                    <td style="text-align: center;">
                                        <asp:Literal ID="LitChangePresentName" runat="server" Text='<%#Eval("PresentName") %>'></asp:Literal>
                                    </td>
                                    <td align="center">
                                        <asp:Literal ID="LitChangePresentUnit" runat="server" Text='<%#Eval("Unit") %>'></asp:Literal>
                                    </td>
                                    <td align="center">
                                        <asp:Literal ID="LitChangePresentAmount" runat="server" Text='1'></asp:Literal>
                                    </td>
                                    <td runat="server" id="changePresentType" align="center">
                                        <asp:Literal ID="LitChangePresentType" runat="server" Text='促销礼品'></asp:Literal>
                                    </td>
                                    <td runat="server" id="changeSaleType" align="center">
                                        <asp:Literal ID="LitChangePresentSaleType" runat="server" Text='超值换购'></asp:Literal>
                                    </td>
                                    <td runat="server" id="changeMarkPrice" align="center">
                                        <asp:Literal ID="LitChangePresentPriceMarket" runat="server"></asp:Literal>
                                    </td>
                                    <td align="center">
                                        <asp:Literal ID="LitChangePresentTruePrice" runat="server"></asp:Literal>
                                    </td>
                                    <td align="center">
                                        <asp:Literal ID="LitChangePresentSubTotal" runat="server"></asp:Literal>
                                    </td>
                                </tr>
                            </ItemTemplate>
                            <FooterTemplate>
                                </table>
                            </FooterTemplate>
                        </asp:Repeater>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
        <tr style="height: 40px;" class="tdbg">
            <td align="center" style="height: 40px">
                <asp:HiddenField ID="HdnOrderId" runat="server" />
                <asp:HiddenField ID="HdnState" runat="server" />
                <asp:HiddenField ID="HdnMoneyTotal" runat="server" />
                <asp:HiddenField ID="HdnMoneyGoods" runat="server" />
                <asp:HiddenField ID="HdnDiscountPayment" runat="server" />
                <asp:HiddenField ID="HdnCouponID" runat="server" />
                <pec:FloatingDialog ID="FdAddProduct" runat="server" Name="添加商品" ShowType="1" Title="选择商品"
                    Width="700" Height="450" LoadUrl="../Shop/ProductPicker.aspx?ShowType=1" Skin="inputbutton" />
                <asp:Button ID="BtnSave" runat="server" Text="保存订单" OnClientClick="if(!Page_ClientValidate('ServiceTermGroup'))return false;" UseSubmitBehavior="false" OnClick="BtnSave_Click" />
                <asp:Button ID="BtnSaveCreditProductOrder" runat="server" Text="保存积分订单" OnClientClick="if(!Page_ClientValidate('CreditServiceTermGroup'))return false;" UseSubmitBehavior="false"
                    OnClick="BtnSaveCreditProductOrder_Click" />
                <asp:Button ID="BtnCancel" runat="server" CausesValidation="false" Text="取消" UseSubmitBehavior="false"
                    OnClick="BtnCancel_Click" />
            </td>
        </tr>
    </table>
    <br />
    注：“市场价”指商品的市场参考价，“实价”指系统根据 最终价格计算公式表 自动计算出来的商品最终价格。您也可以手动指定与“实价”不同的最终销售价格。

    <script type="text/javascript">
        function ServiceUnitChange(groupname) {
            Page_ClientValidate(groupname);
        }

        function CheckServiceLimit(source, value) {
            var val = parseInt(value.Value);
            if (val > 0) {
                var unit = jQuery(source).prev().val();
                if (unit == "0") {
                    if (val > 100) {
                        jQuery(source).html("<font color='red'>服务期限不能超过100年</font>");
                        value.IsValid = false;
                    }
                } else if (unit == 1) {
                    if (val > 100 * 12) {
                        jQuery(source).html("<font color='red'>服务期限不能超过1200个月</font>");
                        value.IsValid = false;
                    }
                } else if (unit == 2) {
                    if (val > 100 * 365) {
                        jQuery(source).html("<font color='red'>服务期限不能超过36500天</font>");
                        value.IsValid = false;
                    }
                }
            }
        }
    </script>
</asp:Content>
