﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.OrderSearch" Title="订单查询"
    CodeBehind="OrderSearch.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <asp:ScriptManager ID="SmgePayment" runat="server" ScriptMode="Inherit">
    </asp:ScriptManager>
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>订单复杂查询</b>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                ID范围：
            </td>
            <td>
                起始ID<asp:TextBox ID="TxtBeginId" runat="server" Width="78px"></asp:TextBox>&nbsp;终止ID<asp:TextBox
                    ID="TxtEndId" runat="server" Width="78px"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                日期范围：
            </td>
            <td>
                起始日期
                <pe:DatePicker ID="DpkBeginDate" runat="server" Width="70px"></pe:DatePicker>&nbsp;结束日期
                <pe:DatePicker ID="DpkEndDate" runat="server" Width="70px"></pe:DatePicker>
                <pe:RegexValidator ValidateType="Date" ID="VdateBeginDate" ControlToValidate="DpkBeginDate"
                    SetFocusOnError="true" Display="dynamic" ErrorMessage="起始日期格式不正确" runat="server"></pe:RegexValidator>
                <pe:RegexValidator ValidateType="Date" ID="VdateEndDate" ControlToValidate="DpkEndDate"
                    SetFocusOnError="true" Display="dynamic" ErrorMessage="结束日期格式不正确" runat="server"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg" id="TrMoney" runat="server">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                金额范围：
            </td>
            <td>
                <asp:TextBox ID="TxtMinMoney" runat="server" Width="78px"></asp:TextBox>&nbsp;至&nbsp;<asp:TextBox
                    ID="TxtMaxMoney" runat="server" Width="78px"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                服务到期：
            </td>
            <td>
                <asp:TextBox ID="TxtAmount" runat="server" Width="78px" />
                <pe:RegexValidator ValidateType="Number" ID="Vnum" runat="server" ControlToValidate="TxtAmount"
                    Display="Dynamic" ErrorMessage="请输入正整数" ValidationExpression="^[1-9]\d*$"></pe:RegexValidator>
                天内服务到期
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                订单状态：
            </td>
            <td>
                <asp:RadioButtonList ID="RadlOrderStatus" RepeatDirection="Horizontal" runat="server">
                    <asp:ListItem Value="0" Text="等待确认&nbsp;&nbsp;" />
                    <asp:ListItem Value="1" Text="已经确认&nbsp;&nbsp;" />
                    <asp:ListItem Value="2" Text="已经结清&nbsp;&nbsp;" />
                    <asp:ListItem Value="3" Text="已经作废&nbsp;&nbsp;" />
                    <asp:ListItem Value="4" Text="暂停处理&nbsp;&nbsp;" />
                    <asp:ListItem Value="-1" Text="所有状态" Selected="True" />
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg" id="TrPayStatus" runat="server">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                付款状态：
            </td>
            <td>
                <asp:RadioButtonList ID="RadlPayStatus" RepeatDirection="Horizontal" runat="server">
                    <asp:ListItem Value="0" Text="等待付款&nbsp;&nbsp;" />
                    <asp:ListItem Value="1" Text="已付定金&nbsp;&nbsp;" />
                    <asp:ListItem Value="2" Text="已经付清&nbsp;&nbsp;" />
                    <asp:ListItem Value="-1" Text="所有状态" Selected="True" />
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                物流状态：
            </td>
            <td>
                <asp:RadioButtonList ID="RadlDeliverStatus" RepeatDirection="Horizontal" runat="server">
                    <asp:ListItem Value="-1" Text="不需要发货"></asp:ListItem>
                    <asp:ListItem Value="0" Text="未开始流程" />
                    <asp:ListItem Value="1" Text="等待配送&nbsp;" />
                    <asp:ListItem Value="2" Text="配送中&nbsp;&nbsp;" />
                    <asp:ListItem Value="3" Text="部分发货&nbsp;"></asp:ListItem>
                    <asp:ListItem Value="4" Text="已发货&nbsp;&nbsp;" />
                    <asp:ListItem Value="5" Text="已签收&nbsp;&nbsp;" />
                    <asp:ListItem Value="-2" Text="所有状态&nbsp;" Selected="True" />
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                送货方式：
            </td>
            <td>
                <asp:DropDownList ID="DropDeliverType" DataTextField="TypeName" DataValueField="TypeID"
                    runat="server">
                </asp:DropDownList>
            </td>
        </tr>
        <tr class="tdbg" id="TrPaymentType" runat="server">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                付款方式：
            </td>
            <td>
                <asp:DropDownList ID="DropPaymentType" DataTextField="TypeName" DataValueField="TypeID"
                    runat="server">
                </asp:DropDownList>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                订单类型：
            </td>
            <td>
                <asp:RadioButtonList ID="RadlOrderType" runat="server" RepeatDirection="horizontal"
                    DataTextField="DataTextField" DataValueField="DataValueField">
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                跟 单 员：
            </td>
            <td>
                <asp:TextBox ID="txtSelectFunctionary" Width="135" runat="server"></asp:TextBox>
                <pec:FloatingDialog ID="floatSelectFunctionary" runat="server" Name="选择跟 单 员" Title="选择跟 单 员"
                    Width="600" Height="500" BeginString="【" EndString="】" Skin="floatingDialogFontSkin" />
                <asp:HiddenField ID="HnSelectFunctionary" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                订单编号：
            </td>
            <td>
                <asp:TextBox ID="TxtOrderNum" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                客户名称：
            </td>
            <td>
                <asp:TextBox ID="TxtClientName" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                用户名称：
            </td>
            <td>
                <asp:TextBox ID="TxtUserName" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                代理商：
            </td>
            <td>
                <asp:TextBox ID="TxtAgentName" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                收货人姓名：
            </td>
            <td>
                <asp:TextBox ID="TxtContacterName" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                联系地址：
            </td>
            <td>
                <asp:TextBox ID="TxtAddress" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                联系电话：
            </td>
            <td>
                <asp:TextBox ID="TxtPhone" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                收货人手机：
            </td>
            <td>
                <asp:TextBox ID="TxtMobile" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                收货人邮箱：
            </td>
            <td>
                <asp:TextBox ID="TxtEmail" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tbody id="TBodyInvoice" runat="server">
            <tr class="tdbg">
                <td style="width: 160px; text-align: right" class="tdbgleft">
                    发票信息：
                </td>
                <td>
                    <asp:TextBox ID="TxtInvoice" runat="server"></asp:TextBox>
                </td>
            </tr>
            <tr class="tdbg">
                <td style="width: 160px; text-align: right" class="tdbgleft">
                    发票抬头：
                </td>
                <td>
                    <asp:TextBox ID="TxtInvoiceHead" runat="server"></asp:TextBox>
                </td>
            </tr>
        </tbody>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                商品名称：
            </td>
            <td>
                <asp:TextBox ID="TxtProductName" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 160px; text-align: right" class="tdbgleft">
                内部记录：
            </td>
            <td>
                <asp:TextBox ID="TxtMemo" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td colspan="2">
                <asp:UpdatePanel ID="UpnlOrderOption" runat="server" UpdateMode="Conditional">
                    <ContentTemplate>
                        <table cellpadding="2" cellspacing="1" style="width: 98%; background-color: white;">
                            <asp:Repeater ID="RepModel" runat="server" OnItemDataBound="RepModel_OnItemDataBound">
                                <ItemTemplate>
                                    <tr id='Tab' runat="server" class='tdbg'>
                                        <td style="width: 160px; text-align: right" class="tdbgleft">
                                            <div class="DivWordBreak">
                                                <%# Eval("FieldAlias")%>
                                                ：&nbsp;<br />
                                                <%# Eval("Tips") %>
                                            </div>
                                        </td>
                                        <td class='tdbg' align='left'>
                                            <pe:AdminFieldControl ID="Field" runat="server" EnableNull='<%# (bool)Eval("EnableNull") %>'
                                                FieldAlias='<%# Eval("FieldAlias")%>' Tips='<%# Eval("Tips") %>' FieldName='<%#Eval("FieldName")%>'
                                                ControlType='<%# Eval("FieldType") %>' FieldLevel='<%# Eval("FieldLevel") %>'
                                                Description='<%# Eval("Description")%>' Settings='<%# ((PowerEasy.Module.General.Model.CommonModel.FieldInfo)Container.DataItem).Settings %>'
                                                Value='<%# Eval("DefaultValue") %>'>
                                            </pe:AdminFieldControl>
                                        </td>
                                    </tr>
                                </ItemTemplate>
                            </asp:Repeater>
                        </table>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
        <tr class="tdbg" style="height: 40px; text-align: center">
            <td colspan="2">
                <asp:Button ID="BtnSearch" runat="server" Text="查询" OnClick="BtnSearch_Click" />
                &nbsp;
                <asp:Button ID="BtnExportExcel" runat="server" Text="导出到EXCEL" OnClick="BtnExportExcel_Click" />
            </td>
        </tr>
    </table>
    <script language="javascript" type="text/javascript">
        function SelectAdmin(arr) {
            if (arr != null) {
                var txtFunctionary = document.getElementById('<%=txtSelectFunctionary.ClientID %>')
                var hdnFunctionary = document.getElementById('<%=HnSelectFunctionary.ClientID %>')
                var ss = arr.split('$$$');
                txtFunctionary.value = ss[0];
                hdnFunctionary.value = ss[0];
            }
        }
    </script>
</asp:Content>
