﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.PackageManage" Title="包装管理" Codebehind="PackageManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="EgvPackage" runat="server" AutoGenerateColumns="False" DataSourceID="OdsPackage"
        SerialText="" DataKeyNames="PackageId" RowDblclickBoundField="PackageID" RowDblclickUrl="Package.aspx?Action=Modify&amp;PackageID={$Field}">
        <Columns>
            <pe:BoundField DataField="PackageName" HeaderText="包装名称" SortExpression="PackageName"
                 />
            <pe:BoundField DataField="PackageWeight" HeaderText="包装自重量（千克）" SortExpression="PackageWeight" />
            <pe:TemplateField HeaderText="包装使用条件（千克）">
                <ItemTemplate>
                    <%# Eval("GoodsWeightMin") +" ≤ 内含物的重量 ＜ "+Eval("GoodsWeightMax") %>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText=" 操 作 ">
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" OperateCode="PackageManage" href='<%# Eval("PackageId","Package.aspx?Action=Modify&PackageID={0}") %>'>修改</pe:ExtendedAnchor>
                    &nbsp;
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="PackageManage" ID="LbtnDelete"
                        runat="server" CommandName="Delete" OnClientClick="return confirm('是否要删除此包装？')">删除</pe:ExtendedLinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsPackage" runat="server" DeleteMethod="Delete" SelectMethod="GetList"
        TypeName="PowerEasy.Module.Shop.BusinessLogic.Package">
        <DeleteParameters>
            <asp:Parameter Name="packageId" Type="Int32" />
        </DeleteParameters>
    </asp:ObjectDataSource>
</asp:Content>
