﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.PaymentTypeManage" Title="付款方式管理" Codebehind="PaymentTypeManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server"
        AdditionalNode="所有付款方式" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="ExtendedGridView1" runat="server" AutoGenerateColumns="False"
        DataSourceID="OdsPaymentType" DataKeyNames="TypeId" OnRowCommand="ExtendedGridView1_RowCommand"
        SerialText="" OnRowDataBound="ExtendedGridView1_RowDataBound" CheckBoxFieldHeaderWidth="3%"
        RowDblclickBoundField="TypeId" RowDblclickUrl="PaymentType.aspx?Action=Modify&amp;TypeId={$Field}">
        <Columns>
            <pe:BoundField DataField="TypeId" HeaderText="ID" SortExpression="TypeId">
                <HeaderStyle Width="3%" />
            </pe:BoundField>
            <pe:BoundField DataField="TypeName" HeaderText="付款方式名称" SortExpression="TypeName"
                >
                <HeaderStyle Width="14%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="付款方式简介" SortExpression="Intro">
                <ItemTemplate>
                    <asp:Label runat="server" ID="LblIntro"></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="付款类型">
                <ItemTemplate>
                    <%#PowerEasy.Module.Shop.BusinessLogic.PaymentType.GetCategory((int)Eval("Category"))%>
                </ItemTemplate>
            </pe:TemplateField>
<%--            <pe:BoundField DataField="Discount" HeaderText="折扣率" SortExpression="Discount" DataFormatString="{0}%">
                <HeaderStyle Width="7%" />
            </pe:BoundField>--%>
            <pe:TemplateField HeaderText="是否默认" SortExpression="IsDefault">
                <HeaderStyle Width="9%" />
                <ItemTemplate>
                    <%# (bool)Eval("IsDefault") == false ? "" : "√"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="已启用" SortExpression="IsDisabled">
                <HeaderStyle Width="7%" />
                <ItemTemplate>
                    <%# (bool)Eval("IsDisabled") != false ? "<font color=red>×</font>" : "√"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="常规操作">
                <HeaderStyle Width="18%" />
                <ItemTemplate>
                    <asp:LinkButton ID="LbtnDefault" runat="server" CommandName="Default" CommandArgument='<%# Bind("TypeId") %>'>设为默认</asp:LinkButton>
                    <asp:LinkButton ID="LbtnDisable" runat="server" CommandArgument='<%# Bind("TypeId") %>'
                        CommandName="Disable" Text='<%# (bool)Eval("IsDisabled") ? "启用" : "禁用" %>'></asp:LinkButton>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" OperateCode="PaymentTypeManage"
                        href='<%#Eval("TypeId","PaymentType.aspx?Action=Modify&TypeId={0}") %>'>修改</pe:ExtendedAnchor>
                    <asp:LinkButton ID="LbtnDelete" runat="server" CausesValidation="False" CommandArgument='<%# Eval("TypeId") %>'
                        CommandName="Del">删除</asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="排序操作" SortExpression="OrderId">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <asp:DropDownList ID="DropOrderId" runat="server" DataSourceID="OdsPaymentType" DataTextField="OrderId"
                        DataValueField="OrderId" OnSelectedIndexChanged="DdlOrderId_SelectedIndexChanged"
                        SelectedValue='<%# Bind("OrderId") %>' AutoPostBack="True" Width="60px">
                    </asp:DropDownList>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <br />
    <div id="prompt-note">
	    <dl>
	    <dt class="prompt-note-tit">
	    <span>提示说明</span>
	    </dt>
	    <dd class="prompt-note-con">
		    说明：“禁用”某付款方式后，前台订购时将不再显示此付款方式，但已有订单中仍然显示。
	    </dd>  
	    </dl>
    </div>
    
    <asp:ObjectDataSource ID="OdsPaymentType"
        runat="server" SelectMethod="GetPaymentTypeList" TypeName="PowerEasy.Module.Shop.BusinessLogic.PaymentType">
    </asp:ObjectDataSource>
</asp:Content>
