﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.PresentManager" Codebehind="PresentManager.aspx.cs"
    Title="促销礼品管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider">
    </pe:ExtendedSiteMapPath>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <pe:ExtendedGridView ID="EgvPresent" runat="server" AutoGenerateColumns="False" CheckBoxFieldHeaderWidth="3%"
        DataSourceID="ObjPresent" SerialText="" OnRowDataBound="EgvPresent_RowDataBound"
        OnRowCommand="EgvPresent_RowCommand" AutoGenerateCheckBoxColumn="True" DataKeyNames="PresentId,PresentName"
        AllowPaging="True" RowDblclickBoundField="PresentId" 
        RowDblclickUrl="" IsHoldState="True">
        <Columns>
            <pe:TemplateField HeaderText="促销礼品名称" SortExpression="PresentName">
            <HeaderStyle Width="15%" />
            <ItemStyle HorizontalAlign="Left" />
                 <ItemTemplate>
                    <a href='PresentView.aspx?Type=<%# (int)Eval("PresentType") %>&presentId=<%# Eval("PresentId") %>'><asp:Label runat="server" ID="LblPresentName" Text='<%# Eval("PresentName") %>'></asp:Label></a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="Unit" HeaderText="单位" SortExpression="Unit">
                <HeaderStyle Width="6%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="价格" SortExpression="PriceMarket">
                <HeaderStyle Width="10%" />
                <ItemStyle HorizontalAlign="Left" />
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblPrice" runat="server"></pe:ExtendedLabel>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="服务期限" SortExpression="ServiceTerm">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <asp:Label runat="server" ID="LblServiceTerm"></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="Stocks" HeaderText="库存量" SortExpression="Stocks">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField DataField="AlarmNum" HeaderText="报警下限" SortExpression="AlarmNum">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="销售中" SortExpression="Saling">
                <HeaderStyle Width="6%" />
                <ItemTemplate>
                    <%#(bool)Eval("EnableSale") ? "√" : "<font color=red>×</font>"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <asp:LinkButton ID="LbtnModify" runat="server" CommandName="Modify" CommandArgument='<%# Eval("PresentId") %>'>修改</asp:LinkButton>
                    <asp:LinkButton ID="LbtnDelete" runat="server" CommandName="Del" CommandArgument='<%# Eval("PresentId") %>'
                        CausesValidation="False" OnClientClick="return confirm('是否要删除此商品？')">删除</asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="ObjPresent" runat="server" SelectMethod="GetPresentList"
        TypeName="PowerEasy.Module.Shop.BusinessLogic.Present" EnablePaging="True" MaximumRowsParameterName="maxNumberRows"
        SelectCountMethod="GetPresentTotal" StartRowIndexParameterName="startRowIndexId">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="type" QueryStringField="Type" 
                Type="Object" />
            <asp:Parameter DefaultValue="0" Name="searchType" Type="Int32" />
            <asp:Parameter DefaultValue="" Name="keyword" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <asp:Button ID="BtnDelete" runat="server" OnClientClick="return batchconfirm('是否要删除选中的记录？')" OnClick="BtnDelete_Click" Text="删除选择的促销礼品" />
    <asp:Button ID="BtnStartSale" Width="95px" runat="server" CommandName="BtnStartSale"  Text="开始销售" OnClick="ExecuteCommand" />
    <asp:Button ID="BtnStopSale" Width="95px" runat="server" CommandName="BtnStopSale" Text="停止销售" OnClick="ExecuteCommand" />
    <asp:HiddenField runat="server" Value="0" ID="HdnPresentType" />
    <asp:HiddenField runat="server" ID="HdnTypeName" />
    <strong></strong>
</asp:Content>
